"""product_route_analysis

Revision ID: e958b518ffd6
Revises: 0c088444d4aa
Create Date: 2018-04-29 19:45:57.412342

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl



# revision identifiers, used by Alembic.
revision = 'e958b518ffd6'
down_revision = '0c088444d4aa'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('product_route_analysis',
    sa.Column('uuid', sa.String(length=36), nullable=False),
    sa.Column('caracteristics', sa.SmallInteger(), nullable=True),
    sa.Column('count_profiltable_routes', sa.Integer(), nullable=True),
    sa.Column('route_plan_id', sa.Integer(), nullable=False),
    sa.Column('rate_table_id', sa.Integer(), nullable=False),
    sa.Column('code_deck_id', sa.Integer(), nullable=False),
    sa.Column('date', sa.DateTime(), nullable=True),
    sa.Column('status', sa.SmallInteger(), nullable=True),
    sa.Column('finish', sa.DateTime(), nullable=True),
    sa.Column('process', sa.Text(), nullable=True),
    sa.Column('rec_num', sa.Integer(), nullable=True),
    sa.Column('create_by', sa.String(length=100), nullable=True),
    sa.ForeignKeyConstraint(['code_deck_id'], ['code_deck.code_deck_id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['rate_table_id'], ['rate_table.rate_table_id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['route_plan_id'], ['route_strategy.route_strategy_id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('uuid')
    )
    op.create_table('product_route_analysis_log',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('uuid', sa.String(length=36), nullable=True),
    sa.Column('code', api_dnl.fields.prefix_range.PrefixRange(), nullable=True),
    sa.Column('code_name', sa.String(length=100), nullable=True),
    sa.Column('country', sa.String(length=100), nullable=True),
    sa.Column('rate', falcon_rest.db.fields.numeric.Numeric(length=30, collation=10), nullable=True),
    sa.Column('trunk_count', sa.Integer(), nullable=True),
    sa.Column('profitable_trunk_count', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['uuid'], ['product_route_analysis.uuid'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id')
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('product_route_analysis_log')
    op.drop_table('product_route_analysis')
    # ### end Alembic commands ###
