"""did_billing_operation_action

Revision ID: fd66173551bc
Revises: b04866e21b81
Create Date: 2020-05-19 16:48:51.162496

"""
from alembic import op
import sqlalchemy as sa
import falcon_rest
import api_dnl
import imp,os

#alembic_helpers = imp.load_source('alembic_helpers', ( op.get_context().script.dir + '/alembic_helpers.py'))
#if not alembic_helpers.table_has_column('xxxx', 'yyyy'):



# revision identifiers, used by Alembic.
revision = 'fd66173551bc'
down_revision = 'b04866e21b81'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('did_billing_operation_action',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('did_billing_id', sa.Integer(), nullable=True),
    sa.Column('created_by', sa.String(length=100), nullable=True),
    sa.Column('created_on', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('code', api_dnl.migration_types.ChoiceType({}), nullable=True),
    sa.Column('error', sa.Text(), nullable=True),
    sa.Column('finished_by', sa.String(length=100), nullable=True),
    sa.Column('finished_on', sa.DateTime(timezone=True), nullable=True),
    sa.ForeignKeyConstraint(['did_billing_id'], ['did_billing_rel.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_did_billing_operation_action_did_billing_id'), 'did_billing_operation_action', ['did_billing_id'], unique=False)
    op.create_table('did_transaction',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('did_billing_id', sa.Integer(), nullable=True),
    sa.Column('date', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('did_number', sa.String(length=50), nullable=False),
    sa.Column('client_id', sa.Integer(), nullable=False),
    sa.Column('mrc', api_dnl.migration_types.Numeric(length=20, collation=5), nullable=True),
    sa.Column('nrc', api_dnl.migration_types.Numeric(length=20, collation=5), nullable=True),
    sa.Column('port_fee', api_dnl.migration_types.Numeric(length=20, collation=5), nullable=True),
    sa.Column('created_on', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.ForeignKeyConstraint(['client_id'], ['client.client_id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['did_billing_id'], ['did_billing_rel.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_did_transaction_did_billing_id'), 'did_transaction', ['did_billing_id'], unique=False)
    op.add_column('balance_history_actual', sa.Column('mrc', api_dnl.migration_types.Numeric(length=20, collation=5), server_default=sa.text('0.0'), nullable=False))
    op.add_column('balance_history_actual', sa.Column('nrc', api_dnl.migration_types.Numeric(length=20, collation=5), server_default=sa.text('0.0'), nullable=False))
    op.add_column('balance_history_actual', sa.Column('port_fee', api_dnl.migration_types.Numeric(length=20, collation=5), server_default=sa.text('0.0'), nullable=False))
    op.add_column('did_billing_plan', sa.Column('rate_per_sms_received', api_dnl.migration_types.Numeric(length=15, collation=6), nullable=True))
    op.add_column('did_billing_plan', sa.Column('rate_per_sms_sent', api_dnl.migration_types.Numeric(length=15, collation=6), nullable=True))
    op.drop_column('did_vendor_api', 'nrc')
    op.drop_column('did_vendor_api', 'rate_per_sms_received')
    op.drop_column('did_vendor_api', 'mrc')
    op.drop_column('did_vendor_api', 'vendor_rate_per_sms_sent')
    op.drop_column('did_vendor_api', 'vendor_rate_per_sms_received')
    op.drop_column('did_vendor_api', 'rate_per_sms_sent')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('did_vendor_api', sa.Column('rate_per_sms_sent', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True))
    op.add_column('did_vendor_api', sa.Column('vendor_rate_per_sms_received', sa.NUMERIC(), server_default=sa.text('0.0'), autoincrement=False, nullable=True))
    op.add_column('did_vendor_api', sa.Column('vendor_rate_per_sms_sent', sa.NUMERIC(), server_default=sa.text('0.0'), autoincrement=False, nullable=True))
    op.add_column('did_vendor_api', sa.Column('mrc', sa.VARCHAR(length=10), autoincrement=False, nullable=True))
    op.add_column('did_vendor_api', sa.Column('rate_per_sms_received', sa.NUMERIC(precision=15, scale=6), autoincrement=False, nullable=True))
    op.add_column('did_vendor_api', sa.Column('nrc', sa.VARCHAR(length=10), autoincrement=False, nullable=True))
    op.drop_column('did_billing_plan', 'rate_per_sms_sent')
    op.drop_column('did_billing_plan', 'rate_per_sms_received')
    op.drop_column('balance_history_actual', 'port_fee')
    op.drop_column('balance_history_actual', 'nrc')
    op.drop_column('balance_history_actual', 'mrc')
    op.drop_index(op.f('ix_did_transaction_did_billing_id'), table_name='did_transaction')
    op.drop_table('did_transaction')
    op.drop_index(op.f('ix_did_billing_operation_action_did_billing_id'), table_name='did_billing_operation_action')
    op.drop_table('did_billing_operation_action')
    # ### end Alembic commands ###
"""
ADDONS
"""
def up_rec(table):
    """
    create record table and triggers for table
    :return:
    """
    sql= """
    --{table} trigger--
drop trigger IF EXISTS class4_trig_record_{table} on {table};
drop table IF EXISTS {table}_record;
DROP FUNCTION IF EXISTS class4_trigfun_record_{table}();
DROP SEQUENCE IF EXISTS {table}_record_record_id_seq;
SELECT * INTO {table}_record FROM {table} where false;
alter table {table}_record add time numeric;
alter table {table}_record add flag character(1);
alter table {table}_record add record_id integer;
alter table {table}_record alter COLUMN record_id SET NOT NULL;
create SEQUENCE {table}_record_record_id_seq;
alter table {table}_record alter COLUMN record_id SET DEFAULT nextval('{table}_record_record_id_seq'::regclass);

create function class4_trigfun_record_{table}() returns trigger as $$
begin
        if(TG_OP='INSERT')then
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'I';
        elseif(TG_OP='DELETE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'D';
        elseif(TG_OP='UPDATE')then
                insert into {table}_record select OLD.*,EXTRACT(EPOCH from current_timestamp(0)),'B';
                insert into {table}_record select NEW.*,EXTRACT(EPOCH from current_timestamp(0)),'A';
        end if;
return null;
end;
$$ language plpgsql;

create trigger class4_trig_record_{table} after update or insert or delete on {table} for each row execute procedure class4_trigfun_record_{table}();

create index c4_{table}_record_id_idx on {table}_record (record_id);
create index {table}_record_time_idx on {table}_record using btree (time);
    """
    connection = op.get_bind()
    connection.execute(sql.format_map(dict(table=table)))