
from marshmallow import fields
from falcon_rest.schemes import ObjectsListScheme,Schema,SuccessScheme

class ObjectUpdatedScheme(Schema):
    updated = fields.Int()
    deleted = fields.Int()


class ObjectsListWithSummarySchemeInner(Schema):
    total = fields.Integer()
    page = fields.Integer()
    per_page = fields.Integer()
    summary = fields.Dict()
    items = fields.Dict(many=True)


class ObjectsListWithSummaryScheme(SuccessScheme):
    payload = fields.Nested(ObjectsListWithSummarySchemeInner())