from datetime import datetime, timedelta

from pytz import UTC
from sqlalchemy import (and_)
from sqlalchemy.orm import foreign
from sqlalchemy.sql import func
import redis
import time

from api_dnl import model,settings
from api_dnl.model import Client, Resource, BalanceHistoryActual, MailSender, User, RateSendLogDetail, DailyCdrField, \
    CdrExportTask, FrundDetection, FrundDetectionHistory, SystemParameter,MonitoredRuleHistory, CdrAsyncTask
from api_dnl.tasks import app, log, db, SqlAlchemyTask
from api_dnl.utils.imp_exp import (csv2xls, dict_to_csv)

TEST_TO = settings.TEST_TO


@app.task(base=SqlAlchemyTask)
def do_clear_last_lowbalance_send_time():
    # ??is_daily_balance_notification
    query = Client.filter(Client.status == True).filter(Client.last_lowbalance_time.isnot(None)).all()
    for cl in query:
        try:
            lb = cl.low_balance_config
            if not lb:
                continue
            c4 = cl.c4
            if not c4:
                log.warning('No c4_client_balance for: {}'.format(cl.client_id))
                continue
            if not cl.low_balance_notice:
                cl.last_lowbalance_time = None
            if lb.value_type == 'Actual Balance':
                if cl.mode == 'prepay' and lb.actual_notify_balance is not None and c4.balance > lb.actual_notify_balance:
                    cl.last_lowbalance_time = None
                if cl.mode == 'postpay' and c4.balance > cl.notify_client_balance-cl.allowed_credit:
                    cl.last_lowbalance_time = None
            if lb.value_type == 'Percentage':
                if c4.balance > cl.allowed_credit - lb.percentage_notify_balance * cl.allowed_credit / 100:
                    cl.last_lowbalance_time = None
            if cl.last_lowbalance_time is None:
                log.info('do_clear_last_lowbalance_send_time: balance was over notify client_id:{} balance:{} clear '
                         'last_lowbalance_time'.format(cl.client_id, c4.balance))
                cl.save()
        except Exception as e:
            log.warning('do_clear_last_lowbalance_send_time low error: {}'.format(e))
    query = Client.filter(Client.status == True).filter(Client.zero_balance_notice == True) \
        .filter(Client.zero_balance_notice_last_sent.isnot(None)).all()
    for cl in query:
        try:
            c4 = cl.c4
            if (cl.mode == 'prepay' and c4.balance > 0) or (cl.mode == 'postpay' and c4.balance > cl.allowed_credit):
                cl.zero_balance_notice_last_sent = None
                log.info('do_clear_last_lowbalance_send_time: balance was positive clear '
                         'zerobalance send - client_id:{} balance:{}'.format(cl.client_id, c4.balance))
                cl.save()
        except Exception as e:
            log.warning('do_clear_last_lowbalance_send_time zero error: {}'.format(e))
            db.session.rollback()


def znr(balance):
    dec = model.get_default_billing_decimal()
    if not balance:
        return '0'
    balance = float(balance)
    if balance < 0:
        return '(%.{}f)'.format(dec) % -balance
    else:
        return '%.{}f'.format(dec) % balance


@app.task(base=SqlAlchemyTask)
def do_notify_client_balance():
    start_time = time.time()
    query = Client.filter(Client.status == True).filter(Client.low_balance_notice == True)
    # .filter(Client.client_id==4772)
    for cl in query:
        try:
            log.debug('do_notify_client_balance: client_id: {}'.format(cl.client_id))
            lb = cl.low_balance_config
            if not lb:
                log.warning('do_notify_client_balance: not low_balance_config')
                continue
            c4 = cl.c4
            if not c4:
                log.warning('do_notify_client_balance:No c4_client_balance')
                continue
            if cl.mode == 'postpay' and cl.unlimited_credit:
                log.warning('do_notify_client_balance: mode=postpay and unlimited_credit')
                continue
            if lb.value_type == 'Actual Balance':
                if cl.mode == 'prepay' and lb.actual_notify_balance is not None and c4.balance > lb.actual_notify_balance:
                    log.warning('do_notify_client_balance: mode=prepay and balance({}) > actual_notify_balance({})'
                                .format(c4.balance, lb.actual_notify_balance))
                    continue
                if cl.mode == 'postpay' and c4.balance > cl.notify_client_balance-cl.allowed_credit:
                    log.warning('do_notify_client_balance: mode=postpay and '
                                'balance({}) > notify_client_balance({})-allowed_credit({})'
                                .format(c4.balance, cl.notify_client_balance, cl.allowed_credit))
                    continue
            elif lb.value_type == 'Percentage':
                if c4.balance > cl.allowed_credit - lb.percentage_notify_balance * cl.allowed_credit / 100:
                    log.warning('do_notify_client_balance: balance({}) > allowed_credit({}) - '
                                'percentage_notify_balance({}) * allowed_credit({}) / 100'
                                .format(c4.balance, cl.allowed_credit, lb.percentage_notify_balance, cl.allowed_credit))
                    continue
            else:
                log.debug('Unknown value type')
                continue
                # raise Exception('Unknown value type in client {}'.format(cl.client_id))
            if cl.last_lowbalance_time:
                if lb.send_time_type == 'daily' and lb.last_alert_time is not None and \
                        lb.last_alert_time.date() == datetime.now(UTC).date():
                    continue
                elif lb.send_time_type == 'hourly' and lb.last_alert_time is not None and \
                        (datetime.now(UTC) - lb.last_alert_time) < timedelta(hours=1):
                    continue
                if datetime.now(UTC) - cl.last_lowbalance_time <= timedelta(days=lb.duplicate_send_days):
                    log.warning('do_notify_client_balance: now() - last_lowbalance_time({}) > timedelta({} days)'
                                .format(cl.last_lowbalance_time, lb.duplicate_send_days))
                    continue
                if lb.disable_trunks_days and datetime.now(UTC) - cl.last_lowbalance_time > timedelta(days=lb.disable_trunks_days):
                    for tr in cl.ingress_trunks:
                        if tr.is_active:
                            tr.is_active = False
                            # todo which mail to send?
                            # if cl.is_send_trunk_update:
                            #     tr.apply_mail('trunk_change',to=TEST_TO)
                    if cl.status:
                        log.info('do_notify_client_balance: disable_trunks_days reached, disable client {}'.format(
                            cl.client_id))
                        cl.status = False
                        cl.save()
            else:
                log.info('do_notify_client_balance: set last_lowbalance_time')
                cl.last_lowbalance_time = datetime.now(UTC)
                cl.save()
            if lb.is_notify is True or lb.is_notify is None:
                log.info('do_notify_client_balance: send mail')
                cl.apply_mail('lowbalance', to=TEST_TO)
            lb.last_alert_time = datetime.now(UTC)
            lb.save()
        except Exception as e:
            log.warning('do_notify_client_balance: error {}'.format(e))
            db.session.rollback()

    log.info('do_notify_client_balance: finished, duration: {:.1f} seconds'.format(time.time() - start_time))


@app.task(base=SqlAlchemyTask)
def do_notify_zero_balance():
    query = Client.filter(Client.status == True).filter(Client.zero_balance_notice == True).all()
    for cl in query:
        try:
            log.debug('do_notify_zero_balance: client_id: {}'.format(cl.client_id))
            c4 = cl.c4
            if not c4:
                log.warning('do_notify_zero_balance:No c4_client_balance for: {}'.format(cl.client_id))
                continue
            if (cl.mode == 'prepay' and c4.balance > 0) or (cl.mode == 'postpay' and c4.balance > cl.allowed_credit) \
                    or (cl.mode == 'postpay' and cl.unlimited_credit):
                log.warning('do_notify_zero_balance: client: {}, mode: {}, balance:{}, allowed_credit:{}, '
                            'unlimited_credit: {} '
                            .format(cl.client_id, cl.mode, c4.balance, cl.allowed_credit, cl.unlimited_credit))
                continue
            if cl.zero_balance_notice_last_sent:
                if datetime.now(UTC) - cl.zero_balance_notice_last_sent < timedelta(days=1):
                    log.warning('do_notify_zero_balance: zero_balance_notice_last_sent 1')
                    continue
                if not datetime.now().minute in range(0, 4):
                    log.warning('do_notify_zero_balance: zero_balance_notice_last_sent 2')
                    continue
                log.info(
                    'do_notify_zero_balance: hourly repeat notification to client {} due to '
                    'zero_balance_notice_last_sent more a day ago ()'.format(cl.client_id,
                                                                             cl.zero_balance_notice_last_sent))
            else:
                pass
            log.info('do_notify_zero_balance: send mail for client {} and set zero_balance_notice_last_sent'.format(
                cl.client_id))
            cl.zero_balance_notice_last_sent = datetime.now(UTC)
            cl.save()
            cl.date = datetime.now(UTC).date()
            cl.apply_mail('zerobalance', to=TEST_TO)
        except Exception as e:
            log.warning('do_notify_zero_balance: error {}'.format(e))
            db.session.rollback()


@app.task(base=SqlAlchemyTask, time_limit=37000, soft_time_limit=36000)
def do_daily_usage_summary():

    r = redis.Redis(host='localhost', port=6379, db=0)
    is_new_task = r.setnx('do_daily_usage_summary', 1)
    if not is_new_task:
        log.warning('do_daily_usage_summary: another task is running, quit')
        return False
    r.expire('do_daily_usage_summary', 300)

    query = Client.filter(Client.status == True).filter(and_(Client.is_show_daily_usage == True,
                                                             Client.is_auto_summary == True)).all()
    now = datetime.now(UTC)
    rep_date = (now - timedelta(days=1)).date().strftime('%Y%m%d')
    report = model.cdr_report_detail(rep_date)
    if report is None:
        log.warning('do_daily_usage_summary: cdr_report_detail{} missing, quit'.format(rep_date))
        return False
    conf = model.SystemParameter.get(1)

    """class Report(CrdReportDetailTable,DnlApiBaseModel):
        __tablename__ = report_table
        __mapper_args__ = {'concrete': True}
        __table_args__ = (PrimaryKeyConstraint(
            'ingress_client_id', 'ingress_id', 'egress_client_id', 'egress_id', 'product_rout_id', 'agent_id',
            'ingress_rate_table_id', 'route_plan_id', 'par_id', 'report_time'
        ),)"""
    for cl in query:
        try:
            elog = model.EmailLog
            last_sent = elog.filter(and_(elog.send_time >= now - timedelta(days=1),
                                         elog.send_time >= now,
                                         elog.client_id == cl.client_id,
                                         elog.type == 'auto_summary'))
            # if last_sent:
            #     log.debug('Email already sent for: {} , continue'.format(cl.client_id))
            #     continue
            if not cl.is_auto_report_time(datetime.now(UTC)):
                log.debug('No daily_usage_summary time for: {} , continue'.format(cl.client_id))
                continue
            c4 = cl.c4
            if not c4:
                continue

            def object_as_dict(obj):
                if obj:
                    return {key: getattr(obj, key) for key in obj._fields}
                else:
                    return {}

            buy = db.session.query(
                func.sum(report.c.ingress_total_calls).label('total_call_buy'),
                func.sum(report.c.not_zero_calls).label('total_non_zero_calls_buy'),
                func.sum(report.c.ingress_success_calls).label('total_success_calls_buy'),
                func.round(func.sum(report.c.ingress_bill_time) / 60.0, 2).label('total_billed_min_buy'),
                func.round(func.sum(report.c.ingress_call_cost), 2).label('total_billed_amount_buy'),
                func.round(func.sum(report.c.duration/60.0), 2).label('buy_total_duration'),
            ).filter(report.c.ingress_client_id == cl.client_id).group_by(report.c.ingress_client_id).first()
            sell = db.session.query(
                func.sum(report.c.egress_total_calls).label('total_call_sell'),
                func.sum(report.c.not_zero_calls).label('total_non_zero_calls_sell'),
                func.sum(report.c.egress_success_calls).label('total_success_calls_sell'),
                (func.sum(report.c.egress_bill_time) / 60).label('total_billed_min_sell'),
                func.round(func.sum(report.c.egress_call_cost), 2).label('total_billed_amount_sell'),
                func.sum(report.c.duration).label('sell_total_duration'),
            ).filter(report.c.egress_client_id == cl.client_id).group_by(report.c.egress_client_id).first()
            buy = object_as_dict(buy)
            if not buy:
                buy = dict(total_call_buy=0, total_non_zero_calls_buy=0, total_success_calls_buy=0,
                           total_billed_min_buy=0, total_billed_amount_buy=0, buy_total_duration=0)
            sell = object_as_dict(sell)
            if not sell:
                sell = dict(total_call_sell=0, total_non_zero_calls_sell=0, total_success_calls_sell=0,
                            total_billed_min_sell=0, total_billed_amount_sell=0, sell_total_duration=0)
            log.debug(buy)
            log.debug(sell)
            cl.__dict__.update(buy)
            cl.__dict__.update(sell)
            att = []
            try:
                buy_detail = db.session.query(
                    model.Resource.alias.label('ingress_trunk_name'),
                    func.sum(report.c.ingress_total_calls).label('total_call_buy'),
                    func.sum(report.c.not_zero_calls).label('total_non_zero_calls_buy'),
                    func.sum(report.c.ingress_success_calls).label('total_success_calls_buy'),
                    (func.sum(report.c.ingress_bill_time) / 60.0).label('total_billed_min_buy'),
                    func.round(func.sum(report.c.ingress_call_cost), 2).label('total_billed_amount_buy'),
                    func.sum(report.c.duration).label('buy_total_duration'),
                ).filter(and_(model.Resource.resource_id == report.c.ingress_id,
                              report.c.ingress_client_id == cl.client_id)).group_by(report.c.ingress_code_name, model.Resource.alias).all()
                ret = [object_as_dict(buy) for buy in buy_detail]
                if ret:
                    csv = dict_to_csv(ret)
                    # att = [('csv', csv)]
                    xls = csv2xls(csv, 'Daily buy summary for {}'.format(cl.name))
                    att.append(('daily_buy_summary_{}.xls'.format(rep_date), xls))
                sell_detail = db.session.query(
                    model.Resource.alias.label('egress_trunk_name'),
                    func.sum(report.c.egress_total_calls).label('total_call_sell'),
                    func.sum(report.c.not_zero_calls).label('total_non_zero_calls_sell'),
                    func.sum(report.c.egress_success_calls).label('total_success_calls_sell'),
                    (func.sum(report.c.egress_bill_time) / 60).label('total_billed_min_sell'),
                    func.round(func.sum(report.c.egress_call_cost), 2).label('total_billed_amount_sell'),
                    func.sum(report.c.duration).label('sell_total_duration'),
                ).filter(and_(model.Resource.resource_id == report.c.egress_id,
                              report.c.egress_client_id == cl.client_id)).group_by(report.c.egress_code_name, model.Resource.alias).all()
                ret = [object_as_dict(sell) for sell in sell_detail]
                if ret:
                    csv = dict_to_csv(ret)
                    # att = [('csv', csv)]
                    xls = csv2xls(csv, 'Daily sell summary for {}'.format(cl.name))
                    att.append(('daily_sell_summary_{}.xls'.format(rep_date), xls))
            except Exception as e:
                log.warning('do_daily_usage_summary cannot attach report: {}'.format(e))

            report_date = (now - timedelta(days=1)).date()
            cl.fmt_begin_time = str(report_date) + ' 00:00:00+00:00'
            cl.fmt_end_time = str(report_date) + ' 23:59:59+00:00'
            cl.fmt_customer_gmt = cl.auto_send_zone
            b0 = BalanceHistoryActual.filter(BalanceHistoryActual.client_id == cl.client_id). \
                filter(BalanceHistoryActual.date == str(report_date)).first()
            cl.fmt_actual_received = b0.payment_received if (b0 and not b0.payment_received is None) else '0.00'
            cl.switch_alias = conf.switch_alias
            log.debug('do_daily_usage_summary: send mail for client {}'.format(cl.name))
            MailSender.apply_mail(cl, 'auto_summary', to=TEST_TO, att=att)

        except Exception as e:
            log.warning('do_daily_usage_summary: {}'.format(e))
            db.session.rollback()
    r.delete('do_daily_usage_summary')


@app.task(base=SqlAlchemyTask)
def do_daily_balance_summary():
    conf = model.SystemParameter.get(1)
    query = Client.filter(Client.status == True).filter(Client.is_daily_balance_notification == True).all()
    log.debug('do_daily_balance_summary check clients {}'.format(','.join([str(cl.client_id) for cl in query])))
    for cl in query:
        try:
            now=datetime.now(UTC)
            if not cl.is_auto_report_time(now):
                log.debug('No daily_balance_summary time for: {} , continue'.format(cl.client_id))
                continue
            c4 = cl.c4
            if not c4:
                log.warning('No c4_client_balance for: {}'.format(cl.client_id))
                continue
            report_end = now.date()
            report_start = report_end - timedelta(days=1)
            b0 = BalanceHistoryActual.filter(BalanceHistoryActual.client_id == cl.client_id). \
                filter(BalanceHistoryActual.date == report_start).first()
            # if not b0:
            #     log.warning('No BalanceHistoryActual for: {} at {}'.format(cl.client_id, report_start))
            #     continue

            # cl.company_name = cl.company
            cl.client_name = cl.name
            cl.current_day = now.date()
            cl.current_time = now.timetz()
            cl.now = now
            # tz=cl.daily_cdr_generation_zone
            # cl.start_time=str(tz_align(report_start, tz))[0:19]
            cl.fmt_start_time = str(report_start)[0:19]
            cl.beginning_of_day = cl.fmt_start_time
            cl.fmt_end_time = str(report_end)[0:19]
            cl.fmt_customer_gmt = cl.auto_send_zone
            # cl.balance = '%.2f' % float(cl.balance())

            cl.fmt_beginning_balance = znr(b0.actual_balance) if b0 else None
            cl.begining_of_day = report_start  ##-timedelta(hours=24)
            cl.beginning_of_day_balance = cl.fmt_beginning_balance
            cl.ending_balance = znr(c4.balance)
            cl.current_balance = cl.ending_balance
            incoming = b0.unbilled_incoming_traffic if b0 else None
            outcoming = b0.unbilled_outgoing_traffic if b0 else None
            cl.buy_amount = incoming
            cl.sell_amount = outcoming

            # = '%.2f' % -float(cl.allowed_credit)
            rem = -float(cl.allowed_credit) - abs(float(c4.balance))

            # if cl.mode == 2:
            #    cl.fmt_remaining_credit = _f(rem)
            # else:
            #    cl.fmt_remaining_credit = '0'  # 'N/A'
            # cl.beginning_of_day_balance='%.2f' % bl.actual_balance
            cl.fmt_allowed_credit = '%.2f' % -float(cl.allowed_credit)
            cl.switch_alias = conf.switch_alias
            cl.apply_mail('auto_balance', to=TEST_TO)
        except Exception as e:
            log.warning('do_daily_balance_summary: {}'.format(e))
            db.session.rollback()


@app.task(base=SqlAlchemyTask)
def do_daily_cdr_delivery():
    conf = model.SystemParameter.get(1)
    d1 = datetime.now(UTC).replace(hour=0, minute=0, second=0, microsecond=0)
    d0 = d1 - timedelta(days=1)
    ts1 = int(d1.timestamp())
    ts0 = int(d0.timestamp())
    query = Client.filter(Client.status == True).filter(Client.daily_cdr_generation == True).all()
    for client in query:
        try:
            from api_dnl.tasks import do_cdr_async_task, do_cdr_email_async_task
            if not client.is_auto_report_time(datetime.now(UTC)):
                log.debug('No daily_cdr_generation time for: {} , continue'.format(client.client_id))
                continue
            fields = conf.invoices_cdr_fields
            all_fields = model.DailyCdrField.query().filter(model.DailyCdrField.id.notin_([96, 108])).all()
            allowed_fields = set([str(f.field) for f in all_fields if f.client_viewable])
            fields = set(fields.split(',')) if fields else set()
            params = dict(start_time=ts0, end_time=ts1, ingress_id=client._ingress(), non_zero=1,
                          human_readable=1, format='csv')
            params['field'] = ','.join(list(fields.intersection(allowed_fields) if fields else list(allowed_fields)))
            log.debug('do_daily_cdr_delivery called params: {}'.format(params))
            task = CdrAsyncTask(request_client_id=client.client_id, filter=params)
            request_id = task.save()
            do_cdr_async_task(request_id)
            do_cdr_email_async_task(request_id)
            task = CdrAsyncTask.get(request_id)
            log.debug('do_daily_cdr_delivery file created {}'.format(task.orig_file))
        except Exception as e:
            log.warning('daily_cdr_generation: {}'.format(e))
            db.session.rollback()


@app.task(base=SqlAlchemyTask)
def do_trunk_pending_suspension_notice():
    log.debug('trunk_pending_suspension_notice')
    query = RateSendLogDetail.filter(
        and_(RateSendLogDetail.status == 'Not Yet Downloaded', RateSendLogDetail.download_date.is_(None))). \
        join(Resource, foreign(RateSendLogDetail.resource_id) == Resource.resource_id)  # .filter(Resource.active==True)
    now = datetime.now(UTC)
    q = query.all()
    log.debug('trunk_pending not dowloaded {}'.format(len(q)))
    already_sent = []
    for item in q:
        try:
            if not item.download_deadline:
                continue
            d = item.download_deadline
            download_deadline = datetime(d.year, d.month, d.day, tzinfo=UTC)
            sec = (download_deadline - now).total_seconds()
            delta = int(sec // 3600)
            log.debug('trunk_pending_suspension_notice checks: id {} trunk {} delta {} deadline {} now {} '.format(
                item.job_id, item.resource.resource_id, delta, item.download_deadline, now))
            if item.resource.resource_id in already_sent:
                item.error = tpl + ' mail sent'
                continue
            if delta in (48, 24, 3, 1) and item.resource.active and item.parent_job.is_email_alert:
                item.client = item.resource.client
                tpl = 'hour_{}_suspension_warning'.format(delta) #tpl = 'hour_{}'.format(delta)
                ret = MailSender.apply_mail(item, tpl, to=TEST_TO)
                already_sent += [item.resource.resource_id]
                if ret:
                    item.error = tpl + ' mail error {}'.format(ret)
                else:
                    item.error = tpl + ' mail sent'
                log.debug('trunk_pending_suspension_notice mail:{}'.format(ret))
                continue
            if delta <= 0:
                if item.parent_job.is_disable:
                    if item.parent_job.is_disable:
                        r = item.resource
                        r.active = False
                        user = User.get(1)
                        r.save(save_history=True, user=user)
                        item.error = 'trunk was blocked by api_dnl daemon'
                    else:
                        item.error = 'download date expired by api_dnl daemon'
                    item.download_date = now.date()
                    item.status = 'completed'
                    item.client = item.resource.client
                    ret = '0 is_email_alert=false'
                    if item.parent_job.is_email_alert:
                        if item.parent_job.is_disable:
                            ret = MailSender.apply_mail(item, 'pending_trunk', to=TEST_TO)
                        else:
                            ret = MailSender.apply_mail(item, 'no_download_rate', to=TEST_TO)
                        if ret:
                            item.error = item.error + ' mail error:{}'.format(str(ret))
                    item.save()
                    log.debug('trunk_pending_suspension_notice blocked:{} send:{}'.format(item.error, str(ret)))
                else:
                    item.error = 'download date for inactive trunk expired by trunk_pending daemon'
                    item.status = 'completed'
                    log.debug('trunk_pending_suspension_notice {}'.format(item.error))
                    item.save()
        except Exception as e:
            log.error('trunk_pending_suspension_notice id {} error {}'.format(item.id, str(e)))
    log.debug('trunk_pending finished')


@app.task(base=SqlAlchemyTask)
def do_frund_detection():
    log.debug('Start frund detection!')
    query = FrundDetectionHistory.filter(and_(FrundDetectionHistory.frund_detection_id == FrundDetection.id,
                                                 FrundDetection.send_email_type != 'None',
                                                 FrundDetection.send_email_type.isnot(None),
                                                 FrundDetectionHistory.api_email_send_time.is_(None),
                                                 FrundDetectionHistory.create_time > datetime.now()-timedelta(days=10)))
    for obj in query.all():
        frund_detection(obj.id)
    pass


@app.task(base=SqlAlchemyTask)
def frund_detection(id):
    try:
        fd = FrundDetectionHistory.get(id)
        if fd:
            if fd.ingress_id:
                trunk = fd.trunk
                if trunk is None:
                    log.debug('Ingress trunk {} not exists, skip'.format(fd.ingress_id))
                    return
                ingress_id = fd.ingress_id
                if not trunk.client:
                    log.debug('Ingress trunk {} has no client_id , skip'.format(ingress_id))
                    return
                email_to = fd.rule.send_email_type
                if email_to != 'None' and email_to is not None:
                    log.info('Fraud detected of Ingress trunk {}:{}'.format(trunk.alias, fd))

                    if fd.api_email_send_time is None:
                        # todo not repeat mail
                        to = ''
                        if email_to in ['Your Own NOC', 'Both NOC']:
                            sys = SystemParameter.session().query(SystemParameter.noc_email).first()
                            if sys.noc_email and not sys.noc_email == '':
                                fd.system_email = sys.noc_email
                                to = to + sys.noc_email + ';'
                            else:
                                log.warning('No noc_email in system_parameters configured')
                        if email_to in ['Partner NOC', 'Both NOC']:
                            if trunk.client.noc_email and not trunk.client.noc_email == '':
                                fd.partner_email = trunk.client.noc_email
                                to = to + trunk.client.noc_email
                            else:
                                log.warning('No noc_email in client {} configured '.format(trunk.client_id))
                        if not to:
                            log.warning('No any email in client {} configured '.format(trunk.client_id))
                            return
                        if TEST_TO:
                            to = to + ';' + TEST_TO
                        trunk.block_value = fd.block_value
                        trunk.limit_value = fd.limit_value
                        trunk.rule_name = fd.rule_name
                        trunk.rule_type = fd.block_type
                        trunk.alert_time = fd.create_time
                        if not fd.rule.email_ticket_content:
                            mail_not_sent = trunk.apply_mail('fraud_detection', to=to)
                        else:
                            mail_not_sent = trunk.apply_mail('frund_{}'.format(fd.frund_detection_id), to=to)
                        log.debug('Fraud detection email to {} sent {}'.format(to, not bool(mail_not_sent)))
                        fd.api_email_send_time = datetime.now(UTC)
                        fd.api_email_result = mail_not_sent if mail_not_sent else 'ok'
                        fd.system_email_status = not bool(mail_not_sent)
                        fd.partner_email_status = not bool(mail_not_sent)
                        fd.save()
            log.debug('Fraud detection {} finished'.format(id))

    except Exception as e:
        log.error('frund_detection id={} error:{}'.format(id, str(e)))
        db.session.rollback()

@app.task(base=SqlAlchemyTask)
def do_monitored_rule_history():
    result = []
    is_rule_present = False
    try:
        for obj in MonitoredRuleHistory.filter(and_(  # MonitoredRuleHistory.unblock_time.isnot(None),
                MonitoredRuleHistory.api_email_send_time.is_(None),
                MonitoredRuleHistory.create_time > datetime.now() - timedelta(days=10))).all():
            if not is_rule_present:
                is_rule_present = True
                log.debug('do_monitored_rule_history started')
            rule = obj.monitored_rule
            trunk = Resource.get(obj.trunk_id)
            if rule.send_email_type != 'None':
                if rule.email_from:
                    obj.from_mail_id = rule.email_from
                to = []
                sys = SystemParameter.get(1)
                if rule.send_email_type in ['Your Own NOC', 'Both NOC']:
                    if sys.noc_email and not sys.noc_email == '':
                        to.append(sys.noc_email)
                    else:
                        result.append('No noc_email in system_parameters configured')
                        log.warning('No noc_email in system_parameters configured')

                if rule.send_email_type in ['Partner NOC', 'Both NOC']:

                    if not trunk:
                        result.append('Trunk {} not exists'.format(obj.trunk_id))
                        log.debug('Trunk {} not exists'.format(obj.trunk_id))
                    else:
                        if trunk.client.noc_email and not trunk.client.noc_email == '':
                            to.append(trunk.client.noc_email)
                        else:
                            log.warning('No noc_email in client {} configured '.format(trunk.client_id))
                if to:
                    mail_not_sent = MailSender.apply_mail(obj, 'monitoredrule_' + str(rule.id), to=';'.join(to))
                    log.debug('Alert rule email to {} sent'.format(to))
                    if mail_not_sent:
                        result.append('Mail not send: system error')
                    else:
                        result.append('success')
                else:
                    mail_not_sent = 'no address'
                    log.debug('Alert rule email not sent - no one address')
                    result.append('Mail not send: no address')

            obj.api_email_result = (','.join(result))[:1024]
            obj.api_email_send_time = datetime.now(UTC)
            obj.save()
    except Exception as e:
        log.debug('do_monitored_rule_history error %s' % str(e))
    if is_rule_present:
        log.debug('do_monitored_rule_history finished')