import celery
from api_dnl import settings
from datetime import datetime, timedelta
from pytz import UTC
from time import mktime
import io, csv, gzip, zipfile
import xlwt
import json
import traceback
from celery import Celery

from celery.app.log import get_logger, mlevel
from celery.schedules import crontab
from falcon_rest.db import initialize_db
from sqlalchemy import (
    Integer, SmallInteger, Float, Text, String, DateTime, Date, Time, Boolean, ForeignKey, BigInteger,
    Table
)
from sqlalchemy import (Column, desc, and_, text as text_, PrimaryKeyConstraint, inspect, Index, UniqueConstraint)
from sqlalchemy.sql import func, select, alias, case

import csv

from ..view import IntegrityError
from ..model import DnlApiBaseModel, User, Client, Resource,ProductItems
from ..model import DidBillingPlan, DidBillingRel, DidNumberUpload, DidNumberDeleteTask, DidNumberAssignTask,DidParam,\
ShakenAniGroupRelImportTask,ShakenAniGroup,ShakenAniGroupRel, DidClientLog
from ..tasks import app, log, db, SqlAlchemyTask, Singleton
from .. import model
from .. import view


@app.task(base=SqlAlchemyTask)
def do_did_import_file():
    log.info('start do_import_file ')
    q = DidNumberUpload.filter(DidNumberUpload.status == 'initial').order_by(DidNumberUpload.created_on).first()
    if q:
        did_import_file.delay(q.uuid)
    log.info('finish do_import_file ')


import re


PHONE_REGEXP = r'^\+?[0-9]+$'


@app.task(base=SqlAlchemyTask, time_limit=288000, soft_time_limit=287400)
def did_delete_all(dids=None):
    log.info('start did_delete_all')
    try:
        if not dids:
            db.session.execute("update did_client_log set released_on = now() where released_on is null;")
            db.session.execute("delete from product_items where product_id = 1 and digits::varchar in ( select did from did_billing_rel);")
            db.session.execute("delete from resource_prefix where code::varchar in ( select did from did_billing_rel);")
            db.session.execute("delete from did_billing_rel;")
        else:
            did_list = [did.strip() for did in dids.split(',')]
            # Validate each DID matches phone number pattern to prevent SQL injection
            for did in did_list:
                if not re.match(PHONE_REGEXP, did):
                    log.debug(f"SQL_INJECTION_ATTEMPT: did_delete_all invalid DID format: {repr(did)}")
                    log.error('did_delete_all invalid DID format: {}'.format(did))
                    return
            did_tuple = tuple(did_list)
            db.session.execute(
                text_("update did_client_log set released_on = now() where released_on is null and did in :dids"),
                {'dids': did_tuple}
            )
            db.session.execute(
                text_("delete from product_items where product_id = 1 and digits::varchar in :dids"),
                {'dids': did_tuple}
            )
            db.session.execute(
                text_("delete from resource_prefix where code::varchar in :dids"),
                {'dids': did_tuple}
            )
            db.session.execute(
                text_("delete from did_billing_rel where did in :dids"),
                {'dids': did_tuple}
            )
    except Exception as e:
        log.error('did_delete_all did not deleted {}'.format(e))
        try:
            db.session.rollback()
        except Exception as e1:
            log.error('did_delete_all did not rolled back {}'.format(e1))
    log.info('finish did_delete_all')


@app.task(base=Singleton, time_limit=288000, soft_time_limit=287400)
def did_import_file(id):
    log.info('start import_file {}'.format(id))
    tsk = DidNumberUpload.get(id)
    from falcon_rest import logger
    logger.log.setLevel(mlevel('ERROR'))
    log.setLevel(mlevel('ERROR'))
    if tsk and tsk.status == 'initial':
        tsk.status = 'busy'
        errors = []
        try:
            file = open(tsk.file_name)
            data = file.readlines()
            assigned_by = tsk.created_by
            user = None
            if assigned_by:
                user = User.filter(User.name == assigned_by).first()
                if not user:
                    raise Exception('import task from unknown user')
                user_name = assigned_by
            vendor_id = tsk.vendor_id
            vendor_res_id = None
            vendor_res = None
            if vendor_id:
                vendor = Client.get(vendor_id)
                vendor_res_id = vendor.resource.resource_id
                vendor_res = Resource.get(vendor_res_id)
            vendor_billing_rule = None
            rate_table = None
            if tsk.vendor_billing_rule_id:
                vendor_billing_rule = DidBillingPlan.get(tsk.vendor_billing_rule_id)
                rate_table = vendor_billing_rule.rate_table

            client_id = tsk.client_id
            client = Client.get(client_id)
            client_res_id = None
            client_res = None
            client_rule = None
            if client:
                client_res_id = client.resource.resource_id
                client_res = Resource.get(client_res_id)
                client_rule = DidBillingPlan.get(tsk.client_billing_rule_id)

            i = 0
            sk_i = 0
            for row in data:
                num = row.strip().lower()
                row_errors = ''
                if 'num' in num.lower() or 'did' in num.lower():
                    continue
                i = i + 1
                if not re.match(PHONE_REGEXP, num):
                    sk_i = sk_i + 1
                    errors.append('row {}: skip bad number {}'.format(i, num))
                    continue
                if len(num) < 10:
                    sk_i = sk_i + 1
                    errors.append('row {}: skip bad number {}'.format(i, num))
                    continue
                if len(num) == 10:
                    num = '1' + num
                if row_errors:
                    errors.append('row {}:{}'.format(i, row_errors))
                if i % 500 == 0:
                    print('numbers imported {}'.format(i))
                    tsk.num_imported = i
                    tsk.result = 'numbers imported {}'.format(i)
                    tsk.save()
                try:
                    number0 = DidBillingRel.filter(DidBillingRel.did == num).first()
                    if number0:
                        if tsk.duplicates_action == 'skip':
                            sk_i = sk_i + 1
                            errors.append('row {}: {} already exists - skip'.format(i, num))
                            continue
                        else:
                            number0.end_date = end_date = datetime.utcnow().replace(microsecond=0)
                            number0.on_end_date()
                            user.session().add(number0)
                            # number.delete()

                    number = DidBillingRel(did=num,
                                                 vendor_res_id=vendor_res_id,
                                                 client_res_id=client_res_id,
                                                 vendor_billing_rule_id=tsk.vendor_billing_rule_id,
                                                 client_billing_rule_id=tsk.client_billing_rule_id,
                                                 start_date=end_date
                                                 )
                    user.session().add(number)
                    if client_rule:
                        res = client.get_assigned_billing_plan_resource(client_rule, None)
                        res.update_by = assigned_by
                        ProductItems.assign_client_did(res, number.did, assigned_by)
                    if vendor_res_id:
                        if tsk.vendor_billing_rule_id:
                            prefix = vendor_res.assign_vendor_did_prefix(number.did, rate_table)
                            user.session().add(prefix)

                except IntegrityError as e:
                    errors.append('row {}:{}'.format(i - 1, str(e)))
                    log.warning('error on import {} {}'.format(num, str(e)))
            tsk.finished_on = datetime.now(UTC)
            tsk.status = 'success'
            if errors:
                tsk.num_imported = i - sk_i
                tsk.num_skiped = sk_i
                tsk.result = 'numbers imported {} of {}, numbers skiped {}\n' \
                             'IMPORT WARNINGS:\n{}'.format(i - sk_i, i, sk_i, '\n'.join(errors))
            else:
                tsk.num_imported = i - sk_i
                tsk.result = 'numbers imported {} of {}, numbers skiped {}'.format(i - sk_i, i, sk_i)
            tsk.save()
        except Exception as e:
            tsk.finished_on = datetime.now(UTC)
            tsk.status = 'fail'
            tsk.result = 'Import failure: {}\n{}'.format(str(e)[0:500],
                                                         'IMPORT WARNINGS:\n'.join(errors))
            tsk.save()
            import traceback
            log.error('Import failure: {}'.format(str(traceback.format_exc())))
    else:
        log.info('skip already running import_file {}'.format(id))
    logger.log.setLevel(mlevel(settings.LOG_LEVEL))
    log.setLevel(mlevel(settings.LOG_LEVEL))
    log.info('finish import_file {}'.format(id))


@app.task(base=Singleton, time_limit=288000, soft_time_limit=287400)
def did_import_file_delete(tsk_id):
    log.info('start import_file_delete {}'.format(tsk_id))
    tsk = DidNumberDeleteTask.get(tsk_id)
    # from falcon_rest import logger
    # logger.log.setLevel(mlevel('ERROR'))
    # log.setLevel(mlevel('ERROR'))
    if tsk and tsk.status == 'Initial':
        tsk.status = 'In Process'
        tsk.start_time = datetime.now(UTC)
        tsk.progress = 'Started at {}'.format(tsk.start_time)
        tsk.save()
        errors = []
        try:
            file = open(tsk.file_name)
            data = file.readlines()
            assigned_by = tsk.operator_user
            user = None
            user_name = 'anonymous'
            vendor =None
            client =None
            if assigned_by:
                user = User.filter(User.name == assigned_by).first()
                if not user:
                    raise Exception('delete task from unknown user')
                user_name = assigned_by
            vendor_id = tsk.vendor_id
            if vendor_id:
                vendor = Client.get(vendor_id)
            client_id = tsk.client_id
            if client_id:
                client = Client.get(client_id)
            i = 0
            sk_i = 0
            for row in data:
                row = row.strip().lower()
                if ',' in row:
                    num = row.split(',')[0]
                else:
                    num = row
                row_errors = ''
                if 'num' in num.lower() or 'did' in num.lower():
                    continue
                i = i + 1
                if not re.match(PHONE_REGEXP, num):
                    sk_i = sk_i + 1
                    errors.append('row {}: skip bad number {}'.format(i, num))
                    continue
                # if len(num) < 10:
                #     sk_i = sk_i + 1
                #     errors.append('row {}: skip bad number {}'.format(i, num))
                #     continue
                # if len(num)==10:
                #     num='1'+num
                if row_errors:
                    errors.append('row {}:{}'.format(i, row_errors))
                if i % 500 == 0:
                    print('numbers deleted {}'.format(i))
                    tsk.progress = 'numbers deleted {}'.format(i)
                    tsk.save()
                try:
                    cls = DidBillingRel
                    number = cls.filter(DidBillingRel.did == num, cls.end_date.is_(None)).first()

                    if number:
                        OP_METHOD = {1: 'Remove DIDs from a specific client', 2: 'Remove DIDs from any client',
                                     3: 'Remove DIDs from a specific vendor', 4: 'Remove DIDs from any vendor'}
                        log.debug('import_file_delete found old number {}'.format(number))
                        if tsk.op_method == 'Remove DIDs from a specific client' \
                                and number.client_res.client_id != tsk.client_id:
                            errors.append('row {}: not a client number {}'.format(i, num))
                            sk_i = sk_i + 1
                            continue
                        if tsk.op_method == 'Remove DIDs from any client' \
                                and number.client_res_id is None:
                            errors.append('row {}: not a client number {}'.format(i, num))
                            sk_i = sk_i + 1
                            continue
                        if tsk.op_method == 'Remove DIDs from a specific vendor' \
                                and number.vendor_res.client_id != tsk.vendor_id:
                            errors.append('row {}: not a client number {}'.format(i, num))
                            sk_i = sk_i + 1
                            continue
                        if tsk.op_method == 'Remove DIDs from any vendor' \
                                and number.vendor_res_id is None:
                            errors.append('row {}: not a client number {}'.format(i, num))
                            sk_i = sk_i + 1
                            continue
                        if tsk.repeated_action == 'Delete' and tsk.op_method not in ('Remove DIDs from a specific client', 'Remove DIDs from any client'):
                            number.on_end_date()
                            number.delete()
                        else:
                            log.debug('import_file_delete add old number {}'.format(number))
                            if tsk.op_method in ('Remove DIDs from a specific client', 'Remove DIDs from any client'):
                                model.DidBillingRel.did_billing_rel_disconnect(number.did, None, None, user_name=user_name)
                                log.debug('import_file_delete add new number {}'.format(number.did))
                            if tsk.op_method in ('Remove DIDs from a specific vendor', 'Remove DIDs from any vendor'):
                                number.on_end_date()
                                number.delete()
                    else:
                        sk_i = sk_i + 1
                        errors.append('row {}: skip non exists number {}'.format(i, num))
                        continue
                except IntegrityError as e:
                    errors.append('row {}:{}'.format(i - 1, str(e)))
                    log.warning('error on delete {} {}'.format(num, str(e)))
            tsk.end_time = datetime.now(UTC)
            tsk.status = 'Finished'

            if errors:

                tsk.progress = 'numbers deleted {} of {}, numbers skiped {}\n' \
                               'IMPORT WARNINGS:\n{}'.format(i - sk_i, i, sk_i, '\n'.join(errors))
            else:
                tsk.num_imported = i - sk_i
                tsk.progress = 'numbers deleted {} of {}, numbers skipped {}, elapsed time {}'\
                    .format(i - sk_i, i, sk_i, tsk.end_time - tsk.start_time)
            tsk.save()
        except Exception as e:
            tsk.end_time = datetime.now(UTC)
            tsk.status = 'Error'
            tsk.progress = 'Delete failure: {}\n{}'.format(str(e)[0:500],
                                                           'WARNING:'+';'.join(errors))
            tsk.save()
            import traceback
            log.error('Delete failure: {}'.format(str(traceback.format_exc())))
    else:
        log.info('skip already running import_file_delete {}'.format(tsk_id))
    # logger.log.setLevel(mlevel(settings.LOG_LEVEL))
    # log.setLevel(mlevel(settings.LOG_LEVEL))
    log.info('finish import_file_delete {}'.format(tsk_id))


@app.task(base=SqlAlchemyTask, time_limit=288000, soft_time_limit=287400)
def did_import_file_assign(tsk_id):
    log.info('start import_file_assign {}'.format(tsk_id))
    tsk = DidNumberAssignTask.get(tsk_id)
    # from falcon_rest import logger
    # logger.log.setLevel(mlevel('ERROR'))
    # log.setLevel(mlevel('ERROR'))
    if tsk:# and tsk.status == 'Initial':
        tsk.status = 'In Process'
        tsk.start_time = datetime.now(UTC)
        tsk.progress = 'Started at {}'.format(tsk.start_time)
        tsk.save()
        errors = []
        i = 0
        try:
            file = open(tsk.file_name)
            data = file.readlines()
            assigned_by = tsk.operator_user
            user = None
            user_name = 'anonymous'
            if assigned_by:
                user = User.filter(User.name == assigned_by).first()
                if not user:
                    raise Exception('assign task from unknown user')
                assigned_by_id = user.user_id
                user_name = assigned_by
            client_billing_rule_id = tsk.client_billing_rule_id
            if client_billing_rule_id:
                rule = DidBillingPlan.get(client_billing_rule_id)
            else:
                raise Exception('did_import_file_assign client_billing_rule not found')
            client_id = tsk.client_id
            if client_id:
                client = Client.get(client_id)
            else:
                raise Exception('did_import_file_assign client not found')
            res = client.get_assigned_billing_plan_resource(rule, None)
            res.update_by = user_name
            sk_i = 0
            for row in data:
                row = row.strip().lower()
                if ',' in row:
                    num = row.split(',')[0]
                else:
                    num = row
                row_errors = ''
                if 'num' in num.lower() or 'did' in num.lower():
                    continue
                i = i + 1
                if not re.match(PHONE_REGEXP, num):
                    sk_i = sk_i + 1
                    errors.append('row {}: skip bad number {}'.format(i, num))
                    continue
                if row_errors:
                    errors.append('row {}:{}'.format(i, row_errors))
                if i % 500 == 0:
                    print('numbers assigned {}'.format(i))
                    tsk.progress = 'numbers assigned {}'.format(i)
                    tsk.save()
                try:
                    cls = DidBillingRel
                    number = cls.filter(cls.did == num, cls.end_date.is_(None)).first()
                    if number:
                        if number.ingress_res_id is None or number.buy_billing_plan_id is None:
                            sk_i = sk_i + 1
                            errors.append('row {}: skip number with no vendor {}'.format(i, num))
                            continue
                        if tsk.repeated_action == 'Replace':
                            number.on_end_date()
                            new_number = number
                        else:
                            number.on_end_date()
                            number.end_date = datetime.utcnow().replace(microsecond=0)
                            user.session().add(number)
                            new_number = cls(did=number.did, start_date=number.end_date, ip=number.ip,
                                             is_sms=number.is_sms,
                                             vendor_res_id=number.vendor_res_id,
                                             buy_billing_plan_id=number.buy_billing_plan_id,
                                             egress_res_id=res.resource_id,
                                             sell_billing_plan_id=client_billing_rule_id
                                             )
                            number.delete()
                        ProductItems.assign_client_did(res, new_number.did, assigned_by)
                        if new_number.vendor_res_id:
                            if new_number.vendor_billing_rule_id:
                                vendor_billing_rule = DidBillingPlan.get(new_number.vendor_billing_rule_id)
                                if vendor_billing_rule:
                                    rate_table = vendor_billing_rule.rate_table
                                    vendor_res = Resource.get(new_number.vendor_res_id)
                                    prefix = vendor_res.assign_vendor_did_prefix(new_number.did, rate_table)
                                    user.session().add(prefix)
                        new_number.save()
                        user.session().add(new_number)
                        if client_id:
                            model.DidClientLog.on_assign_did(new_number.did, client_id, assigned_by_id, 'Import')
                    else:
                        sk_i = sk_i + 1
                        errors.append('row {}: skip non exists number {}'.format(i, num))
                        continue
                except IntegrityError as e:
                    errors.append('row {}:{}'.format(i - 1, str(e)))
                    log.warning('error on import_file_assign number: {} {}'.format(num, str(e)))
            tsk.end_time = datetime.now(UTC)
            tsk.status = 'Finished'
            if errors:
                tsk.progress = 'numbers assigned {} of {}, numbers skipped {}\nIMPORT WARNINGS:\n{}' \
                    .format(i - sk_i, i, sk_i, '\n'.join(errors))
            else:
                tsk.num_imported = i - sk_i
                tsk.progress = 'numbers assigned {} of {}, numbers skipped {}, elapsed time {}' \
                    .format(i - sk_i, i, sk_i, tsk.end_time - tsk.start_time)
            tsk.save()
        except Exception as e:
            tsk.end_time = datetime.now(UTC)
            tsk.status = 'Error'
            tsk.progress = 'import_file_assign failure: {}\n{}' \
                .format(str(e)[0:500], 'IMPORT WARNINGS:\n'.join(errors))
            tsk.save()
            import traceback
            log.error('import_file_assign failure: {}'.format(str(traceback.format_exc())))
    else:
        log.info('skip already running import_file_assign {}'.format(tsk_id))
    # logger.log.setLevel(mlevel(settings.LOG_LEVEL))
    # log.setLevel(mlevel(settings.LOG_LEVEL))
    log.info('finish import_file_assign {}'.format(tsk_id))


@app.task(base=SqlAlchemyTask, time_limit=288000, soft_time_limit=287400)
def did_param_update(action='all'):
    log.info('start did_param_update {}'.format(action))
    i=0
    up=[]
    try:
        for d in DidBillingRel.session().query(DidBillingRel.did).filter(DidBillingRel.end_date.is_(None)):
            i += 1
            dp = DidParam.get(d.did)
            if action in ('all', 'missing'):
                if not dp:
                    dp = DidParam(did=d.did)
                    dp.update()
                    up.append(str(d.did))
                    #dp.save()
                    DidParam.session().add(dp)
                else:
                    if action == 'all':
                        dp.update()
                        up.append(str(d.did))
                        #dp.save()
                        DidParam.session().add(dp)
            if i % 32 == 0:
                DidParam.session().commit()
                log.debug('updated {} numbers {}'.format(i,','.join(up)))
                up = []
        DidParam.session().commit()
    except Exception as e:
        log.info('did_param_update error'.format(str(e)))
    log.info('finish did_param_update {}'.format(action))


@app.task(base=SqlAlchemyTask, time_limit=288000, soft_time_limit=287400)
def shaken_ani_group_rel_import(tsk_id):
    log.info('start shaken_ani_group_rel_import_task {}'.format(tsk_id))
    tsk = ShakenAniGroupRelImportTask.get(tsk_id)
    # from falcon_rest import logger
    # logger.log.setLevel(mlevel('ERROR'))
    # log.setLevel(mlevel('ERROR'))
    if tsk:# and tsk.status == 'Initial':
        tsk.status = 'In Process'
        tsk.start_time = datetime.now(UTC)
        tsk.progress = 'Started at {}'.format(tsk.start_time)
        tsk.save()
        errors = []
        i = 0
        try:
            file = open(tsk.file_name)
            data = file.readlines()
            assigned_by = tsk.operator_user
            user = None
            user_name = 'anonymous'
            if assigned_by:
                user = User.filter(User.name == assigned_by).first()
                if not user:
                    raise Exception('shaken_ani_group_rel_import task from unknown user')
                user_name = assigned_by
            group_id = tsk.group_id
            if group_id:
                group = ShakenAniGroup.get(group_id)
            else:
                raise Exception('shaken_ani_group_rel_import ShakenAniGroup not found')

            sk_i = 0
            for row in data:
                row = row.strip().lower()
                if ',' in row:
                    num = row.split(',')[0]
                else:
                    num = row
                row_errors = ''
                if not re.match(PHONE_REGEXP, num) and i == 0:
                    continue
                i = i + 1
                if not re.match(PHONE_REGEXP, num):
                    sk_i = sk_i + 1
                    errors.append('row {}: bad number {}'.format(i, num))
                    continue
                if row_errors:
                    errors.append('row {}:{}'.format(i, row_errors))
                if i % 500 == 0:
                    print('numbers imported {}'.format(i))
                    tsk.progress = 'numbers imported {}'.format(i)
                    tsk.save()
                try:
                    cls = ShakenAniGroupRel
                    number = cls.filter(cls.did == num, cls.group_id ==group_id).first()
                    if number:
                        if tsk.repeated_action == 'Add':
                            sk_i = sk_i + 1
                            errors.append('row {}: exists {}'.format(i, num))
                            continue
                        else:
                            cls.filter(cls.did == num, cls.group_id == group_id).delete(synchronize_session='fetch')
                            continue
                    else:
                        if tsk.repeated_action == 'Delete':
                            sk_i = sk_i + 1
                            errors.append('row {}: nonexists {}'.format(i, num))
                            continue
                        else:
                            new_number = cls(did=num,
                                             group_id=group_id,
                                             created_by=user_name,
                                             )
                            tsk.session().add(new_number)

                except IntegrityError as e:
                    errors.append('row {}:{}'.format(i - 1, str(e)))
                    log.warning('error on shaken_ani_group_rel_import_task number: {} {}'.format(num, str(e)))
            tsk.end_time = datetime.now(UTC)
            tsk.status = 'Finished'
            if errors:
                tsk.progress = 'numbers imported {} of {}, numbers skipped {}\nIMPORT WARNINGS:\n{}' \
                    .format(i - sk_i, i, sk_i, '\n'.join(errors))
            else:
                tsk.num_imported = i - sk_i
                tsk.progress = 'numbers imported {} of {}, numbers skipped {}, elapsed time {}' \
                    .format(i - sk_i, i, sk_i, tsk.end_time - tsk.start_time)
            tsk.save()
        except Exception as e:
            tsk.end_time = datetime.now(UTC)
            tsk.status = 'Error'
            tsk.progress = 'shaken_ani_group_rel_import failure: {}\n{}' \
                .format(str(e)[0:500], 'IMPORT WARNINGS:\n'.join(errors))
            tsk.save()
            import traceback
            log.error('shaken_ani_group_rel_import failure: {}'.format(str(traceback.format_exc())))
    else:
        log.info('skip already running import_file_assign {}'.format(tsk_id))
    # logger.log.setLevel(mlevel(settings.LOG_LEVEL))
    # log.setLevel(mlevel(settings.LOG_LEVEL))
    log.info('finish shaken_ani_group_rel_import {}'.format(tsk_id))
