# coding: utf-8

"""
    DNL API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

    OpenAPI spec version: 1.4.4
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import os
import sys
import unittest

import cli_dnl
from cli_dnl.rest import ApiException
from cli_dnl.apis.carrier_api import CarrierApi
from . settings import *


def data_full():
    name_full = 'TEST_'+bla(8)
    data= {
        'account_detail': bla_bla(5),
        'address': bla_bla(3),
        'attach_cdrs_list': get_rand('bool'),
        'auto_send_invoice': get_rand('bool'),
        'auto_summary_group_by': random.choice(['By Country', 'By Code Name', 'By Code']),
        'auto_summary_hour': random.randint(0, 24),
        'auto_summary_not_zero': get_rand('bool'),
        'auto_summary_period': random.choice([1, 2, 4, 6, 8, 12, 24, -15, -30]),
        'billing_email': bla_mail(),
        'carrier_name': name_full,
        'cdr_format': random.choice(['Excel', 'CSV', 'zip', 'tar.gz']),
        'company_name': 'Denovolab ' + bla(6),
        'credit_limit':get_rand('float'),
        'currency': rand_currency()[0],
        'daily_cdr_generation': get_rand('bool'),
        'daily_cdr_generation_zone': '%+03d00' % random.randint(-12, 12),
        'decimal': random.randint(0, 5),
        'email': bla_mail(),
        'format': random.choice(['PDF', 'Excel', 'HTML']),
        'include_short_call_charge': get_rand('bool'),
        'include_tax': get_rand('bool'),
        'inlcude_cdr_in_email': get_rand('bool'),
        'is_auto_summary': get_rand('bool'),
        'is_breakdown_by_rate_table': get_rand('bool'),
        'is_daily_balance_notification': get_rand('bool'),
        'is_panel_accountsummary': get_rand('bool'),
        'is_panel_balance': get_rand('bool'),
        'is_panel_cdrslist': get_rand('bool'),
        'is_panel_invoices': get_rand('bool'),
        'is_panel_onlinepayment': get_rand('bool'),
        'is_panel_paymenthistory': get_rand('bool'),
        'is_panel_products': get_rand('bool'),
        'is_panel_ratetable': get_rand('bool'),
        'is_panel_sippacket': get_rand('bool'),
        'is_panel_summaryreport': get_rand('bool'),
        'is_panel_trunks': get_rand('bool'),
        'is_panelaccess': get_rand('bool'),
        'is_prepay': get_rand('bool'),
        'is_send_trunk_update': get_rand('bool'),
        'is_show_daily_usage': get_rand('bool'),
        'unlimited_credit': get_rand('bool'),
        'login': 'login_' + name_full,
        'low_balance_notice': get_rand('bool'),
        'low_balance_notification_time_type': 0,
        'noc_email': bla_mail(),
        'non_zero_invoice_only': get_rand('bool'),
        'notify_client_balance_type': 0,
        'password': 'string',
        'payment_received_notice': get_rand('bool'),
        'payment_term': rand_payment_term()[1].name,
        'phone': dig(13),
        'profit_margin': random.random() * 10,
        'profit_type': random.choice(['percentage', 'value']),
        'rate_delivery_email': bla_mail(),
        'rate_email': bla_mail(),
        'rate_value': random.choice(['Actual Value', 'Average Value']),
        'scc_below': get_rand('int'),
        'scc_charge': get_rand('int'),
        'scc_percent': random.random() * 100.0,
        'scc_type': random.choice([0, 1]),
        'send_invoice_as_link': get_rand('bool'),
        'show_account_summary': get_rand('bool'),
        'show_code_name_summary': get_rand('bool'),
        'show_code_summary': get_rand('bool'),
        'show_country_summary': get_rand('bool'),
        'show_daily_usage': get_rand('bool'),
        'show_detail_by_trunk': get_rand('bool'),
        'show_jurisdiction_detail': get_rand('bool'),
        'show_payment_summary': get_rand('bool'),
        'show_trunk_summary': get_rand('bool'),
        'status': get_rand('bool'),
        'tax': random.random() * 100.0,
        'test_credit': get_rand('float'),
        'time_zone': 'string',
        'zero_balance_notice': get_rand('bool'),
        'low_balance_config': {
            'is_notify': get_rand('bool'),
            'send_time_type': random.choice(['daily', 'hourly']),
            'value_type': random.choice(['Actual Balance', 'Percentage']),
            'percentage_notify_balance': get_rand('int'),
            'duplicate_send_days': get_rand('int'),
            'send_to': get_rand('int'),
            'disable_trunks_days': get_rand('int'),
            'actual_notify_balance': get_rand('int'),
            'daily_send_time': get_rand('int'),
            'duplicate_days': get_rand('int')},
        'company_type': random.choice(['client','vendor']),
    }
    if data['is_prepay'] and 'test_credit' in data:
        del data['test_credit']

    return data


def egress_trunk():
    data = {
        'ani_cap_limit': get_rand('int'),
        'ani_cps_limit': get_rand('int'),
        'auth_type': random.choice(['Authorized by Host Only', 'Authorized by SIP Registration', 'Register to gateway']),
        'bypass_media': random.choice(['Bypass Media', 'Proxy Media + Transcoding', 'Proxy Media']),
        'call_limit': get_rand('int'),
        #'codecs': ['CS1', 'CS2', 'H232'],
        #'codes': [dig(10), dig(10)],
        'cps_limit': get_rand('int'),
        'dnis_cap_limit': get_rand('int'),
        'dnis_cps_limit': get_rand('int'),
        'enfource_cid': get_rand('bool'),
        'host_routing_strategy': random.choice(['top-down', 'round-robin']),
        'ip': [{'ip': ip(), 'port': random.randint(1000, 65535)}],
        'is_active': get_rand('bool'),
        'max_duration': get_rand('int'),
        'media_timeout': get_rand('int'),
        'media_type': random.choice(['Bypass Media', 'Proxy Media + Transcoding', 'Proxy Media']),
        'min_duration': get_rand('int'),
        'min_profit_type': random.choice(['percentage', 'value']),
        'min_profit_value': get_rand('float'),
        'name': 'egress_trunk_' + bla(7),
        'pass_lrn': get_rand('int'),
        'pdd': random.randint(6000, 60000),
        'prefix': dig(6),
        'rate_table_id': rand_rate_table(per_page=100)[0],
        'reg_user': [{'username': bla(8), 'password':bla(8)}],
        'reg_gateway': [{'username': bla(8), 'password': bla(8), 'reg_srv_ip':ip(check_dublicates=False),'reg_srv_port':random.randint(1000, 65535)}],
        'ring_timeout': random.randint(0, 60),
        'route_plan_id': rand_route_plan(per_page=100)[0],
        'rpid_id_type': random.choice(['None', 'Subscriber', 'User', 'Term', 'Proxy']),
        't38': get_rand('bool'),
        'rate_decimal':random.randint(1,6),
        'rate_rounding':random.choice(['Up','Down']),
        'us_other': random.choice(['other','intra','inter','highest'])
    }
    return data


def ingress_trunk():

    data = {
        'auth_type': random.choice(['Authorized by Host Only', 'Authorized by SIP Registration', 'Register to gateway']),
        'bypass_media': random.choice(['Bypass Media', 'Proxy Media + Transcoding', 'Proxy Media']),
        'call_limit': get_rand('int'),
        'cps_limit': get_rand('int'),
        'host_routing_strategy': random.choice(['top-down', 'round-robin']),
        'ignore_early_media': get_rand('bool'),
        'ignore_early_no_sdp': get_rand('bool'),
        'ip': [{'ip': ip(), 'port': random.randint(1000, 65535)}],
        'is_active': get_rand('bool'),
        'max_duration': get_rand('int'),
        'media_timeout': get_rand('int'),
        'min_duration': get_rand('int'),
        'min_profit_type': random.choice(['percentage', 'value']),
        'min_profit_value': get_rand('float'),
        'name': 'ingress_trunk_' + bla(7),
        'rate_table_id': rand_rate_table(per_page=100)[0],
        'ring_timeout': random.randint(0, 60),
        'route_plan_id': rand_route_plan(per_page=100)[0],
        't38': get_rand('bool'),
        'rate_decimal': random.randint(1, 6),
        'rate_rounding': random.choice(['Up','Down']),
        'rate_use_rpid':get_rand('bool'),
        'reg_user': [{'username': bla(8), 'password': bla(8)}],
        'reg_gateway': [{'username': bla(8), 'password': bla(8), 'reg_srv_ip': ip(check_dublicates=False), 'reg_srv_port': random.randint(1000, 65535)}],
        'us_other': random.choice(['other', 'intra', 'inter', 'highest'])
    }

    if random.randint(0, 3):
        data['prefixes'] = [{'code': dig(3), 'code_cps': get_rand('int'),
        'rate_table_id': rand_rate_table()[0], 'tech_prefix': dig(6), 'code_cap': get_rand('int'),
        'product_id': rand_product()[0] ,#if random.randint(0, 1) else None,
        'routing_plan_id': rand_route_plan()[0]}]
    else:
        data['prefix']=dig(6)
    return data




class TestCarrierApi(unittest.TestCase):
    """ CarrierApi unit test stubs """

    def setUp(self):
        random.seed=713714715
        self.api = cli_dnl.apis.carrier_api.CarrierApi()
        auth()

        self.client_id = None
        ret = self.api.carrier_simple_list_get(email='_novvv@mail.ru')
        assert (ret.success)

        if len(ret.payload.items):
            self.client_id = ret.payload.items[0].client_id
        else:
            data = {'name': bla(6), 'main_email': '_novvv@mail.ru',
                    'billing_email': '_novvv@mail.ru','rate_email': '_novvv@mail.ru',
                    'test_credit': random.random() * 1000}

            c = self.api.carrier_basic_create_post(body=data)
            assert (c.success)
            self.client_id = c.object_id

            ret = cli_dnl.ConfigApi().config_payment_term_list_get()
            pt = random.choice([p.name for p in ret.payload.items])
            self.api.carrier_client_id_invoices_patch(client_id=self.client_id,body={'payment_term':pt})
            assert (c.success)



    def tearDown(self):
        #ret = self.api.carrier_client_id_delete(self.client_id)
        #assert (ret.success)
        pass

    def test_carrier_all_delete(self):
        """
        Test case for carrier_all_delete


        """
        pass

    def test_carrier_all_patch(self):
        """
        Test case for carrier_all_patch


        """
        pass

    def test_carrier_basic_create_post_without_login(self):
        curr = cli_dnl.SwitchApi().switch_currency_list_get()
        assert (curr.success)
        currency = random.choice(curr.payload.items)
        comp = bla_comp()
        name = bla(6)
        data = {'name': name, 'email': bla_mail(), 'test_credit': random.random() * 1000,
                'account_detail': comp + ' ' + name + ' ' + lorem_ipsum() + ' \n ' + name,
                'short_call_charge_exceed_only': random.choice([0, 1]),
                'address': comp + ' ' + bla_bla(3),
                'profit_type': random.choice(['percentage', 'value']), 'is_active': get_rand('bool'),
                'auto_invoice_type': random.choice(['buy', 'sell', 'both']),
                'currency_name': currency.code, 'noc_email': bla_mail(), 'rate_email': bla_mail(),
                'trunk_update_alert': get_rand('bool'), 'billing_email': bla_mail(),
                'chort_call_percent': get_rand('int'), 'is_prepay': get_rand('bool'),
                'chort_call_duration': get_rand('int'), 'call_limit': get_rand('int'),
                'daily_usage_on_non_zero': get_rand('bool'),
                'phone': dig(7), 'low_balance_alert': get_rand('bool'),
                'daily_cdr_delivery': get_rand('bool'), 'one_time_report_time': random.randint(0, 24),
                'daily_usage_group_by': random.choice(['By Country', 'By Code Name', 'By Code']),
                'daily_balance_summary': get_rand('bool'),
                'unlimited_credit': get_rand('bool'),
                # 'credit_limit': random.random() * 1000,
                'company': comp, 'report_frequency': get_rand('int'), 'daily_usage_on_zero': get_rand('bool'),
                'time_profile_id': rand_time_profile()[0],
                'profit_margin': random.random() * 100,
                'is_prepay': False
                }
        c = self.api.carrier_basic_create_post(body=data)
        assert (c.success)
        print(c)
        c1=self.api.carrier_client_id_get(client_id=c.object_id)
        assert(c1.success)
        u = cli_dnl.AuthApi().user_list_get(name=data['name'])
        assert (u.success and len(u.payload.items) == 0)


    def test_carrier_basic_create_post(self):
        """
        Test case for carrier_basic_create_post

        
        """

        curr = cli_dnl.SwitchApi().switch_currency_list_get()
        assert (curr.success)
        currency = random.choice(curr.payload.items)
        comp = bla_comp()
        name =  bla(6)
        data = {'name': name, 'email': bla_mail(),'test_credit':random.random()*1000,
                'account_detail':comp+' '+name+' '+lorem_ipsum()+ ' \n '+name,'short_call_charge_exceed_only':random.choice([0, 1]),
                'address':comp+' '+bla_bla(3),
                'profit_type':random.choice(['percentage','value']),'is_active':get_rand('bool'),
                'auto_invoice_type':random.choice([ 'buy','sell','both']),
                'currency_name':currency.code,'noc_email': bla_mail(),'rate_email': bla_mail(),
                'trunk_update_alert':get_rand('bool'),'billing_email': bla_mail(),
                'chort_call_percent':get_rand('int'),'is_prepay':get_rand('bool'),
                'chort_call_duration': get_rand('int'),'call_limit':get_rand('int'),
                'daily_usage_on_non_zero': get_rand('bool'),
                'phone':dig(7),'low_balance_alert':get_rand('bool'),
                'daily_cdr_delivery':get_rand('bool'),'one_time_report_time':random.randint(0,24),
                'daily_usage_group_by':random.choice(['By Country','By Code Name','By Code']),
                'daily_balance_summary': get_rand('bool'),
                'unlimited_credit':get_rand('bool'),
                #'credit_limit': random.random() * 1000,
                'company': comp,'report_frequency':get_rand('int'),'daily_usage_on_zero':get_rand('bool'),
                'time_profile_id':rand_time_profile()[0],
                'profit_margin':random.random()*100,
                'login':bla(8),
                'password':bla(8),
                'is_prepay':False,
                'company_type': random.choice(['client', 'vendor']),

                }
        c=self.api.carrier_basic_create_post(body=data)
        assert(c.success)
        u=cli_dnl.AuthApi().user_list_get(name=data['login'])
        assert(u.success and len(u.payload.items)==1)

        cli=self.api.carrier_client_id_get(client_id=c.object_id).payload
        if cli.actual_balance:
            assert(abs(cli.actual_balance-data['test_credit']) < 0.0001)
        print(cli)
        return cli
        pass

    def test_carrier_client_id_alerts_get(self):
        """
        Test case for carrier_client_id_alerts_get

        
        """
        ret=self.api.carrier_client_id_alerts_get(client_id=self.client_id)
        assert(ret.success)
        pass

    def test_carrier_client_id_alerts_patch(self):
        """
        Test case for carrier_client_id_alerts_patch

        
        """
        data = {
  'enable_low_balance_alert': get_rand('bool'),
  'enable_zero_balance_alert': get_rand('bool'),
  'enable_daily_usage_alert': get_rand('bool'),
  'enable_trunk_update_alert': get_rand('bool'),
  'enable_payment_received_alert': get_rand('bool'),
  'enable_daily_balance_alert': get_rand('bool'),
  'enable_daily_cdr_alert': get_rand('bool')
}
        ret = self.api.carrier_client_id_alerts_patch(client_id=self.client_id,body=data)
        assert (ret.success)
        cli=ret.payload
        assert(cli.enable_low_balance_alert==data['enable_low_balance_alert'])
        assert (cli.enable_zero_balance_alert == data['enable_zero_balance_alert'])
        assert (cli.enable_daily_usage_alert == data['enable_daily_usage_alert'])
        assert (cli.enable_trunk_update_alert == data['enable_trunk_update_alert'])
        assert (cli.enable_payment_received_alert == data['enable_payment_received_alert'])
        assert (cli.enable_daily_balance_alert == data['enable_daily_balance_alert'])
        assert (cli.enable_daily_cdr_alert == data['enable_daily_cdr_alert'])
        pass

    def test_carrier_client_id_contacts_get(self):
        """
        Test case for carrier_client_id_contacts_get

        
        """
        id, cl, ls = rand_client()
        ret = self.api.carrier_client_id_get(client_id=id)
        assert (ret.success and ret.payload.name == cl.name)
        ret1 = self.api.carrier_client_id_contacts_get(client_id=id)
        assert (ret1.success)
        #assert(ret1.payload.email == ret.payload.main_email)
        assert (ret1.payload.company_name == ret.payload.company)
        assert (ret1.payload.address == ret.payload.address)
        pass

    def test_carrier_client_id_contacts_patch(self):
        """
        Test case for carrier_client_id_contacts_patch

        
        """
        data={
    "billing_email": bla_mail(),
    "company_name": bla_comp(),
    "email": bla_mail(),
    "noc_email": bla_mail(),
    "account_detail": lorem_ipsum(),
    "address": bla_bla(4),
    "rate_email": bla_mail(),
    "phone": dig(10),
    "rate_delivery_email": bla_mail(),
    "tax": random.random()*100
  }
        ret = self.api.carrier_client_id_contacts_patch(client_id=self.client_id, body=data)
        assert (ret.success)

        try:
            ret=self.api.carrier_client_id_contacts_patch(client_id=self.client_id,body={'tax':9996666666})
            assert (not ret.success)
        except Exception as e:
            assert ('Must be between' in str(e))

        pass

    def test_carrier_client_id_delete(self):
        """
        Test case for carrier_client_id_delete

        
        """
        auth()
        data = {'name': bla(6), 'email': bla_mail(), 'test_credit': random.random() * 1000}
        ret = self.api.carrier_basic_create_post(body=data)
        assert(ret.success)
        ret = self.api.carrier_client_id_get(client_id=ret.object_id)
        c=ret.payload
        tret = self.api.carrier_client_id_egress_trunk_post(client_id=c.client_id,body={'name':bla(7)})
        assert(tret.success)
        adata = {'carriers': [{
                "method_type": random.choice(["By Profit","By Revenue"]),
                "commission": random.random()*50,
                "client_id": c.client_id
             }]}
        agret = cli_dnl.AgentApi().agent_list_get(usage_count=0)
        assert (agret.success)
        tr = random.choice(agret.payload.items)
        ag_cre = cli_dnl.AgentApi().agent_agent_id_patch(agent_id=tr.agent_id, body=adata)
        assert (ag_cre.success)

        uret = cli_dnl.AuthApi().user_list_get()
        assert (uret.success)
        u = random.choice(uret.payload.items)
        uret1=cli_dnl.AuthApi().user_user_id_patch(user_id=u.user_id,body={'client_limits':[{'client_id':c.client_id}]})
        assert (uret1.success)

        d = self.api.carrier_client_id_delete(c.client_id)
        assert(d.success)

        pass

    def test_carrier_client_id_egress_trunk_list_get(self):
        """
        Test case for carrier_client_id_egress_trunk_list_get

        
        """
        ret = self.api.carrier_client_id_ingress_trunk_list_get(client_id=rand_client(egress_count_gt=0)[0])
        assert (ret.success and len(ret.payload.items))
        pass
        pass

    def test_carrier_client_id_egress_trunk_post(self):
        """
        Test case for carrier_client_id_egress_trunk_post

        
        """

        data = egress_trunk()

        # ips=cli_dnl.TrunkApi().trunk_ip_list_get(per_page=100)
        # if ips.success:
        #     random.shuffle(ips.payload.items)
        #     ls=ips.payload.items
        #     data['ip'].append({'ip':ls[0].ip})
        
        print(json.dumps(data))
        ret=self.api.carrier_client_id_egress_trunk_post(client_id=self.client_id,body=data)
        assert(ret.success)
        print(ret)

        obj=self.api.egress_trunk_resource_id_get(resource_id=ret.object_id)
        assert (obj.success)
        assert (obj.payload.pdd==data['pdd'])
        assert (obj.payload.min_profit_value == data['min_profit_value'])
        lst = self.api.carrier_client_id_egress_trunk_list_get(client_id=obj.payload.carrier_id,resource_id=ret.object_id)
        assert (lst.success)
        assert (lst.payload.items[0].pdd == data['pdd'])
        assert (lst.payload.items[0].min_profit_value == data['min_profit_value'])
        return obj.payload

        pass

    def test_carrier_client_id_get(self):
        """
        Test case for carrier_client_id_get

        
        """
        id,cl,ls=rand_client()
        ret = self.api.carrier_client_id_get(client_id=id)
        assert (ret.success and ret.payload.name == cl.name)
        pass

    def test_carrier_client_id_ingress_trunk_list_get(self):
        """
        Test case for carrier_client_id_ingress_trunk_list_get


        """
        ret=self.api.carrier_client_id_ingress_trunk_list_get(client_id=rand_client(ingress_count_gt=0)[0])
        assert(ret.success and len(ret.payload.items))
        pass

    def test_carrier_client_id_ingress_trunk_post(self):
        """
        Test case for carrier_client_id_ingress_trunk_post

        
        """
        data0 = ingress_trunk()
        client_id=rand_client()[0]
        print('POST/carrier/{}/ingress_trunk '.format(client_id),json.dumps(data0))
        ret=self.api.carrier_client_id_ingress_trunk_post(client_id=client_id,body=data0)
        assert(ret.success)
        print(ret)
        return
        data = ingress_trunk()
        #data['ip'].append({'ip':ip()})
        #data['ip'].append(data0['ip'][0])
        data['ip']=data0['ip']
        if 'prefix' in data:
            del data['prefix']
        if 'prefixes' in data:
            del data['prefixes']
        if 'prefix' in data0:
            data['prefix']=data0['prefix']
        if 'prefixes' in data0:
            data['prefixes']=data0['prefixes']

        try:
            ret = self.api.carrier_client_id_ingress_trunk_post(client_id=rand_client()[0], body=data)
            assert (not ret.success)
        except Exception as e:
            assert('already exist' in str(e))
        if 'prefix' in data:
            del data['prefix']
        if 'prefixes' in data:
            del data['prefixes']
        ret = self.api.carrier_client_id_ingress_trunk_post(client_id=rand_client()[0], body=data)
        assert (ret.success)


        data = ingress_trunk()
        if 'prefix' in data:
            del data['prefix']
        if 'prefixes' in data:
            del data['prefixes']
        data['ip'].append({'ip': ip()})
        try:
            ret = self.api.carrier_client_id_ingress_trunk_post(client_id=rand_client()[0], body=data)
            assert (not ret.success)
        except Exception as e:
            assert('more than one IP' in str(e))

        pass

    def test_carrier_client_id_invoices_get(self):
        """
        Test case for carrier_client_id_invoices_get

        
        """
        lst=rand_client()[2]
        random.shuffle(lst)
        for item in lst[0:10]:
            ret=self.api.carrier_client_id_invoices_get(client_id=item.client_id)
            assert(ret.success)
        pass

    def test_carrier_client_id_invoices_patch(self):
        """
        Test case for carrier_client_id_invoices_patch

        
        """
        data={
    'is_breakdown_by_rate_table': get_rand('bool'),
    'show_payment_summary': get_rand('bool'),
    'show_trunk_summary': get_rand('bool'),
    'include_tax': get_rand('bool'),
    'payment_term': rand_payment_term()[1].name,
    'decimal': random.randint(0,5),
    'show_code_name_summary': get_rand('bool'),
    'show_code_summary': get_rand('bool'),
    'non_zero_invoice_only': get_rand('bool'),
    'show_detail_by_trunk': get_rand('bool'),
    'time_zone': '%+3d00'%random.randint(-12,12),
    'inlcude_cdr_in_email': get_rand('bool'),
    'send_invoice_as_link': get_rand('bool'),
    'auto_send_invoice': get_rand('bool'),
    'cdr_format': random.choice(['Excel', 'CSV', 'zip', 'tar.gz']),
    'show_daily_usage': get_rand('bool'),
    'format': random.choice(['PDF', 'Excel', 'HTML']),
    'show_country_summary': get_rand('bool'),
    'show_account_summary': get_rand('bool'),
    'rate_value': random.choice(['Actual Value', 'Average Value']),
    'show_jurisdiction_detail': get_rand('bool'),
    'include_short_call_charge': get_rand('bool'),
    'usage_fields':['ingress_call_cost','egress_id']
  }
        tzl = ['+00:00','+12:00','-12:00','+06:30','-03:20']
        id=rand_client()[0]
        for tz in tzl:
            data = dict(time_zone=tz)
            ret = self.api.carrier_client_id_invoices_patch(client_id=id,body=data)
            assert (ret.success)
            print(data,'success')
            print(id)
        pass

    def test_carrier_client_id_low_balance_config_get(self):
        """
        Test case for carrier_client_id_low_balance_config_get

        
        """
        ret = self.api.carrier_client_id_low_balance_config_get(client_id=rand_client()[0])
        assert (ret.success)
        pass

    def test_carrier_client_id_low_balance_config_patch(self):
        """
        Test case for carrier_client_id_low_balance_config_patch

        
        """
        data={
  'disable_trunks_days': get_rand('int'),
  'value_type': 'Actual Balance',
  'percentage_notify_balance': random.random()*1000,
  'send_to': rand_mail_sender()[0],
  'duplicate_send_days': get_rand('int'),
  'duplicate_days': get_rand('int'),
  'actual_notify_balance': random.random()*1000,
  'daily_send_time': random.randint(0,24),
  'send_time_type': 'daily',
  'is_notify': get_rand('bool')
}
        ret = self.api.carrier_client_id_low_balance_config_get(client_id=rand_client()[0])
        assert (ret.success)
        pass

    def test_carrier_client_id_password_patch(self):
        """
        Test case for carrier_client_id_password_patch

        
        """
        data={'password':bla(32)}
        ret = self.api.carrier_client_id_password_patch(client_id=rand_client()[0], body=data)
        assert (ret.success)
        pass

    def test_carrier_client_id_patch_payment_term(self):
        """
        Test case for carrier_client_id_patch


        """
        for i in range(0,10):
            id = rand_client(client_type='client',ingress_count_gt=1)[0]
            ret = self.api.carrier_client_id_patch(client_id=id, body={'credit_limit':None,'unlimited_credit':False,'payment_term_id':rand_payment_term()[0]})
            print(ret)
            assert (ret.success)


    def test_carrier_client_id_patch(self):
        """
        Test case for carrier_client_id_patch

        
        """
        id = rand_client()[0]
        # id = 1871
        ret = self.api.carrier_client_id_patch(client_id=id, body={'name': 'CARRIER'+bla(10)})
        print(ret)
        assert (ret.success)


        id = rand_client(ingress_count_gt=0,mode='postpay')[0]
        #id = 1871
        ret = self.api.carrier_client_id_patch(client_id=id, body={'test_credit': round(random.random()*20000,2)})
        print(ret)
        assert (ret.success)

        #return
        id = rand_client(ingress_count_gt=0,mode='postpay')[0]
        ret=self.api.carrier_client_id_patch(client_id=id,body={'enough_balance':False})
        assert(ret.success)
        ret = self.api.carrier_client_id_ingress_trunk_list_get(client_id=id)
        assert (ret.success and len(ret.payload.items))
        for tr in ret.payload.items:
            assert(not tr.enough_balance)
            pass
        ret = self.api.carrier_client_id_patch(client_id=id,body={'enough_balance': True})
        assert (ret.success)
        ret = self.api.carrier_client_id_ingress_trunk_list_get(client_id=id)
        assert (ret.success and len(ret.payload.items))
        for tr in ret.payload.items:
            assert (tr.enough_balance)
            pass
        pass

    def test_carrier_client_id_portal_get(self):
        """
        Test case for carrier_client_id_portal_get

        
        """
        pass

    def test_carrier_client_id_portal_patch(self):
        """
        Test case for carrier_client_id_portal_patch

        
        """
        id = rand_client()[0]
        data = {'rate_email':bla_mail(),'is_panel_cid_blocking':get_rand('bool'),
                'profit_margin':round(random.random()*100,2),'login':bla(5),'password':bla(8)}
        ret=self.api.carrier_client_id_portal_patch(client_id=id,body=data)
        assert (ret.success)
        assert (ret.payload.profit_margin==data['profit_margin'])
        print(json.dumps(data),ret)
        pass

    def test_carrier_client_id_save_as_template_post(self):
        """
        Test case for carrier_client_id_save_as_template_post

        
        """
        ret=self.api.carrier_client_id_save_as_template_post(client_id=rand_client()[0])
        assert(ret.success)
        print(ret)
        pass

    def test_carrier_client_id_scc_get(self):
        """
        Test case for carrier_client_id_scc_get

        
        """
        pass

    def test_carrier_client_id_scc_patch(self):
        """
        Test case for carrier_client_id_scc_patch

        
        """
        pass

    def test_carrier_client_id_send_low_balance_alert_patch(self):
        """
        Test case for carrier_client_id_send_low_balance_alert_patch

        
        """
        ret = self.api.carrier_client_id_send_low_balance_alert_patch(client_id=self.client_id)
        assert (ret.success)
        pass

    def test_carrier_client_id_send_welcom_patch(self):
        """
        Test case for carrier_client_id_send_welcom_patch


        """

        ret=self.api.carrier_client_id_send_welcom_patch(client_id=self.client_id)
        assert(ret.success)



        pass

    def test_carrier_client_list_get(self):
        """
        Test case for carrier_client_list_get


        """
        pass

    def test_carrier_create_from_template_id_post(self):
        """
        Test case for carrier_create_from_template_id_post


        """
        id=rand_carrier_template()[0]
        ret=self.api.carrier_create_from_template_id_post(id=id,body={'name':'client from templ '+bla(6)})
        assert (ret.success)
        print(ret)
        pass

    def test_carrier_full_client_id_get(self):
        """
        Test case for carrier_full_client_id_get


        """
        pass

    def test_carrier_full_client_id_patch_zone(self):
        id = rand_client()[0]
        # id = 1871
        ret = self.api.carrier_full_client_id_patch(client_id=id, body={'invoice_zone': '+01:00','auto_send_zone': '+13:00'} )
        print(ret)
        assert (ret.success)

    def test_carrier_full_client_id_patch_email(self):
        #id = rand_client()[0]
        id = 3091
        ret = self.api.carrier_full_client_id_patch(client_id=id, body={'email': '_novvv@mail.ru'} )
        print(ret)
        assert (ret.success)

    def test_carrier_full_client_id_patch(self):
        """
        Test case for carrier_full_client_id_patch


        """
        cl=rand_client()[1]
        print(cl.client_id)
        login=cl.name.upper()
        ret=self.api.carrier_full_client_id_patch(client_id=cl.client_id,
                                body=dict(login=login))
        assert (ret.success)
        assert(ret.payload.login==login)
        print(ret)
        us=cli_dnl.AuthApi().user_list_get(name=login)
        assert(us.success and len(us.payload.items)==1)
        pass

    def test_carrier_full_create_post(self):
        """
                Test case for carrier_full_create_post


        """
        data = {'carrier_name': bla(8)}
        try:
            data['tax'] = 199.99
            ret = self.api.carrier_full_create_post(body=data)
            assert (not ret.success)
        except Exception as e:
            assert ('Must be between' in str(e))
        data['tax'] = 99.99
        try:
            data['email'] = bla(8)
            ret = self.api.carrier_full_create_post(body=data)
            assert (not ret.success)
        except Exception as e:
            assert ('invalid emails' in str(e))
        data['email'] = bla_mail()

        try:
            data['test_credit'] = 9996666666
            ret = self.api.carrier_full_create_post(body=data)
            assert (not ret.success)
        except Exception as e:
            assert ('Must be between' in str(e))
        data['test_credit'] = random.random() * 10000
        for field in ['carrier_name', 'address', 'account_detail', 'company_name']:
            try:
                data[field] = lorem_ipsum() + bla(1000)
                ret = self.api.carrier_full_create_post(body=data)
                assert (not ret.success)
            except Exception as e:
                assert ('Longer than' in str(e))
            data[field] = bla(16)
        data['login']=bla(5)
        data['password'] = bla(5)
        print(json.dumps(data))
        ret = self.api.carrier_full_create_post(body=data)
        assert (ret.success)
        print(ret)

        pass

    def test_carrier_full_create_post_1(self):
        """
        Test case for carrier_full_create_post1

        
        """
        data = data_full()
        data['rate_email'] = bla_mail() + ';invalid!email'
        try:
            ret = self.api.carrier_full_create_post(body=data)
            assert (not ret.success)
        except Exception as e:
            assert ('invalid emails' in str(e))

        data=data_full()
        data['noc_email'] = bla_mail()+';'+bla_mail()
        ret = self.api.carrier_full_create_post(body=data)
        assert (ret.success)
        id = ret.object_id
        ret = self.api.carrier_client_id_egress_trunk_post(client_id=id,body=egress_trunk())
        assert (ret.success)
        ret = self.api.carrier_client_id_ingress_trunk_post(client_id=id, body=ingress_trunk())
        assert (ret.success)
        obj=self.api.carrier_client_id_get(client_id=id)
        assert (obj.success)
        assert (obj.payload.egress_count==1 and obj.payload.ingress_count==1)
        us = cli_dnl.AuthApi().user_list_get(name=data['login'])
        assert (us.success and len(us.payload.items) == 1)
        r = cli_dnl.AuthApi().auth_post(body={'email_or_name': data['login'], 'password': data['password']})
        assert(r.success)
        assert (obj.payload.company == data['company_name'])


        pass

    def test_carrier_full_create_post_2_login(self):
        """
        Test case for carrier_full_create_post1


        """
        data = data_full()
        ret = self.api.carrier_full_create_post(body=data)
        assert (ret.success)
        print(ret)
        u = cli_dnl.AuthApi().user_list_get(name=data['login'])
        assert (u.success and len(u.payload.items) == 1)

    def test_carrier_full_create_post_3_no_login(self):
        """
        Test case for carrier_full_create_post1


        """
        data = data_full()
        del data['login']
        del data['password']
        ret = self.api.carrier_full_create_post(body=data)
        assert (ret.success)
        print(ret)
        u = cli_dnl.AuthApi().user_list_get(name=data['carrier_name'])
        assert (u.success and len(u.payload.items) == 0)

    def test_carrier_group_all_delete(self):
        """
        Test case for carrier_group_all_delete


        """
        ret=self.api.carrier_group_all_delete()
        assert (ret.success)
        pass

    def test_carrier_group_create_post(self):
        """
        Test case for carrier_group_create_post

        
        """
        data = {'group_name': 'gr_' + bla(2)}
        try:
            r = self.api.carrier_group_create_post(body=data)
            assert (not r.success)
        except Exception as e:
            assert ('Client list' in str(e))

        data = {'group_name': 'gr_' + bla(2), 'clients': []}
        try:
            r = self.api.carrier_group_create_post(body=data)
            assert (not r.success)
        except Exception as e:
            assert ('more' in str(e))
        cid, cl, cls = rand_client(per_page=100)
        random.shuffle(cls)
        for it in cls[0:5]:
            data['clients'].append(it.client_id)
        r = self.api.carrier_group_create_post(body=data)
        assert (r.success)
        return r
        pass

    def test_carrier_group_group_id_delete(self):
        """
        Test case for carrier_group_group_id_delete

        
        """
        #ret=self.api.carrier_group_group_id_delete(group_id=rand_carrier_group()[0])

        ret = self.api.carrier_group_group_id_delete(group_id=self.test_carrier_group_create_post().object_id)
        assert(ret.success)
        pass

    def test_carrier_group_group_id_get(self):
        """
        Test case for carrier_group_group_id_get

        
        """
        id, gr, ls = rand_carrier_group()
        ret = self.api.carrier_group_group_id_get(group_id=id)
        assert (ret.success and ret.payload.group_name==gr.group_name)
        pass

    def test_carrier_group_group_id_patch(self):
        """
        Test case for carrier_group_group_id_patch

        
        """
        id,gr,ls=rand_carrier_group()
        data={'group_name':gr.group_name+'_'+bla(2),'clients':[]}
        cid, cl, cls = rand_client(per_page=100)
        random.shuffle(cls)
        for it in cls[0:5]:
            data['clients'].append(it.client_id)
        r = self.api.carrier_group_group_id_patch(group_id=id,body=data)
        assert (r.success)
        assert(data['group_name']==r.payload.group_name)
        pass

    def test_carrier_group_list_get(self):
        """
        Test case for carrier_group_list_get

        
        """
        ret=self.api.carrier_group_list_get()
        assert (ret.success)
        pass

    def test_carrier_list_get(self):
        """
        Test case for carrier_list_get

        
        """
        auth()
        ret = self.api.carrier_list_get(fields='client_id')
        assert (ret.success)
        return

        for dir in ['asc','desc']:
            for sort in ['name', 'is_active','is_prepay','company','update_by','unlimited_credit',
                         'ingress_count','egress_count','carrier_template_id','mode','group_id',
                         'credit_limit', 'update_at','login','profit_margin']:
                ret=self.api.carrier_list_get(order_by=sort,order_dir=dir,per_page=3)
                print(sort,'success')
                assert(ret.success)
        ret=self.api.carrier_list_get(group_id=rand_carrier_group()[0])
        assert(ret.success)
        ret = self.api.carrier_list_get(is_active=True, per_page=3)
        assert (ret.success)
        ret = self.api.carrier_list_get(payment_term_id=rand_payment_term()[0], per_page=3)
        assert (ret.success)
        ret = self.api.carrier_list_get(update_by='admin', per_page=3)
        assert (ret.success)
        ret = self.api.carrier_list_get(company='denovo', per_page=3)
        assert (ret.success)
        ret = self.api.carrier_list_get(ingress_count=2, per_page=3)
        assert (ret.success)
        ret = self.api.carrier_list_get(carrier_template_id=2, per_page=3)
        assert (ret.success)
        ret = self.api.carrier_list_get(is_prepay=False, per_page=3)
        assert (ret.success)
        ret = self.api.carrier_list_get(credit_limit_gt=3, per_page=3)
        assert (ret.success)
        ret = self.api.carrier_list_get(credit_limit_lt=3, per_page=3)
        assert (ret.success)
        ret = self.api.carrier_list_get(egress_count=3, per_page=3,order_by='egress_count')
        assert (ret.success)
        ret = self.api.carrier_list_get(name='string', per_page=3)
        assert (ret.success)
        ret = self.api.carrier_list_get(update_at_gt=datetime.now()-timedelta(days=30), per_page=3)
        assert (ret.success)
        ret = self.api.carrier_list_get(update_at_lt=datetime.now()-timedelta(days=30), per_page=3)
        assert (ret.success)

        pass

    def test_carrier_simple_list_get(self):
        """
        Test case for carrier_simple_list_get


        """
        for dir in ['asc','desc']:
            for sort in ['client_id', 'name', 'email', 'status', 'client_type', 'mode', 'group_id','ingress_count']:
                ret=self.api.carrier_simple_list_get(order_by=sort,order_dir=dir,per_page=3)
                print(sort, 'success')
                assert (ret.success)
        pass

    def test_client_credit_client_id_patch(self):
        """
        Test case for client_credit_client_id_patch

        
        """
        data={
  'call_limit': get_rand('int')*100000,
  'cps_limit': get_rand('int'),
  'credit_limit': round(random.random()*3000.0,2),
  'active': get_rand('bool'),
  'payment_term_id': rand_payment_term()[0],
  'unlimited_credit': get_rand('bool')
}
        id=rand_client()[0]
        print(id,json.dumps(data))
        ret=self.api.client_credit_client_id_patch(client_id=id,body=data)
        assert (ret.success)
        assert(ret.payload.unlimited_credit == data['unlimited_credit'])
        pass

    def test_client_credit_list_get(self):
        """
        Test case for client_credit_list_get

        
        """
        for dir in ['asc','desc']:
            for sort in ['actual_balance','active','name','call_limit','cps_limit','billing_mode','payment_term_name','update_by',
                         'credit_limit', 'update_at', 'last_payment_date', 'last_payment_amount']:
                ret=self.api.client_credit_list_get(order_by=sort,order_dir=dir,per_page=3)
                print(sort,dir, 'success')
                assert (ret.success)

        ret=self.api.client_credit_list_get()
        assert(ret.success)
        pass

    def test_client_past_due_list_get(self):
        """
        Test case for client_past_due_list_get

        
        """
        ret = self.api.client_past_due_list_get(over_due_gt=10000)
        assert (ret.success)
        print(ret)
        ret = self.api.client_past_due_list_get(over_due_isnull=False)
        assert (ret.success)
        print(len(ret.payload.items))
        pass

    def test_egress_capacity_egress_id_ingress_id_delete(self):
        """
        Test case for egress_capacity_egress_id_ingress_id_delete


        """
        id = rand_trunk(direction='egress')[0]
        pid = rand_trunk(direction='ingress')[0]
        ret = self.api.egress_trunk_resource_id_capacity_list_get(resource_id=id)
        assert (ret.success)
        if len(ret.payload.items) == 0:
            data = {'ingress_id': pid,
                    'max_cps': get_rand('int'),
                    'max_cap': get_rand('int')
                    }
            ret1 = self.api.egress_trunk_resource_id_capacity_post(resource_id=id, body=data)
            assert (ret1.success)
            ret = self.api.egress_trunk_resource_id_capacity_list_get(resource_id=id)
            assert (ret.success)
        pid = random.choice(ret.payload.items).ingress_id

        ret2 = self.api.egress_capacity_egress_id_ingress_id_delete(egress_id=id, ingress_id=pid)
        assert (ret2.success)
        pass

    def test_egress_capacity_egress_id_ingress_id_get(self):
        """
        Test case for egress_capacity_egress_id_ingress_id_get


        """
        id = rand_trunk(direction='egress')[0]
        pid = rand_trunk(direction='ingress')[0]
        ret = self.api.egress_trunk_resource_id_capacity_list_get(resource_id=id)
        assert (ret.success)
        if len(ret.payload.items) == 0:
            data = {'ingress_id': pid,
                    'max_cps': get_rand('int'),
                    'max_cap': get_rand('int')
                    }
            ret1 = self.api.egress_trunk_resource_id_capacity_post(resource_id=id, body=data)
            assert (ret1.success)
            ret = self.api.egress_trunk_resource_id_capacity_list_get(resource_id=id)
            assert (ret.success)
        pid = random.choice(ret.payload.items).ingress_id

        ret2 = self.api.egress_capacity_egress_id_ingress_id_get(egress_id=id, ingress_id=pid)
        assert (ret2.success)
        pass

    def test_egress_capacity_egress_id_ingress_id_patch(self):
        """
        Test case for egress_capacity_egress_id_ingress_id_patch


        """
        id = rand_trunk(direction='egress')[0]
        pid=rand_trunk(direction='ingress')[0]
        ret = self.api.egress_trunk_resource_id_capacity_list_get(resource_id=id)
        assert (ret.success)
        if len(ret.payload.items) == 0:
            data = {'ingress_id': pid,
                    'max_cps':get_rand('int'),
                    'max_cap': get_rand('int')
                    }
            ret1 = self.api.egress_trunk_resource_id_capacity_post(resource_id=id, body=data)
            assert (ret1.success)
            ret = self.api.egress_trunk_resource_id_capacity_list_get(resource_id=id)
            assert (ret.success)
        pid = random.choice(ret.payload.items).ingress_id

        ret2 = self.api.egress_capacity_egress_id_ingress_id_get(egress_id=id, ingress_id=pid)
        assert (ret2.success)
        print(ret2.payload.to_dict())

        data3 = {'max_cps': get_rand('int'), 'max_cap': get_rand('int'), 'ingress_id': rand_trunk(direction='ingress')[0]}
        ret3 = self.api.egress_capacity_egress_id_ingress_id_patch(egress_id=id,ingress_id=pid, body=data3)
        assert (ret3.success and ret3.payload.max_cps == data3['max_cps'])
        print(ret3.payload.to_dict())

        data4 = {'max_cps': get_rand('int'), 'max_cap': get_rand('int'),
                 'ingress_id': rand_trunk(direction='ingress')[0]}
        try:
            ret4 = self.api.egress_capacity_egress_id_ingress_id_patch(egress_id=id, ingress_id=pid, body=data4)
            assert(not ret4.success)
        except Exception as e:
            assert('not_found_error' in str(e))
        pid=data3['ingress_id']
        ret4 = self.api.egress_capacity_egress_id_ingress_id_patch(egress_id=id, ingress_id=pid, body=data4)
        assert (ret4.success and ret4.payload.max_cps == data4['max_cps'])
        print(ret4.payload.to_dict())
        pass

    def test_egress_profile_id_delete(self):
        """
        Test case for egress_profile_id_delete


        """
        id = rand_trunk(direction='egress')[0]

        ret = self.api.egress_trunk_resource_id_profile_list_get(resource_id=id)
        assert (ret.success)
        if len(ret.payload.items)==0:
            data = {'profile_id': rand_switch_profile()[0], 'ingress_id': rand_trunk(direction='ingress')[0]
                }
            ret1 = self.api.egress_trunk_resource_id_profile_post(resource_id=id, body=data)
            assert (ret1.success)
            ret = self.api.egress_trunk_resource_id_profile_list_get(resource_id=id)
            assert (ret.success and len(ret.payload.items))
        pid=random.choice(ret.payload.items).id
        ret2 = self.api.egress_profile_id_delete(id=pid)
        assert (ret2.success)

        pass

    def test_egress_profile_id_get(self):
        """
        Test case for egress_profile_id_get


        """
        id = rand_trunk(direction='egress')[0]
        ret = self.api.egress_trunk_resource_id_profile_list_get(resource_id=id)
        assert (ret.success)
        if len(ret.payload.items) == 0:
            data = {'profile_id': rand_switch_profile()[0], 'ingress_id': rand_trunk(direction='ingress')[0]
                    }
            ret1 = self.api.egress_trunk_resource_id_profile_post(resource_id=id, body=data)
            assert (ret1.success)
            ret = self.api.egress_trunk_resource_id_profile_list_get(resource_id=id)
            assert (ret.success)
        pid = random.choice(ret.payload.items).id
        ret2 = self.api.egress_profile_id_get(id=pid)
        assert (ret2.success and ret2.payload.egress_id==id)
        pass

    def test_egress_profile_id_patch(self):
        """
        Test case for egress_profile_id_patch


        """
        id = rand_trunk(direction='egress')[0]
        ret = self.api.egress_trunk_resource_id_profile_list_get(resource_id=id)
        assert (ret.success)
        if len(ret.payload.items) == 0:
            data = {'profile_id': rand_switch_profile()[0], 'ingress_id': rand_trunk(direction='ingress')[0]
                    }
            ret1 = self.api.egress_trunk_resource_id_profile_post(resource_id=id, body=data)
            assert (ret1.success)
            ret = self.api.egress_trunk_resource_id_profile_list_get(resource_id=id)
            assert (ret.success)
        pid = random.choice(ret.payload.items).id
        data2 = {'profile_id': rand_switch_profile()[0], 'ingress_id': rand_trunk(direction='ingress')[0]
                }
        ret2 = self.api.egress_profile_id_patch(id=pid,body=data2)
        assert (ret2.success and ret2.payload.ingress_id==data2['ingress_id'])
        pass

    def test_egress_trunk_resource_id_actions_get(self):
        """
        Test case for egress_trunk_resource_id_actions_get


        """
        pass

    def test_egress_trunk_resource_id_actions_patch(self):
        """
        Test case for egress_trunk_resource_id_actions_patch


        """
        pass

    def test_egress_trunk_resource_id_capacity_list_get(self):
        """
        Test case for egress_trunk_resource_id_capacity_list_get


        """
        pass

    def test_egress_trunk_resource_id_capacity_post(self):
        """
        Test case for egress_trunk_resource_id_capacity_post


        """

        pass

    def test_egress_trunk_resource_id_delete(self):
        """
        Test case for egress_trunk_resource_id_delete

        
        """
        tr=self.test_carrier_client_id_egress_trunk_post()

        ret=self.api.egress_trunk_resource_id_delete(resource_id=tr.resource_id)
        assert(ret.success)
        tr = self.test_carrier_client_id_egress_trunk_post()

        ret=self.api.egress_trunk_resource_id_delete(resource_id=rand_trunk(direction='egress')[0])
        assert (ret.success)

        #ret = self.api.egress_trunk_resource_id_delete(resource_id=7)
        #assert (ret.success)
        pass

    def test_egress_trunk_resource_id_dyn_routes_patch(self):
        """
        Test case for egress_trunk_resource_id_dyn_routes_patch


        """
        dl=rand_dynamic_route()[2]
        random.shuffle(dl)
        id=rand_trunk(direction='egress')[0]
        data=dict(dynamic_routes=[])
        for  d in dl[0:4]:
            data['dynamic_routes'].append(dict(dynamic_route_id=d.dynamic_route_id))
        print(id,json.dumps(data))
        ret=self.api.egress_trunk_resource_id_dyn_routes_patch(resource_id=id,body=data)
        assert(ret.success)
        print(ret)
        pass

    def test_egress_trunk_resource_id_get(self):
        """
        Test case for egress_trunk_resource_id_get

        
        """
        r=self.api.egress_trunk_resource_id_get(resource_id=rand_trunk(direction='egress')[0])
        assert(r.success)
        assert(r.payload.auth_type in ['All', 'Authorized by Host Only', 'Accept Egress Registration', 'Register to Egress Trunk'])
        assert(r.payload.ip[0].resource_ip_id)
        pass

    def test_egress_trunk_resource_id_pass_get(self):
        """
        Test case for egress_trunk_resource_id_pass_get


        """
        id=rand_trunk(direction="egress")[0]
        ret = self.api.egress_trunk_resource_id_pass_get(resource_id=id)
        assert(ret.success)
        pass

    def test_egress_trunk_resource_id_pass_patch(self):
        """
        Test case for egress_trunk_resource_id_pass_patch


        """
        
        data ={
            'cli_type': random.choice(['white', 'white non cli', 'gray']),
            'rpid_id_type': random.choice(['None', 'Subscriber', 'User', 'Term', 'Proxy']),
            'priv': random.choice(['Yes','No']),
            'paid': random.choice(['Yes','No']),
            'div': random.choice(['Yes','No']),
            'rpid': random.choice(['Never', 'Pass Through', 'Always']),
            'pass_through': random.choice(['transparent', 'not pass through the ban']),
            'display_name': get_rand('bool'),
            'rpid_screen': random.choice(['None', 'No', 'Yes', 'Proxy']),
            'oli': random.choice(['Yes','No']),
            'rpid_privacy': random.choice(['None', 'Full', 'Name', 'Url', 'OFF', 'Ipaddr', 'Proxy']),
            'rpid_party': random.choice(['None', 'Calling', 'Called', 'Proxy']),
            'pci': random.choice(['Yes','No']),
            'rate_rounding':random.choice(['Up','Down']),
            'rate_decimal':random.randint(0,6),
            'jurisdiction_use_dnis':random.choice(['LRN','DNIS'])
        }
        id=rand_trunk(direction='egress')[0]
        print(id,json.dumps(data))
        ret = self.api.egress_trunk_resource_id_pass_patch(resource_id=id,body=data)
        assert (ret.success)
        return
        data0=ret.payload.to_dict()
        for attr in [ 'paid', 'oli', 'pci', 'priv', 'div',  'display_name']:
            assert(data[attr]==data0[attr])
        print(data0)
        pass

    def test_egress_trunk_resource_id_patch(self):
        """
        Test case for egress_trunk_resource_id_patch

        
        """
        auth()
        ret = cli_dnl.TrunkApi().trunk_egress_list_get()
        assert (ret.success)
        tr = random.choice(ret.payload.items)
        data = {'ani_cps_limit':random.randint(10,1000),
                'ani_cap_limit':random.randint(10,1000),
                'dnis_cps_limit':random.randint(10,1000),
                'dnis_cap_limit':random.randint(10,1000)
                }
        r = self.api.egress_trunk_resource_id_patch(resource_id=tr.trunk_id,body=data)
        assert (r.success)
        r = self.api.egress_trunk_resource_id_get(resource_id=tr.trunk_id)
        assert (r.success)
        assert(r.payload.dnis_cap_limit==data['dnis_cap_limit'])
        pass

    def test_egress_trunk_resource_id_profile_list_get(self):
        """
        Test case for egress_trunk_resource_id_profile_list_get


        """
        ret=self.api.egress_trunk_resource_id_profile_list_get(resource_id=rand_trunk(direction='egress')[0])
        assert (ret.success)
        pass

    def test_egress_trunk_resource_id_profile_post(self):
        """
        Test case for egress_trunk_resource_id_profile_post


        """

        id=rand_trunk(direction='egress')[0]
        lst = self.api.egress_trunk_resource_id_profile_list_get(resource_id=id).payload.items
        ing = [i.ingress_id for i in lst]
        lst_tr = rand_trunk(direction='ingress')[2]
        tr=None
        for i in lst_tr:
            if not i.trunk_id in ing:
                tr=i.trunk_id
                break
        data={ 'profile_id':rand_switch_profile()[0],'ingress_id': tr
        }
        ret=self.api.egress_trunk_resource_id_profile_post(resource_id=id,body=data)
        assert (ret.success)

        ret1=self.api.egress_profile_id_get(id=ret.object_id)
        assert (ret1.success and ret1.payload.egress_id==id)

        ret2 = self.api.egress_trunk_resource_id_profile_list_get(resource_id=id)
        assert (ret2.success and len(ret2.payload.items))
        pass

    def test_egress_trunk_resource_id_profiles_patch(self):
        """
        Test case for egress_trunk_resource_id_profiles_patch


        """
        id = rand_trunk(direction='egress')[0]
        lst = self.api.egress_trunk_resource_id_profile_list_get(resource_id=id).payload.items
        ing = [i.ingress_id for i in lst]
        lst_tr = rand_trunk(direction='ingress')[2]
        random.shuffle(lst_tr)
        tr = None
        data = {'profiles':[]}
        for i in lst_tr[0:4]:
            data['profiles'].append({'profile_id': rand_switch_profile()[0], 'ingress_id': i.trunk_id})
        ret = self.api.egress_trunk_resource_id_profiles_patch(resource_id=id, body=data)
        assert (ret.success)
        pass

    def test_egress_trunk_resource_id_static_routes_patch(self):
        """
        Test case for egress_trunk_resource_id_static_routes_patch


        """
        id = rand_trunk(direction='egress')[0]
        stid =rand_static_route()[0]
        data = {'static_route_items':[ dict(static_route_id=stid,
                                            prefix=dig(7)),
                                       dict(static_route_id=stid,
                                            prefix=dig(7))
                                       ]}
        print(id,data)
        ret = self.api.egress_trunk_resource_id_static_routes_patch(resource_id=id, body=data)
        assert (ret.success)
        print(ret)
        pass

    def test_ingress_trunk_resource_id_actions_get(self):
        """
        Test case for ingress_trunk_resource_id_actions_get


        """
        pass

    def test_ingress_trunk_resource_id_actions_patch(self):
        """
        Test case for ingress_trunk_resource_id_actions_patch


        """
        pass

    def test_ingress_trunk_resource_id_capacity_list_get(self):
        """
        Test case for ingress_trunk_resource_id_capacity_list_get


        """
        pass

    def test_ingress_trunk_resource_id_delete(self):
        """
        Test case for ingress_trunk_resource_id_delete

        
        """
        id = rand_trunk(direction='ingress')[0]
        ret = self.api.ingress_trunk_resource_id_delete(resource_id=id)
        assert (ret.success)
        pass

    def test_ingress_trunk_resource_id_get(self):
        """
        Test case for ingress_trunk_resource_id_get

        
        """
        id,tr,ls=rand_trunk(direction='ingress')
        ret=self.api.ingress_trunk_resource_id_get(resource_id=id)
        assert(ret.success and tr.trunk_name==ret.payload.name)
        pass

    def test_ingress_trunk_resource_id_patch_reg(self):
        """
        Test case for ingress_trunk_resource_id_patch


        """
        id = rand_trunk(direction='ingress')[0]
        print(id)
        data  = {'reg_user': [{'username': bla(8), 'password': bla(8),'profile_id':rand_switch_profile()[0]}]}
        ret = self.api.ingress_trunk_resource_id_patch(resource_id=id,body=data)
        assert(ret.success)
        print(data,ret.payload.reg_user)
        data = {
        'reg_gateway': [{'username': bla(8), 'password': bla(8), 'reg_srv_ip': ip(check_dublicates=False),
                         'reg_srv_port': random.randint(1000, 65535),'profile_id':rand_switch_profile()[0]}]}
        ret = self.api.ingress_trunk_resource_id_patch(resource_id=id, body=data)
        assert (ret.success)
        print(data,ret.payload.reg_gateway)
        data = {'reg_user': []}
        ret = self.api.ingress_trunk_resource_id_patch(resource_id=id, body=data)
        assert (ret.success)
        print(ret.payload.reg_user)
        data = {
            'reg_gateway': []}
        ret = self.api.ingress_trunk_resource_id_patch(resource_id=id, body=data)
        assert (ret.success)
        print(ret.payload.reg_gateway)

    def test_ingress_trunk_resource_id_patch(self):
        """
        Test case for ingress_trunk_resource_id_patch

        
        """
        tr = rand_trunk(direction='ingress')[0]
        data = ingress_trunk()
        ips = cli_dnl.TrunkApi().trunk_ip_list_get()
        assert(ips.success)
        ls = ips.payload.items
        do=False
        for ls0 in ls:
            if ls0.resource_id != tr:

                try:
                    tr0=self.api.ingress_trunk_resource_id_get(resource_id=ls0.resource_id).payload
                except Exception as e:
                    continue
                data['ip'].append({'ip': ls0.ip,'port':ls0.port})
                if 'prefix' in data:
                    del data['prefix']
                if 'prefixes' in data:
                    del data['prefixes']
                if len(tr0.prefixes):
                    data['prefix']=tr0.prefixes[0].tech_prefix
                do=True
                break
        if do:
            try:
                ret = self.api.ingress_trunk_resource_id_patch(resource_id=tr, body=data)
                assert (not ret.success)
            except Exception as e:
                assert('prefix' in str(e))

        data=ingress_trunk()

        obj=self.api.ingress_trunk_resource_id_get(resource_id=tr)
        for i in obj.payload.ip[0:2]:
            if i.port:
                if i.port >=65535 or i.port <1000:
                    i.port=1000
            data['ip'].append({'ip': i.ip,'port':i.port})

        ret = self.api.ingress_trunk_resource_id_patch(resource_id=tr, body=data)
        assert (ret.success)
        data = ingress_trunk()
        data['ip'].append({'ip': ip()})
        ret = self.api.ingress_trunk_resource_id_patch(resource_id=tr, body=data)
        assert (ret.success)
        data = ingress_trunk()
        if 'prefix' in data:
            del data['prefix']
        if 'prefixes' in data:
            del data['prefixes']
        data['ip'].append({'ip': ip()})
        try:
            ret = self.api.ingress_trunk_resource_id_patch(resource_id=tr, body=data)
            assert (not ret.success)
        except Exception as e:
            assert ('more than one IP' in str(e))
        data = ingress_trunk()
        for tech_prefix in ['x',None,'null','NULL','']:
            if 'prefix' in data:
                del data['prefix']
            if 'prefixes' in data:
                del data['prefixes']
            data['prefixes']=[]
            data['prefixes'].append({'tech_prefix': dig(6)})
            if tech_prefix=='x':
                data['prefixes'].append({'code': dig(6)})
            else:
                data['prefixes'].append({'code': dig(6),'tech_prefix':tech_prefix})
            try:
                print(data['prefixes'])
                ret = self.api.ingress_trunk_resource_id_patch(resource_id=tr, body=data)
                assert (not ret.success)
            except Exception as e:
                assert ('empty prefix' in str(e))

        pass


if __name__ == '__main__':
    unittest.main()
