# coding: utf-8

"""
    DNL API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

    OpenAPI spec version: 1.2.63
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import os
import sys
import unittest

import cli_dnl
from cli_dnl.rest import ApiException
from cli_dnl.apis.config_api import ConfigApi
from .settings import *

def carrier_template():
    data ={
          'auto_daily_balance_recipient':random.choice(['Partner Billing Contact', 'Owner Billing Contact','Both']),
          'auto_send_invoice':get_rand('bool'),
          'auto_send_zone':'%+03d00' % random.randint(-12, 12),
          'auto_summary_group_by': random.choice(['By Country', 'By Code Name', 'By Code']),
          'auto_summary_hour': random.randint(0, 24),
          'auto_summary_not_zero':get_rand('bool'),
          'auto_summary_period': random.choice([1, 2, 4, 6, 8, 12, 24, -15, -30]),
          #'billing_email':bla_mail(),
          'call_limit': random.randint(0,10000),
          'cdr_format': random.choice(['Excel', 'CSV', 'zip', 'tar.gz']),
          #'company_name': 'Denovolab ' + bla(6),
          'cps_limit' : random.randint(0,10000),
          'credit_limit': get_rand('float'),
          'currency': rand_currency()[1].code,
          'daily_cdr_generation':get_rand('bool'),
          'daily_cdr_generation_zone':'%+03d00' % random.randint(-12, 12),
          'decimal': random.randint(0, 5),
          #'email':bla_mail(),
          'format': random.choice(['PDF', 'Excel', 'HTML']),
          'include_short_call_charge':get_rand('bool'),
          'include_tax':get_rand('bool'),
          'inlcude_cdr_in_email':get_rand('bool'),
          'invoice_zone':'%+03d00' % random.randint(-12, 12),
          'is_auto_balance':get_rand('bool'),
          'is_auto_summary':get_rand('bool'),
          'is_breakdown_by_rate_table':get_rand('bool'),
          'is_daily_balance_notification':get_rand('bool'),
          #'is_panel_accountsummary':get_rand('bool'),
          #'is_panel_balance':get_rand('bool'),
          #'is_panel_cdrslist':get_rand('bool'),
          #'is_panel_invoices':get_rand('bool'),
          #'is_panel_onlinepayment':get_rand('bool'),
          #'is_panel_paymenthistory':get_rand('bool'),
          #'is_panel_products':get_rand('bool'),
          #'is_panel_ratetable':get_rand('bool'),
          #'is_panel_sippacket':get_rand('bool'),
          #'is_panel_summaryreport':get_rand('bool'),
          #'is_panel_trunks':get_rand('bool'),
          'is_send_trunk_update':get_rand('bool'),
          'is_short_duration_call_surcharge_detail':get_rand('bool'),
          'is_show_code_name':get_rand('bool'),
          'is_show_country':get_rand('bool'),
          'is_show_daily_usage':get_rand('bool'),
          'is_show_total_trunk':get_rand('bool'),
          'unlimited_credit':get_rand('bool'),
          'mode':random.choice(['prepay','postpay']),
          #'noc_email':bla_mail(),
          'non_zero_invoice_only':get_rand('bool'),
          'notify_client_balance_type':random.randint(0, 2),
          'payment_received_notice':get_rand('bool'),
          'payment_term':rand_payment_term()[1].name,
          'profit_margin':random.random() * 10,
          'profit_type': random.choice(['percentage', 'value']),
          #'rate_delivery_email':bla_mail(),
          'rate_value': random.choice(['Actual Value', 'Average Value']),
          'scc_below':get_rand('int'),
          'scc_charge':get_rand('int'),
          'scc_percent':random.random() * 100,
          'scc_type': random.choice(['meeting the short duration defined neighboring', 'that exceed the defined percentage']),
          'send_invoice_as_link':get_rand('bool'),
          'show_account_summary':get_rand('bool'),
          'show_code_name_summary':get_rand('bool'),
          'show_code_summary':get_rand('bool'),
          'show_country_summary':get_rand('bool'),
          'show_daily_usage':get_rand('bool'),
          'show_detail_by_trunk':get_rand('bool'),
          'show_jurisdiction_detail':get_rand('bool'),
          'show_payment_summary':get_rand('bool'),
          'show_trunk_summary':get_rand('bool'),
          'tax':random.random() * 100,
          'template_name':'template_test_'+bla(7),
          'test_credit':random.random() * 10000,
          'time_zone':'%+03d00' % random.randint(-12, 12),
          'usage_fields':[]
    }
    data['low_balance_config']= {
        'is_notify':get_rand('bool'),
        'value_type': random.choice(['Actual Balance', 'Percentage']),
        'actual_notify_balance':get_rand('float'),
        'percentage_notify_balance':get_rand('float'),
        'send_time_type': random.choice(['daily', 'hourly']),
        'daily_send_time': random.randint(0, 24),
        'duplicate_days':get_rand('bool'),
        'send_to':get_rand('int'),
        'duplicate_send_days': get_rand('int'),
        'disable_trunks_days': get_rand('int')
        }
    ret=cli_dnl.ConfigApi().config_cdr_visibility_list_get()
    assert(ret.success)
    fields=ret.payload.items
    random.shuffle(fields)
    for field in fields[0:10]:
        data['usage_fields'].append(field.db_name)
    return data

class TestConfigApi(unittest.TestCase):
    """ ConfigApi unit test stubs """

    def setUp(self):
        self.api = cli_dnl.apis.config_api.ConfigApi()
        auth()

    def tearDown(self):
        pass

    def test_config_auto_cdr_format_edit_patch(self):
        """
        Test case for config_auto_cdr_format_edit_patch

        
        """
        ret=self.api.config_cdr_visibility_list_get(per_page=100)
        assert(ret.success)

        item=random.choice(ret.payload.items)
        data = {'items': [{'id':item.id,'display_name':bla_bla(2),'client_viewable':get_rand('bool')}]}
        ret1=self.api.config_auto_cdr_format_edit_patch(body=data)
        assert (ret1.success)
        data = {'items': [{'id': item.id, 'display_name': item.display_name, 'client_viewable': item.client_viewable}]}
        ret2 = self.api.config_auto_cdr_format_edit_patch(body=data)
        assert (ret2.success)
        pass

    def test_config_carrier_template_all_delete(self):
        """
        Test case for config_carrier_template_all_delete

        
        """
        ret=self.api.config_carrier_template_all_delete()
        assert (ret.success)
        id1 = self.test_config_carrier_template_create_post().object_id
        id2 = self.test_config_carrier_template_create_post().object_id
        ret = self.api.config_carrier_template_all_delete(id_in=str(id1)+','+str(id2))
        assert (ret.success)
        self.test_config_carrier_template_create_post()
        pass

    def test_config_carrier_template_create_post(self):
        """
        Test case for config_carrier_template_create_post

        
        """
        auth()

        data=carrier_template()
        del data['credit_limit']
        del data['profit_margin']
        if 'allowed_credit' in data:
            del data['allowed_credit']
        r = self.api.config_carrier_template_create_post(body=carrier_template())
        assert (r.success)
        print(r)
        return

        data = carrier_template()
        data['credit_limit']=None
        r = self.api.config_carrier_template_create_post(body=carrier_template())
        assert (r.success)

        r = self.api.config_carrier_template_create_post(body=carrier_template())
        assert (r.success)

        data ={ 'test_credit': 100, 'template_name': 'carrier_temp_'+bla(6),
                'mode': 'prepay', 'profit_margin': 0}
        r = self.api.config_carrier_template_create_post(body=data)
        assert (r.success)

        profit_type = ['percentage', 'value']
        mode = ['prepay', 'postpay']
        curr = cli_dnl.SwitchApi().switch_currency_list_get()
        assert (curr.success)
        cid=random.choice(curr.payload.items)
        data = {'name':bla(7),'profit_margin':random.random()*0.1,'credit_limit':-random.random()*1000,
                'profit_type':random.choice(profit_type),'mode':random.choice(['prepay', 'postpay']),
                'currency':cid.code,'payment_received_notice':get_rand('bool')}
        r=self.api.config_carrier_template_create_post(body=data)
        assert (r.success)
        return r
        pass

    def test_config_carrier_template_id_delete(self):
        """
        Test case for config_carrier_template_id_delete

        
        """
        r=self.test_config_carrier_template_create_post()
        d=self.api.config_carrier_template_id_delete(id=r.object_id)
        assert(r.success)
        pass

    def test_config_carrier_template_id_get(self):
        """
        Test case for config_carrier_template_id_get

        
        """
        r = self.test_config_carrier_template_create_post()
        g = self.api.config_carrier_template_id_get(id=r.object_id)
        assert (g.success)
        d = self.api.config_carrier_template_id_delete(id=r.object_id)
        assert (r.success)



    def test_config_carrier_template_id_patch(self):
        """
        Test case for config_carrier_template_id_patch

        
        """
        auth()
        order=['used_by','create_by','update_on','create_on','template_name']
        o=random.choice(order)
        for o in order:
            lst=self.api.config_carrier_template_list_get(order_by=o,order_dir=random.choice(['asc','desc']))
            assert(lst.success)
        random.shuffle(lst.payload.items)
        templ=lst.payload.items[0]
        attrs = [(k,t) for k,t in cli_dnl.CarrierTemplate.swagger_types.items() if  t in ['str','int','bool'] and
                 k not in ['currency','profit_type','mode']]
        data={}
        for i in range(0,7):
            k,t = random.choice(attrs)
            value =get_rand(t)

            if k == 'format':
                value=random.choice(['PDF','Excel','HTML'])
            if k == 'rate_value':
                value=random.choice(['Actual Value', 'Average Value'])
            if k == 'auto_summary_group_by':
                value=random.choice(['By Country', 'By Code Name', 'By Code'])
            if k == 'cdr_format':
                value=random.choice(['CSV','Excel','zip','tar.gz'])
            if k == 'scc_type':
                value = random.choice([0,1])
                    #['meeting the short duration defined neighboring','that exceed the defined percentage'])
            if k == 'payment_term':
                ret=self.api.config_payment_term_list_get()
                value=random.choice([p.name for p in ret.payload.items])
            if k == 'auto_daily_balance_recipient':
                value=random.choice(['Partner Billing Contact', 'Owner Billing Contact', 'Both'])

            data[k]=value
        data['invoice_zone'] = '%+03d00' % random.randint(-12, 12)
        data['time_zone'] = '%+03d00' % random.randint(-12, 12)
        data['template_name']=bla_bla(5)
        data['rate_table_id'] = rand_rate_table()[0]


        p=self.api.config_carrier_template_id_patch(templ.id,body=data)
        assert(p.success)
        p = self.api.config_carrier_template_id_patch(templ.id, body=data)
        assert (p.success)
        templ1 = lst.payload.items[1]
        data['template_name']=templ1.template_name
        try:
            p = self.api.config_carrier_template_id_patch(templ.id, body=data)
            assert (not p.success)
        except Exception as e:
            assert ('already' in str(e))

    def test_config_carrier_template_list_get(self):
        """
        Test case for config_carrier_template_list_get

        
        """
        order = ['used_by', 'create_by', 'update_on', 'create_on', 'template_name']
        for o in order:
            lst = self.api.config_carrier_template_list_get(order_by=o, order_dir=random.choice(['asc', 'desc']))
            assert (lst.success)
        pass

    def test_config_cdr_visibility_create_post(self):
        """
        Test case for config_cdr_visibility_create_post

        
        """
        data={
            'admin_default': get_rand('bool'),
            'client_viewable': get_rand('bool'),
            'db_name': (bla(4)+'_'+bla(4)).lower(),
            'vendor_viewable': get_rand('bool'),
            'client_cdr_delivery': get_rand('bool'),
            'display_name': bla(15),
            'vendor_cdr_delivery': get_rand('bool')
        }
        ret=self.api.config_cdr_visibility_create_post(body=data)
        assert(ret.success)
        pass

    def test_config_cdr_visibility_edit_patch(self):
        """
        Test case for config_cdr_visibility_edit_patch

        
        """
        data = {'items':[]}
        for i in range(0,60):
            data['items'].append( {'id':i,
                'client_cdr_delivery': get_rand('bool'),
                'vendor_cdr_delivery': get_rand('bool')
            } )
        ret=self.api.config_cdr_visibility_edit_patch(body=data)
        assert(ret.success)
        data = {'items': []}
        for i in range(0, 60):
            data['items'].append({'id': i,
                                  'client_viewable': get_rand('bool'),
                                  'vendor_viewable': get_rand('bool')
                                  })
        ret = self.api.config_auto_cdr_format_edit_patch(body=data)
        assert (ret.success)
        print(data)

        pass

    def test_config_cdr_visibility_id_delete(self):
        """
        Test case for config_cdr_visibility_id_delete

        
        """
        pass

    def test_config_cdr_visibility_id_get(self):
        """
        Test case for config_cdr_visibility_id_get

        
        """
        ret = self.api.config_cdr_visibility_id_get(id=0)
        assert (ret.success)
        print(ret)
        pass

    def test_config_cdr_visibility_id_patch(self):
        """
        Test case for config_cdr_visibility_id_patch

        
        """
        ret=self.api.config_cdr_visibility_id_patch(id=rand_cdr_visibility()[0],body={'display_name':bla_bla(3)})
        assert(ret.success)
        pass

    def test_config_cdr_visibility_list_get(self):
        """
        Test case for config_cdr_visibility_list_get

        
        """

        ret=self.api.config_cdr_visibility_list_get(order_by='db_name')
        print(ret)
        assert (ret.success)
        pass

    def test_config_country_create_post(self):
        """
        Test case for config_country_create_post


        """
        pass

    def test_config_country_list_get(self):
        """
        Test case for config_country_list_get


        """
        auth()
        ret=self.api.config_country_list_get()
        assert (ret.success)
        print (ret)
        pass

    def test_config_country_time_profile_id_delete(self):
        """
        Test case for config_country_time_profile_id_delete


        """
        pass

    def test_config_country_time_profile_id_get(self):
        """
        Test case for config_country_time_profile_id_get


        """
        pass

    def test_config_country_time_profile_id_patch(self):
        """
        Test case for config_country_time_profile_id_patch


        """
        pass

    def test_config_egress_trunk_template_all_delete(self):
        """
        Test case for config_egress_trunk_template_all_delete


        """
        ret=self.api.config_egress_trunk_template_all_delete()
        assert (ret.success)
        self.test_config_egress_trunk_template_create_post()
        pass

    def test_config_egress_trunk_template_apply_resource_template_id_client_id_post(self):
        """
        Test case for config_egress_trunk_template_apply_resource_template_id_client_id_post

        
        """
        auth()
        lst=cli_dnl.CarrierApi().carrier_simple_list_get(per_page=200)
        cli=random.choice(lst.payload.items)
        tpl = self.api.config_egress_trunk_template_list_get(per_page=50)
        t = random.choice(tpl.payload.items)
        data = {'name':bla(10),
  "media_type": "Proxy Media + Transcoding",
  "cps_limit": get_rand('int'),
  "call_limit": get_rand('int'),
  "ip": [
    {
      "ip": ip(check_dublicates=True),
      "port": 5060
    }
  ],
  "is_active": get_rand('bool')
}
        ret=self.api.config_egress_trunk_template_apply_resource_template_id_client_id_post(client_id=cli.client_id,
                                                                    resource_template_id=t.resource_template_id,
                                                                    body=data)
        assert(ret.success)
        print('POST/config/egress_trunk_template/apply/{}/{}'.format(t.resource_template_id,cli.client_id),json.dumps(data),ret)
        pass

    def test_config_egress_trunk_template_create_post(self):
        """
        Test case for config_egress_trunk_template_create_post

        
        """
        attrs = [(k, t) for k, t in cli_dnl.EgressTrunkTemplateGet.swagger_types.items()
                 if 'list' not in t
                ]
        data = {}
        #for i in range(0, 7):
        #    k, t = random.choice(attrs)
        for k,t in attrs:
            value = get_rand(t)
            data[k]=value
        data['profit_type'] = random.choice(['percentage', 'value'])
        data['route_type'] = random.choice(['other','intra', 'inter','highest'])
        data['us_other'] = random.choice(['other', 'intra', 'inter', 'highest'])
        data['us_route'] = random.choice(['other', 'intra', 'inter', 'highest'])
        data['canada_other'] = random.choice(['other', 'intra', 'inter', 'highest'])
        data['canada_route'] = random.choice(['other', 'intra', 'inter', 'highest'])
        data['intl_route'] = random.choice(['other', 'intra', 'inter', 'highest'])
        data['trunk_type2'] = random.choice(['Termination Traffic', 'DID Traffic'])
        #data['lnp_dipping']= #random.choice(['Add Header', 'Not Add Header'])
        data['rpid_screen'] = random.choice(['None', 'No', 'Yes', 'Proxy'])
        data['rpid_party'] = random.choice(['None', 'Calling', 'Called', 'Proxy'])
        data['rpid_privacy'] = random.choice(['None','Full', 'Name', 'Url','OFF','Ipaddr', 'Proxy'])
        data['rpid_id_type'] = random.choice(['None', 'Subscriber', 'User', 'Term', 'Proxy'])

        data['ring_timeout'] = random.randint(0,60)
        data['profit_margin'] = get_rand('float')
        data['media_type']  = random.choice(['Proxy Media + Transcoding', 'Proxy Media', 'Bypass Media'])
        data['res_strategy']  = random.choice(['top-down', 'round-robin'])
        data['trunk_type'] = random.choice(['class4', 'exchange', 'product_default', 'product_agent'])
        data['rate_table_id'] = rand_rate_table()[0]
        data['rate_rounding'] = random.choice(['Up', 'Down'])
        data['billing_method'] = random.choice(['by minutes','by port'])
        data['t38'] = get_rand('bool')


        ret=self.api.config_egress_trunk_template_create_post(body=data)
        assert(ret.success)

        pass

    def test_config_egress_trunk_template_list_get(self):
        """
        Test case for config_egress_trunk_template_list_get

        
        """

        order = ['resource_template_id', 'create_by','name','create_on', 'update_on', 'used_by']
        o = random.choice(order)
        for o in order:
            lst = self.api.config_egress_trunk_template_list_get(order_by=o, order_dir=random.choice(['asc', 'desc']))
            assert (lst.success)
        lst = self.api.config_egress_trunk_template_list_get(order_dir='desc',page=0,per_page=10)
        assert (lst.success)
        pass

    def test_config_egress_trunk_template_resource_template_id_delete(self):
        """
        Test case for config_egress_trunk_template_resource_template_id_delete

        
        """
        pass

    def test_config_egress_trunk_template_resource_template_id_get(self):
        """
        Test case for config_egress_trunk_template_resource_template_id_get

        
        """
        pass

    def test_config_egress_trunk_template_resource_template_id_patch(self):
        """
        Test case for config_egress_trunk_template_resource_template_id_patch

        
        """
        pass

    def test_config_emails_get(self):
        """
        Test case for config_emails_get


        """
        ret = self.api.config_emails_get()
        assert (ret.success)
        print(ret)
        pass

    def test_config_emails_patch(self):
        """
        Test case for config_emails_patch


        """
        data={
  'system_admin_email': bla_mail(),
  'noc_email': bla_mail(),
  'finance_email': bla_mail(),
  'ftp_email': bla_mail()
}
        ret = self.api.config_emails_patch(body=data)
        assert (ret.success)
        print(ret)
        pass

    def test_config_export_errors_id_get(self):
        """
        Test case for config_export_errors_id_get


        """
        pass

    def test_config_export_id_get(self):
        """
        Test case for config_export_id_get

        
        """
        pass

    def test_config_export_public_id_get(self):
        """
        Test case for config_export_id_get


        """
        auth()
        i=random.randint(1,12)
        ret = self.api.config_import_post(entity='', format='png', file=str(i)+'.png')
        print(ret)
        logoff()
        #ret=self.api.config_export_public_id_get(id=ret.object_id)
        os.system('gwenview '+cli_dnl.configuration.host+'/config/export/public/'+str(ret.object_id))
        #assert(ret.success)
        pass

    def test_config_export_post(self):
        """
        Test case for config_export_post

        
        """
        data = {'entity':'ClientPayment',
                'query':
                    {
                'select':['*'],
                'where':[{'field':'payment_type','op':'in','value':'5,7'},
                         {'field': 'description', 'op': '=', 'value': 'test credit'},
                         {'field': 'client_id', 'op': '=', 'value': '3207'}
                         ],
                #'or_where':[ {'field': 'payment_type', 'op': 'in', 'value': '8,9'} ],
                'format':'csv',
                'header':'yes',
                'header_text':'CLIENT_PAYMENT_ID,CLIENT_ID,CLIENT_NAME,AMOUNT,NOTE,PAID_ON,UPDATE_BY,PAYMENT_TIME,PAYMENT_TYPE_NAME,INVOICE_NUMBER,INVOICE_TOTAL_AMOUNT,INVOICE_PAID_AMOUNT,INVOICE_UNPAID_AMOUNT'
                    }
                }
        print(json.dumps(data))
        ret = self.api.config_export_post(body=data)
        print(ret)
        assert (ret.success)
        pass

    def test_config_export_public_id_get(self):
        """
        Test case for config_export_public_id_get


        """

        pass

    def test_config_failover_global_create_post(self):
        """
        Test case for config_failover_global_create_post

        
        """
        data=dict(match_code=999,return_code=999,return_clause="Unknown result",failover_method="Stop")
        ret = self.api.config_failover_global_create_post(body=data)
        assert(ret.success)
        ret1 = self.api.config_failover_termination_id_get(id=999)
        assert (ret1.success)
        print(ret1)
        ret2 = self.api.config_failover_origination_id_get(id=999)
        assert (ret2.success)
        print(ret2)
        pass

    def test_config_failover_global_id_delete(self):
        """
        Test case for config_failover_global_id_delete

        
        """
        ret=self.api.config_failover_global_id_delete(id=999)
        assert(ret.success)
        pass

    def test_config_failover_global_id_get(self):
        """
        Test case for config_failover_global_id_get

        
        """
        pass

    def test_config_failover_global_id_patch(self):
        """
        Test case for config_failover_global_id_patch

        
        """
        data = dict(return_code=998, return_clause="Unknown result1", failover_method="Fail to Next Host")
        ret = self.api.config_failover_global_id_patch(id=999, body=data)
        assert (ret.success)
        print(ret)
        pass

    def test_config_failover_global_list_get(self):
        """
        Test case for config_failover_global_list_get

        
        """
        pass

    def test_config_failover_global_patch(self):
        """
        Test case for config_failover_global_patch

        
        """

        pass

    def test_config_failover_origination_id_get(self):
        """
        Test case for config_failover_origination_id_get

        
        """

        pass

    def test_config_failover_origination_id_patch(self):
        """
        Test case for config_failover_origination_id_patch

        
        """
        pass

    def test_config_failover_origination_list_get(self):
        """
        Test case for config_failover_origination_list_get

        
        """
        pass

    def test_config_failover_origination_patch(self):
        """
        Test case for config_failover_origination_patch

        
        """
        lst=self.api.config_failover_origination_list_get(per_page=60).payload.items
        upd=[dict(id=it.id,return_code=random.randint(100,999),return_clause=bla(6),failover_method=
                  random.choice(['Stop','Fail to Next Trunk','Fail to Next Host'])) for it in lst]

        print ('PATCH/config/failover/origination -d',json.dumps({'items':upd}))
        ret = self.api.config_failover_origination_patch(body={'items':upd})
        assert (ret.success)

        print(json.dumps(ret.to_dict()))


        upd = [dict(id=it.id, return_code=it.defaults.return_code,
                    return_clause=it.defaults.return_clause,
                    failover_method=it.defaults.failover_method) for it in lst]
        #print(upd)
        ret = self.api.config_failover_origination_patch(body={'items': upd})
        assert (ret.success)
        #print(ret)

        pass

    def test_config_failover_termination_id_get(self):
        """
        Test case for config_failover_termination_id_get

        
        """
        ret1 = self.api.config_failover_termination_id_get(id=999)
        assert (ret1.success)
        print(ret1)
        pass

    def test_config_failover_termination_id_patch(self):
        """
        Test case for config_failover_termination_id_patch

        
        """
        pass

    def test_config_failover_termination_list_get(self):
        """
        Test case for config_failover_termination_list_get

        
        """
        pass

    def test_config_failover_termination_patch(self):
        """
        Test case for config_failover_termination_patch

        
        """
        pass

    def test_config_ftp_all_delete(self):
        """
        Test case for config_ftp_all_delete


        """
        pass

    def test_config_ftp_all_patch(self):
        """
        Test case for config_ftp_all_patch


        """
        pass

    def test_config_ftp_create_post(self):
        """
        Test case for config_ftp_create_post

        
        """
        data = {
  'ftp_username': bla(5),
  'include_fields': [bla(5),bla(5),bla(5)],
  'time': '24:00',
  'egress_trunks': [rand_trunk(direction='egress')[0],rand_trunk(direction='egress')[0] ],
  'ingress_trunks': [rand_trunk(direction='ingress')[0],rand_trunk(direction='ingress')[0]],
  'frequency': random.choice([ 'daily', 'weekly', 'hourly', 'minutely' ]),
  'max_line_per_file': random.randint(1,1024),
  'ftp_password': bla(8),
  'orig_return_code': [  random.randint(1,1024),random.randint(1,1024),random.randint(1,1024)  ],
  'include_header': get_rand('bool'),
  'file_breakdown': random.choice([ 'as one big file', 'as hourly file', 'as daily file' ]),
  'active': get_rand('bool'),
  'compression': random.choice([ 'gz', 'tar.gz', 'tar.bz2','zip','zip' ]),
  'ftp_server_port': str(random.randint(1000,65535)),
  'include_all_egress': get_rand('bool'),
  'include_all_ingress': get_rand('bool'),
  'name': 'ftp_'+bla(8).lower()+dig(5),
  'non_zero': get_rand('bool'),
  'term_return_code': [  random.randint(1,1024),random.randint(1,1024),random.randint(1,1024)  ],
  'ftp_server_ip': ip(check_dublicates=False),
  'ftp_directory':'/'+bla(5).lower()+'/'+bla(5).lower()+'/'+bla(5).lower()
        }
        ret=self.api.config_ftp_create_post(body=data)
        assert(ret.success)
        return ret
        pass

    def test_config_ftp_id_delete(self):
        """
        Test case for config_ftp_id_delete

        
        """
        r=self.test_config_ftp_create_post()
        ret=self.api.config_ftp_id_delete(id=r.object_id)
        assert (ret.success)
        pass

    def test_config_ftp_id_get(self):
        """
        Test case for config_ftp_id_get

        
        """
        ret = self.api.config_ftp_id_get(id=rand_ftp()[0])
        assert (ret.success)
        pass

    def test_config_ftp_id_patch(self):
        """
        Test case for config_ftp_id_patch

        
        """
        pass

    def test_config_ftp_id_test_patch(self):
        """
        Test case for config_ftp_id_test_patch


        """
        lst = self.api.config_ftp_list_get()
        assert (lst.success)
        items=lst.payload.items
        random.shuffle(items)
        try:
            ret=self.api.config_ftp_id_test_patch(id=items[0].id)
            assert(ret.success)
            print('connected',ret)
        except Exception as e:
            print('Not connected')
            assert('timeout' in str(e) or 'unreachable' in str(e))

        pass

    def test_config_ftp_list_get(self):
        """
        Test case for config_ftp_list_get


        """
        order = ['active','name','time','ftp_server_ip','time']
        for o in order:
            lst = self.api.config_ftp_list_get(order_by=o, order_dir=random.choice(['asc', 'desc']))
            assert (lst.success)

        pass

    def test_config_import_id_kill_post(self):
        """
        Test case for config_import_id_kill_post


        """
        pass

    def test_config_import_id_run_post(self):
        """
        Test case for config_import_id_run_post


        """
        pass
    def test_config_import_post_blocks(self):
        """
        Test case for config_import_post


        """
        auth()
        file='ani2.csv'
        ret = self.api.config_import_post(entity='ResourceBlock', format='csv', file=file,
                                          ignore_fields='block_type,ingress_trunk_id',
                                          replace_fields='block_type,ingress_trunk_id',
                                          replace_values='specific trunk,1696')
        print(ret)
        assert (ret.success)

    def test_config_import_post_rate(self):
        """
        Test case for config_import_post


        """
        auth()
        file='Rate.csv'
        file = 'ICX US dialer-TGC Prefix 99081 EFF ON 2017-12-05.csv'
        ret = self.api.config_import_post(entity='Rate', format='csv', file=file,
                                          ignore_fields='rate_id', replace_fields='rate_table_id', replace_values='1306')
        print(ret)
        assert (ret.success)
        try:
            err=self.api.config_export_errors_id_get(id=ret.object_id)
            assert (not err.success)
        except Exception as e:
            assert ('FileNotFoundError' in str(e))
        pass

    def test_config_import_post_code(self):
        """
        Test case for config_import_post


        """
        auth()
        file='Code.json'
        ret = self.api.config_import_post(entity='Code', format='json',
                                          file=file,delete_dublicates=True)
        print(ret)
        assert (ret.success)
        try:
            err=self.api.config_export_errors_id_get(id=ret.object_id)
            assert (not err.success)
        except Exception as e:
            assert ('FileNotFoundError' in str(e))
        pass
    def test_config_import_post(self):
        """
        Test case for config_import_post

        
        """
        auth()
        ret = self.api.config_import_post(entity='Rate', format='csv', file='api_dnl/test/data/rate.csv')
        print(ret)
        assert (ret.success)

        return
        #ret = self.api.config_import_post(entity='EgressTrunk', format='xml', file='EgressTrunk.xml',
        #                                         ignore_fields='trunk_id')
        #print(ret)
        #assert (ret.success)

        ret = self.api.config_import_post(entity='CarrierTemplate', format='xml', file='CarrierTemplate.xml',
                                          ignore_fields='res_block_id')
        print(ret)
        assert (ret.success)

        ret = self.api.config_import_post(entity='ResourceBlock', format='json', file='ResourceBlock1.json',
                                          ignore_fields='res_block_id')
        print(ret)
        assert (ret.success)


        ret = self.api.config_import_post(entity='JurisdictionPrefix', format='json', file='JurisdictionPrefix.json',
                                          ignore_fields='id', delete_dublicates=True)
        print(ret)
        assert (ret.success)




        ret = self.api.config_import_post(entity='ResourceBlock', format='csv', file='ResourceBlock.csv')
        print(ret)
        assert (ret.success)

        ret=self.api.config_import_post(entity='Rate',format='csv',file='Rate.csv')
        print(ret)
        assert(ret.success)


        try:
            err=self.api.config_export_errors_id_get(id=ret.object_id)
            assert (not err.success)
        except Exception as e:
            assert ('FileNotFoundError' in str(e))
        #print(err)
        ret = self.api.config_import_post(entity='JurisdictionPrefix', format='csv', file='JurisdictionPrefix.csv')
        print(ret)



        assert (ret.success)
        pass

    def test_config_ingress_trunk_template_all_delete(self):
        """
        Test case for config_ingress_trunk_template_all_delete


        """
        pass

    def test_config_ingress_trunk_template_apply_resource_template_id_client_id_post(self):
        """
        Test case for config_ingress_trunk_template_apply_resource_template_id_client_id_post

        
        """
        auth()
        lst=cli_dnl.CarrierApi().carrier_simple_list_get(per_page=200)
        cli=random.choice(lst.payload.items)
        tpl = self.api.config_ingress_trunk_template_list_get(per_page=50)
        t = random.choice(tpl.payload.items)
        data = {'name':bla(10)}
        ret=self.api.config_ingress_trunk_template_apply_resource_template_id_client_id_post(client_id=cli.client_id,
                                                                    resource_template_id=t.resource_template_id,
                                                                    body=data)
        assert(ret.success)
        print(ret)
        pass

    def test_config_ingress_trunk_template_create_post(self):
        """
        Test case for config_ingress_trunk_template_create_post

        
        """
        attrs = [(k, t) for k, t in cli_dnl.IngressTrunkTemplateGet.swagger_types.items()
                 if 'list' not in t
                 ]
        data = {}
        # for i in range(0, 7):
        #    k, t = random.choice(attrs)
        for k, t in attrs:
            value = get_rand(t)
            data[k] = value
        data['profit_type'] = random.choice(['percentage', 'value'])
        data['route_type'] = random.choice(['other', 'intra', 'inter', 'highest'])
        data['us_other'] = random.choice(['other', 'intra', 'inter', 'highest'])
        data['us_route'] = random.choice(['other', 'intra', 'inter', 'highest'])
        data['canada_other'] = random.choice(['other', 'intra', 'inter', 'highest'])
        data['canada_route'] = random.choice(['other', 'intra', 'inter', 'highest'])
        data['intl_route'] = random.choice(['other', 'intra', 'inter', 'highest'])
        # data['lnp_dipping']= #random.choice(['Add Header', 'Not Add Header'])
        data['rpid_screen'] = random.choice(['None', 'No', 'Yes', 'Proxy'])
        data['rpid_party'] = random.choice(['None', 'Calling', 'Called', 'Proxy'])
        data['rpid_privacy'] = random.choice(['None', 'Full', 'Name', 'Url', 'OFF', 'Ipaddr', 'Proxy'])
        data['rpid_id_type'] = random.choice(['None', 'Subscriber', 'User', 'Term', 'Proxy'])
        data['trunk_type2'] = random.choice(['Termination Traffic', 'DID Traffic'])
        data['ring_timeout'] = get_rand('int')
        data['profit_margin'] = get_rand('float')
        data['media_type'] = random.choice(['Proxy Media + Transcoding', 'Proxy Media', 'Bypass Media'])
        data['res_strategy'] = random.choice(['top-down', 'round-robin'])
        data['trunk_type'] = random.choice(['class4', 'exchange', 'product_default', 'product_agent'])
        data['rate_table_id'] = rand_rate_table()[0]
        data['rate_rounding'] = random.choice(['Up', 'Down'])


        ret = self.api.config_ingress_trunk_template_create_post(body=data)
        assert (ret.success)
        pass

    def test_config_ingress_trunk_template_list_get(self):
        """
        Test case for config_ingress_trunk_template_list_get

        
        """
        order = ['resource_template_id', 'create_by', 'name', 'create_on', 'update_on', 'used_by']
        o = random.choice(order)
        for o in order:
            lst = self.api.config_ingress_trunk_template_list_get(order_by=o, order_dir=random.choice(['asc', 'desc']))
            assert (lst.success)
        pass

    def test_config_ingress_trunk_template_resource_template_id_delete(self):
        """
        Test case for config_ingress_trunk_template_resource_template_id_delete

        
        """
        pass

    def test_config_ingress_trunk_template_resource_template_id_get(self):
        """
        Test case for config_ingress_trunk_template_resource_template_id_get

        
        """
        pass

    def test_config_ingress_trunk_template_resource_template_id_patch(self):
        """
        Test case for config_ingress_trunk_template_resource_template_id_patch

        
        """
        auth()
        
        pass

    def test_config_invoice_get(self):
        """
        Test case for config_invoice_get

        
        """
        pass

    def test_config_invoice_patch(self):
        """
        Test case for config_invoice_patch

        
        """

        ret = self.api.config_invoice_patch(body={'invoice_number_format':'1','cdr_fields':['ingress_call_cost']})
        assert (ret.success)
        pass

    def test_config_login_get(self):
        """
        Test case for config_login_get

        
        """
        ret=self.api.config_login_get()
        assert(ret.success)

        pass

    def test_config_login_patch(self):
        """
        Test case for config_login_patch

        
        """
        data={'image_url':'http://'+bla(6)+'/'+bla(8)+'.png',
            'fit_to_screen':get_rand('bool'),
            'use_captcha':get_rand('bool'),
            'content':lorem_ipsum(),
            'default_avatar_id':rand_import(obj='png')[0],
            'base_url': 'http://' + bla(6) + ':8080/' + bla(8) + '/',
        }
        ret = self.api.config_login_patch(body=data)
        assert (ret.success)
        pass


    def test_config_login_public_get(self):
        """
        Test case for config_login_public_get


        """
        logoff()
        ret = self.api.config_login_public_get()
        assert (ret.success)
        pass

    def test_config_lrn_get(self):
        """
        Test case for config_lrn_get


        """
        ret = self.api.config_lrn_get()
        assert (ret.success)
        print(ret)
        pass

    def test_config_lrn_patch(self):
        """
        Test case for config_lrn_patch


        """
        data = {
  'srv2_ip': ip(check_dublicates=False),
  'srv1_port': random.randint(1000,65535),
  'srv1_ip': ip(check_dublicates=False),
  'srv2_port': random.randint(1000,65535)
}
        ret = self.api.config_lrn_patch(body=data)
        assert (ret.success)
        print(ret)
        pass



    def test_config_mail_sender_all_delete(self):
        """
        Test case for config_mail_sender_all_delete


        """
        pass

    def test_config_mail_sender_create_post(self):
        """
        Test case for config_mail_sender_create_post

        
        """
        data = {
  'mail_port': '465',
  'secure': 'NO',
  'mail_server': 'mail.denovolab.com',
  'name': 'email_sender_'+bla(5),
  'username': '_testuser@denovolab.com',
  'email': 'testuser@denovolab.com',
  'password': 'LBVUSs5W9R6KRpFk',
  'enable_auth': True
  }
        auth()
        ret=self.api.config_mail_sender_create_post(body=data)
        assert(ret.success)
        data['username']=data['username']+bla(4)
        try:
            ret = self.api.config_mail_sender_create_post(body=data)
            assert (not ret.success)
        except Exception as e:
            assert('already' in str(e))
        ret = self.api.config_mail_sender_id_delete(id=ret.object_id)
        assert (ret.success)


        pass

    def test_config_mail_sender_id_delete(self):
        """
        Test case for config_mail_sender_id_delete

        
        """
        pass

    def test_config_mail_sender_id_get(self):
        """
        Test case for config_mail_sender_id_get

        
        """
        r=self.api.config_mail_sender_id_get(id=1)
        assert (r.success)
        pass

    def test_config_mail_sender_id_patch(self):
        """
        Test case for config_mail_sender_id_patch

        
        """
        pass

    def test_config_mail_sender_id_test_patch(self):
        """
        Test case for config_mail_sender_id_test_patch

        
        """
        data = {
            'mail_port': '465',
            'secure': 'NO',
            'mail_server': 'smtp.gmail.com',
            'name': bla(5),
            'username': 'mizdesino@gmail.com',
            'email': 'mizdesino@gmail.com',
            'password': 'jkjvbtdslkkahbpa',
            'enable_auth': True
        }
        auth()
        ret = self.api.config_mail_sender_list_get(username='mizdesino')
        if len(ret.payload.items):
            id=ret.payload.items[0].id
        else:

            ret = self.api.config_mail_sender_create_post(body=data)
            id=ret.object_id
        mdata={'test_content': 'Hello ' + bla_comp()+'! '+bla_bla(10), 'mail_to': '_novvv@mail.ru',
            'test_subject': 'This is test letter '+bla(10)}

        test = self.api.config_mail_sender_id_test_patch(id=id, body=mdata)

        data['username']= 'mizdesino'+bla(8)
        ret = self.api.config_mail_sender_create_post(body=data)
        id = ret.object_id

        try:
            test = self.api.config_mail_sender_id_test_patch(id=ret.object_id, body=mdata)
            assert (not test.success)
        except Exception as e:
            assert ('Password not accepted' in str(e))

        ret2 = self.api.config_mail_sender_id_delete(id=id)
        assert (ret2.success)

        pass

    def test_config_mail_sender_list_get(self):
        """
        Test case for config_mail_sender_list_get

        
        """
        for order in ['id', 'email', 'mail_server', 'secure', 'name', 'username',
        'update_by','update_on']:
            for dir in ['asc','desc']:
                ret=self.api.config_mail_sender_list_get(order_by=order,order_dir=dir)
                assert(ret.success)

        pass

    def test_config_mail_template_list_get(self):
        """
        Test case for config_mail_template_list_get


        """
        ret=self.api.config_mail_template_list_get()
        assert(ret.success)
        pass

    def test_config_mail_template_title_get(self):
        """
        Test case for config_mail_template_title_get

        
        """
        ret = self.api.config_mail_template_title_get(title='welcom')
        assert (ret.success)
        pass

    def test_config_mail_template_title_patch_zerobalance(self):
        """
        Test case for config_mail_template_title_patch


        """
        return
        data= {}
        data['subject'] = 'Letter template ZEROBALANCE'
        data['html_content'] = """<p><strong>{client_name}&nbsp;Zero Balance</strong></p>
         \r                                                                                                    
         <p>Hello {client_name},{company} <br />\r                                                                      
         This is a notification that you have reached zero balance threshold<br />\r                       
         As per our contractual agreement, terms are {payment_terms}.</p>\r                                    
         \r                                                                                                    
         <p>Your Credit limit is $&nbsp;{credit_limit}<br />\r                                                 
         Your current running balance is at ${balance}.</p>\r                                                  
         \r                                                                                                    
         <p>We recommend that you make payment as soon as possible to avoid any interruptions in service.</p>\r
         \r                                                                                                    
         <p><br />\r                                                                                           
         <br />\r                                                                                              
         <em><strong>We Thank You for your Business</strong></em></p>\r
         <p><b>{company_name}</b></p>                                        
         \r                                                                                                    
         <p>&nbsp;</p>\r"""
        data['cc_mail'] = '_novvv@mail.ru'
        #data['to_mail'] = None
        ret = self.api.config_mail_template_title_patch(title='zerobalance', body=data)
        assert (ret.success)

    def test_config_mail_template_title_patch(self):
        """
        Test case for config_mail_template_title_patch

        
        """
        return
        auth()
        data = {'title': 'alert_email',
                'html_content':"""
        <thead>Monitoring results:</thead>
        {monitoring_result}
        <p>Code:{code}</p>
        <p>Rule:{rule_name}</p>
        <thead>Limit table:</thead>
        {limit_table}
        <thead>Rule setup:</thead>
        {rule_setup}
        <p>Block: {block_list}</p>
        <p>total_calls{total_calls}</p>
        <p>Start:{sample_start_time}  End:{sample_end_time}</p>""",
                'subject':'AlertRule {rule_name} {sample_start_time} {sample_end_time} ',
                'sender_id':1,
                'cc_mail': '_novvv@mail.ru'
                #'to_mail': 'noc_email'
                }
        ret = self.api.config_mail_template_title_patch(title='alert_email', body=data)
        assert (ret.success)
        data={'title': 'welcom',
    'html_content': '<div style=\'background-color:#f7f9fa; height:auto; padding-bottom:4\n'
    '0px; width:1024px\'>\n<div style=\'height:40px\'>Peter&nbsp;{company_name}</div>\n'
    '\n<div style=\'background-color:#ffffff; width:600px\'>\n'
    '<div style=\'background-color:#51a351; ght:80px; width:600px\'>\n'
    '<div style=\'height:10px\'>&nbsp;</div>\n\n'
    '<h2 style=\'text-align:center\'>'
    '<span style=\'color:#ffffff\'><span style=\'font-size:22px\'><strong>Welcome to {company_name}</strong></span></span></h2>\n'
    '</div>\n\n<div>&nbsp;</div>\n\n<div><span style=\'font-size:16px\'><strong>Dear </strong></span>'
    '{client_name}<span style=\'font-size:16px\'><strong></strong></span>:</div>\n\n'
    '<div style=\'height:15\npx\'>&nbsp;</div>\n\n<div><span style=\'font-size:16px\'>'
    'Thank you for signing up with {company_name}.&nbsp;</span></div>\n\n<div>{client_name}</div>\n\n'
    '<div>{login_url}</div>\n\n<div>&nbsp;</div>\n\n<div><span style=\'font-size:16p\n'
    'x\'>Your account is now approved and you can now login to the portal and configure your account.&nbsp;'
    '</span></div>\n\n<div style=\'height:60px\'>&nbsp;</div>\n</div>\n\n<div style=\'width:200px\'>\n'
    '<a href=\'{login_url}\' style=\'display:block; background: green; color: white; padding: 20px 10px; '
    'text-align: center; text-decoration:none; font-weight: bold; font-s\nize: 20px\'>Login Now</a></div>\n\n'
    '<div style=\'margin-bottom:30px; margin-left:30px; margin-right:30px; margin-top:30px\'>\n'
    '<div style=\'height:60px\'>&nbsp;</div>\n\n'
    '<div style=\'font-size:16px\'>&nbsp;{company_name}{client_name}{username}{login_url}</div>\n'
    '</div>\n</div>\n<!--\ndiv-->',
    'subject': 'Letter template WELCOM',
    'from_mail_id': 1}
        ret=self.api.config_mail_template_title_patch(title='welcom',body=data)
        assert(ret.success)
        data['subject']='Letter template PAYMENT'
        data['html_content']='Hello {client_name}.Your payment id:{client_payment_id} was reviewd. Note is:{note} '
        data['cc_mail'] = 'billing_email'
        data['to_mail'] = 'email'
        ret = self.api.config_mail_template_title_patch(title='payment', body=data)
        assert (ret.success)

        data['subject'] = 'Letter template LOWBALANCE'
        data['html_content'] ="""<p><strong>{client_name}&nbsp;Insufficient Balance</strong></p>
 \r                                                                                                    
 <p>Hello {client_name},{company} <br />\r                                                                      
 This is a notification that you have reached your low balance threshold<br />\r                       
 As per our contractual agreement, terms are {payment_terms}.</p>\r                                    
 \r                                                                                                    
 <p>Your Credit limit is $&nbsp;{credit_limit}<br />\r                                                 
 Your current running balance is at ${balance}.</p>\r                                                  
 \r                                                                                                    
 <p>We recommend that you make payment as soon as possible to avoid any interruptions in service.</p>\r
 \r                                                                                                    
 <p><br />\r                                                                                           
 <br />\r                                                                                              
 <em><strong>We Thank You for your Business</strong></em></p>\r
 <p><b>{company_name}</b></p>                                        
 \r                                                                                                    
 <p>&nbsp;</p>\r"""
        data['cc_mail']='test@example.com'
        ret = self.api.config_mail_template_title_patch(title='lowbalance', body=data)

        data['subject'] = 'FRAUD DETECTION {client.name}'
        data['html_content'] = 'Hello {client.name}.Your trunk "{trunk_name}" was over limit. <br>' \
                               'Rule name is:{rule_name} <br>' \
                               'Rule type is:{rule_type} <br>' \
                               'limit is:{limit_value} <br>' \
                               'you are reached: {block_value} <br>'

        data['cc_mail'] = '_novvv@mail.ru'
        data['to_mail'] = 'noc_email'
        ret = self.api.config_mail_template_title_patch(title='fraud_detection', body=data)
        assert (ret.success)


        assert (ret.success)
        pass

    def test_config_payment_get(self):
        """
        Test case for config_payment_get

        
        """
        pass

    def test_config_payment_patch(self):
        """
        Test case for config_payment_patch

        
        """
        pass

    def test_config_payment_term_all_delete(self):
        """
        Test case for config_payment_term_all_delete


        """
        pass

    def test_config_payment_term_create_post(self):
        """
        Test case for config_payment_term_create_post

        
        """
        data = {
  'days': [ 1,2,3,11,12  ],
  'grace_period': random.randint(0,7),
  'name': 'payment_term_'+bla(6),
  'type': random.choice(['Day of Month', 'Every', 'Day of Week', 'Some day of month', 'Twice a month']),
  'notify_days': random.randint(0,7)
}
        ret=self.api.config_payment_term_create_post(body=data)
        assert(ret.success)
        return ret
        pass

    def test_config_payment_term_list_get(self):
        """
        Test case for config_payment_term_list_get

        
        """
        ret=self.api.config_payment_term_list_get(notify_days=5)
        assert(ret.success)
        print(ret)
        o = ['payment_term_id','name','type_name','grace_period','usage_count']
        for ord in o:
            for dir in ['asc', 'desc']:
                ret = self.api.config_payment_term_list_get(order_by=ord, order_dir=dir)
                assert (ret.success)
                print(ord,dir,'success')
        pass

    def test_config_payment_term_payment_term_id_delete(self):
        """
        Test case for config_payment_term_payment_term_id_delete

        
        """
        ret=self.test_config_payment_term_create_post()
        ret1=self.api.config_payment_term_payment_term_id_delete(payment_term_id=ret.object_id)
        assert(ret1.success)
        pass

    def test_config_payment_term_payment_term_id_get(self):
        """
        Test case for config_payment_term_payment_term_id_get

        
        """
        ret1 = self.api.config_payment_term_payment_term_id_delete(payment_term_id=rand_payment_term()[0])
        assert (ret1.success)
        pass

    def test_config_payment_term_payment_term_id_patch(self):
        """
        Test case for config_payment_term_payment_term_id_patch

        
        """
        data = {
    'days': [ 3,4,5  ],
    'grace_period': random.randint(0,7),
    'name': 'payment_term_'+bla(6),
    'type': random.choice(['Day of Month', 'Every', 'Day of Week', 'Some day of month', 'Twice a month']),
    'notify_days': random.randint(0,7)
    }
        ret1 = self.api.config_payment_term_payment_term_id_patch(payment_term_id=rand_payment_term()[0],body=data)
        assert (ret1.success)
        pass

    def test_config_qos_get(self):
        """
        Test case for config_qos_get


        """
        pass

    def test_config_qos_patch(self):
        """
        Test case for config_qos_patch


        """
        data ={'qos_sample_period':random.choice(['15 min', '1 hour', '1 day']),
               'low_call_attempt_handling':random.choice(['none', 'use latest value']),
               'minimal_call_attempt_required':random.randint(0,10000)
               }
        ret=self.api.config_qos_patch(body=data)
        assert (ret.success)
        print(ret)
        pass

    def test_config_role_create_post(self):
        """
        Test case for config_role_create_post

        
        """
        data={
            'role_privilegies':[],
            'role_name':'role_'+bla(7)
        }
        funcs=rand_system_function(per_page=200)[2]
        random.shuffle(funcs)

        for f in funcs[0:5]:
            data['role_privilegies'].append(
                {'executable': get_rand('bool'),
                'writable': get_rand('bool'),
                'readable': get_rand('bool'),
                'system_function_id': f.system_function_id}
            )

        ret=self.api.config_role_create_post(body=data)
        assert(ret.success)
        print(ret)
        return ret
        pass

    def test_config_role_list_get(self):
        """
        Test case for config_role_list_get

        
        """
        ret=self.api.config_role_list_get()
        assert(ret.success)
        pass

    def test_config_role_privilege_role_privilege_id_delete(self):
        """
        Test case for config_role_privilege_role_privilege_id_delete

        
        """
        pass

    def test_config_role_privilege_role_privilege_id_get(self):
        """
        Test case for config_role_privilege_role_privilege_id_get

        
        """
        pass

    def test_config_role_privilege_role_privilege_id_patch(self):
        """
        Test case for config_role_privilege_role_privilege_id_patch

        
        """
        pass

    def test_config_role_role_id_defaults_patch(self):
        """
        Test case for config_role_role_id_defaults_patch

        
        """
        pass

    def test_config_role_role_id_delete(self):
        """
        Test case for config_role_role_id_delete

        
        """
        ret=self.test_config_role_create_post()
        id=1
        while id==1:
            id=rand_user()[0]
        r=cli_dnl.AuthApi().user_user_id_patch(user_id=id,body={'role_id':ret.object_id})
        print(r)
        assert (r.success)
        ret1=self.api.config_role_role_id_delete(role_id=ret.object_id)
        assert(ret1.success)
        pass

    def test_config_role_role_id_get(self):
        """
        Test case for config_role_role_id_get

        
        """
        ret1 = self.api.config_role_role_id_delete(role_id=rand_role()[0])
        assert (ret1.success)

        pass

    def test_config_role_role_id_patch(self):
        """
        Test case for config_role_role_id_patch

        
        """
        data = {
            'role_privilegies': [],
            'role_name': 'role_' + bla(7)
        }
        funcs = rand_system_function(per_page=200)[2]
        random.shuffle(funcs)

        for f in funcs[0:5]:
            data['role_privilegies'].append(
                {
                 'writable': get_rand('bool'),
                 'readable': get_rand('bool'),
                 'func_url': f.func_url}
            )
        ret1 = self.api.config_role_role_id_patch(role_id=rand_role()[0],body=data)
        assert (ret1.success)
        pass

    def test_config_role_role_id_privilege_list_get(self):
        """
        Test case for config_role_role_id_privilege_list_get

        
        """
        pass

    def test_config_role_role_id_privileges_get(self):
        """
        Test case for config_role_role_id_privileges_get

        
        """
        ret1 = self.api.config_role_role_id_privileges_get(role_id=rand_role()[0])
        assert (ret1.success)
        pass

    def test_config_role_role_id_system_function_id_privilege_post(self):
        """
        Test case for config_role_role_id_system_function_id_privilege_post

        
        """
        pass

    def test_config_route_error_id_get(self):
        """
        Test case for config_route_error_id_get

        
        """
        ret = self.api.config_route_error_id_get(id=7)
        print(ret)
        pass

    def test_config_route_error_id_patch(self):
        """
        Test case for config_route_error_id_patch

        
        """
        data = dict(to_sip_code=404,to_sip_string='Not found')
        ret=self.api.config_route_error_id_patch(id=7,body=data)
        print(ret)
        data = dict(to_sip_code=503, to_sip_string='Service Unavailable')
        ret = self.api.config_route_error_id_patch(id=7,body=data)
        print(ret)
        pass

    def test_config_route_error_list_get(self):
        """
        Test case for config_route_error_list_get

        
        """
        ret=self.api.config_route_error_list_get()
        assert(ret)
        print (ret)

        pass

    def test_config_route_error_patch(self):
        """
        Test case for config_route_error_patch


        """

        lst=self.api.config_route_error_list_get(per_page=60).payload.items
        print(lst)
        """
        """
        upd=[dict(id=it.id,to_sip_code=random.randint(100,999),to_sip_string=bla(6)) for it in lst]

        print ('PATCH/config/route/error -d',json.dumps({'items':upd}))
        ret = self.api.config_route_error_patch(body={'items':upd})
        assert (ret.success)



        upd = [dict(id=it.id, to_sip_code=it.default_to_sip_code, to_sip_string=it.default_to_sip_string) for it in lst]
        print('PATCH/config/route/error -d', json.dumps({'items': upd}))
        ret = self.api.config_route_error_patch(body={'items': upd})
        assert (ret.success)
        pass

    def test_config_send_rate_template_all_delete(self):
        """
        Test case for config_send_rate_template_all_delete


        """
        ret=self.api.config_send_rate_template_all_delete()
        assert(ret.success)
        pass

    def test_config_send_rate_template_create_post(self):
        """
        Test case for config_send_rate_template_create_post


        """
        CONTENT="""<p>Hi {name}</p> <p> This is the template of type "send_rate_template" from dnl_api.<p><b>name:</b>{name}</p>
        <p><b>company_name:</b>{company_name}</p><p><b>login_url:</b>{login_url}</p><p><b>balance:</b>{balance}</p>
        <p><b>credit_limit:</b>{credit_limit}</p><p><b>create_time:</b>{create_time}</p><p><b>company:</b>{company}</p>
        <p><b>email:</b>{email}</p><p><b>payment_terms:</b>{payment_terms}</p><p><b>client.name:</b>{client.name}</p>
        <p><b>download_link:</b>{download_link}</p>
        """

        H0 = ['code', 'rate', 'effective_date',]
        HEADERS = ['rate_id', 'rate_table_id',  'setup_fee','end_date', 'min_time',
                   'grace_time', 'interval', 'time_profile_id', 'seconds', 'code_name', 'basic_percentages',
                   'gift_percentages',
                   'rate_type', 'intra_rate', 'inter_rate', 'local_rate', 'country', 'zone', 'ocn', 'lata',
                   'create_time', 'did_type']
        h=H0
        random.shuffle(HEADERS)
        for i in HEADERS[0:5]:
           h.append(i)
        data = {
  'content': CONTENT+lorem_ipsum(),
  'download_method': random.choice(['send as link','send as attachment']),
  'headers': h,
  'name': 'send_rate_template_'+bla(8),
  'mail_cc': '_novvv@mail.ru',#bla_mail(),
  'to_mail': 'billing_email',
  'subject': bla_bla(4),
  'sender_id': 1#rand_mail_sender()[0]
}
        ret=self.api.config_send_rate_template_create_post(body=data)
        assert(ret.success)
        return ret
        pass

    def test_config_send_rate_template_id_delete(self):
        """
        Test case for config_send_rate_template_id_delete


        """
        ret=self.test_config_send_rate_template_create_post()
        ret1 = self.api.config_send_rate_template_id_delete(id=ret.object_id)
        assert (ret1.success)

        pass

    def test_config_send_rate_template_id_get(self):
        """
        Test case for config_send_rate_template_id_get


        """
        ret = self.api.config_send_rate_template_id_get(id=rand_send_rate_template()[0])
        assert (ret.success)
        try:
            ret = self.api.config_send_rate_template_id_get(id=1)
            assert (not ret.success)
        except Exception as e:
            assert('not_found_error' in str(e))

        pass

    def test_config_send_rate_template_id_patch(self):
        """
        Test case for config_send_rate_template_id_patch


        """
        H0 = ['code', 'rate', 'effective_date', ]
        HEADERS = ['rate_id', 'rate_table_id', 'setup_fee', 'end_date', 'min_time',
                   'grace_time', 'interval', 'time_profile_id', 'seconds', 'code_name', 'basic_percentages',
                   'gift_percentages',
                   'rate_type', 'intra_rate', 'inter_rate', 'local_rate', 'country', 'zone', 'ocn', 'lata',
                   'create_time', 'did_type']
        h = H0
        random.shuffle(HEADERS)
        for i in HEADERS[0:5]:
            h.append(i)
        data = {
            'content': lorem_ipsum(),
            'download_method': random.choice(['send as link', 'send as attachment']),
            'headers': h,
            'name': 'send_rate_template_' + bla(8),
            'mail_cc': bla_mail(),
            'subject': bla_bla(4),
            'sender_id': rand_mail_sender()[0]
        }
        ret = self.api.config_send_rate_template_id_patch(id=rand_send_rate_template()[0],body=data)
        assert (ret.success and data['subject']==ret.payload.subject)
        pass

    def test_config_send_rate_template_list_get(self):
        """
        Test case for config_send_rate_template_list_get


        """
        ret=self.api.config_send_rate_template_list_get()
        assert (ret.success and len(ret.payload.items)>0)
        pass


    def test_config_system_function_list_get(self):
        """
        Test case for config_system_function_list_get

        
        """
        ret = self.api.config_system_function_list_get()
        assert (ret.success)
        pass

    def test_config_system_function_system_function_id_delete(self):
        """
        Test case for config_system_function_system_function_id_delete

        
        """
        pass

    def test_config_system_function_system_function_id_get(self):
        """
        Test case for config_system_function_system_function_id_get

        
        """
        pass

    def test_config_system_function_system_function_id_patch(self):
        """
        Test case for config_system_function_system_function_id_patch

        
        """
        pass

    def test_config_system_function_system_function_id_post(self):
        """
        Test case for config_system_function_system_function_id_post

        
        """
        pass

    def test_config_system_get(self):
        """
        Test case for config_system_get

        
        """
        auth_random_a()
        ret=self.api.config_system_get()
        assert (ret.success)
        auth()
        pass

    def test_config_system_modules_list_get(self):
        """
        Test case for config_system_modules_list_get

        
        """
        ret = self.api.config_system_modules_list_get()
        assert (ret.success)
        pass

    def test_config_system_patch(self):
        """
        Test case for config_system_patch

        
        """
        ret = self.api.config_system_patch(body={'welcome_message': 'Welcome! '+lorem_ipsum()})
        assert (ret.success)
        pass

    def test_config_time_profile_all_delete(self):
        """
        Test case for config_time_profile_all_delete


        """
        pass

    def test_config_time_profile_create_post(self):
        """
        Test case for config_time_profile_create_post

        
        """

        s,e = tuple(sorted([get_rand('time'), get_rand('time')]))
        data={'name':'time_profile_'+bla(6),
              'start_time':s,
              'end_time':e,
              'start_day_of_week': random.choice(
                  ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday']),
              'end_day_of_week':random.choice(['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday']),
              'type_name':random.choice(['all time',  'weekly',  'daily'])
              }
        print(json.dumps(data))
        ret=self.api.config_time_profile_create_post(body=data)
        assert(ret.success)
        print(ret)
        pass

    def test_config_time_profile_list_get(self):
        """
        Test case for config_time_profile_list_get

        
        """
        order = ['name','type_name','start_day_of_week','end_day_of_week','start_time','end_time']
        for o in order:
            lst = self.api.config_time_profile_list_get(order_by=o, order_dir=random.choice(['asc', 'desc']))
            assert (lst.success)
        ret = self.api.config_time_profile_list_get()
        assert (ret.success)
        print(ret)
        pass

    def test_config_time_profile_time_profile_id_delete(self):
        """
        Test case for config_time_profile_time_profile_id_delete

        
        """
        pass

    def test_config_time_profile_time_profile_id_get(self):
        """
        Test case for config_time_profile_time_profile_id_get

        
        """
        ret=self.api.config_time_profile_time_profile_id_get(time_profile_id=rand_time_profile()[0])
        assert (ret.success)
        pass

    def test_config_time_profile_time_profile_id_patch(self):
        """
        Test case for config_time_profile_time_profile_id_patch

        
        """
        body = {'name': 'time to ' + bla(7),
                'type_name':random.choice(['all time', 'weekly', 'daily'])
                }
        ret = self.api.config_time_profile_time_profile_id_patch(time_profile_id=rand_time_profile()[0],body=body)
        assert (ret.success)
        pass

    def test_config_timeouts_get(self):
        """
        Test case for config_timeouts_get


        """
        ret = self.api.config_timeouts_get()
        assert (ret.success)
        print(ret)
        pass

    def test_config_timeouts_patch(self):
        """
        Test case for config_timeouts_patch


        """
        data = {
  'call_timeout': random.randint(0,6000),
  'default_billing_decimal': random.randint(0,6),
  'egress_pdd_timeout': random.randint(0,6000),
  'ingress_pdd_timeout': random.randint(0,6000),
  'ring_timeout': random.randint(0,6000)
}
        ret=self.api.config_timeouts_patch(body=data)
        assert(ret.success)
        pass

    def test_config_us_jurisdictionprefix_all_delete(self):
        """
        Test case for config_us_jurisdictionprefix_all_delete


        """
        pass

    def test_config_us_jurisdictionprefix_create_post(self):
        """
        Test case for config_us_jurisdictionprefix_create_post

        
        """
        data = dict(lata=dig(3),prefix=dig(5),ocn=dig(3),state=bla(2))
        ret = self.api.config_us_jurisdictionprefix_create_post(body=data)
        assert (ret.success)
        try:
            ret = self.api.config_us_jurisdictionprefix_create_post(body=data)
            assert (not ret.success)
        except Exception as e:
            assert ('duplicate' in str(e))

        pass

    def test_config_us_jurisdictionprefix_id_delete(self):
        """
        Test case for config_us_jurisdictionprefix_id_delete

        
        """
        pass

    def test_config_us_jurisdictionprefix_id_get(self):
        """
        Test case for config_us_jurisdictionprefix_id_get

        
        """
        pass

    def test_config_us_jurisdictionprefix_id_patch(self):
        """
        Test case for config_us_jurisdictionprefix_id_patch

        
        """
        old  = self.api.config_us_jurisdictionprefix_list_get().payload.items
        random.shuffle(old)
        old_id=old[0].id
        data = dict(lata=dig(3), prefix=dig(5), ocn=dig(3), state=bla(2))
        ret = self.api.config_us_jurisdictionprefix_create_post(body=data)
        assert (ret.success)
        ret1 = self.api.config_us_jurisdictionprefix_id_patch(id=ret.object_id,body=data)
        assert (ret1.success)
        try:
            ret2 = self.api.config_us_jurisdictionprefix_id_patch(id=old_id, body=data)
            assert (not ret2.success)
        except Exception as e:
            assert ('duplicate' in str(e))
        pass

    def test_config_us_jurisdictionprefix_list_get(self):
        """
        Test case for config_us_jurisdictionprefix_list_get

        
        """
        ret=self.api.config_us_jurisdictionprefix_list_get()
        assert(ret.success)
        pass


if __name__ == '__main__':
    unittest.main()
