# coding: utf-8

"""
    DNL API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

    OpenAPI spec version: 1.2.94
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import os
import sys
import unittest

import cli_dnl
from cli_dnl.rest import ApiException
from cli_dnl.apis.origination_api import OriginationApi
from . settings import *

def did_client():
    myip = [{'port': random.randint(1000,65535), 'ip': ip()}]
    data={
'active': get_rand('bool'),
'address': bla_bla(3),
'allowed_credit': random.random()+1000,
'auto_invoicing': get_rand('bool'),
'billing_by_port': random.choice(['by minutes','by port']),
'billing_email': bla_mail(),
'billing_mode': random.choice(['prepay', 'postpay']),
'call_limit': get_rand('int'),
'company': bla_comp(),
'resource': {'ip': myip},
'is_panel_accountsummary': get_rand('bool'),
'is_panel_balance': get_rand('bool'),
'is_panel_cdrslist': get_rand('bool'),
'is_panel_didrequest': get_rand('bool'),
'is_panel_invoices': get_rand('bool'),
'is_panel_mydid': get_rand('bool'),
'is_panel_paymenthistory': get_rand('bool'),
'is_panel_products': get_rand('bool'),
'is_panel_ratetable': get_rand('bool'),
'is_panel_summaryreport': get_rand('bool'),
'is_panel_trunks': get_rand('bool'),
'unlimited_credit': get_rand('bool'),
'main_email': 'user@example.com',
'media_type': random.choice(['Bypass Media', 'Proxy Media + Transcoding', 'Proxy Media']),
'name': 'did_client_'+bla(7),
'noc_email': bla_mail(),
'password': bla(7),
'rate_email': bla_mail(),
'test_credit': random.random()+1000,
'username': bla(7),
'payment_term_id':rand_payment_term()[0],
'auto_send_invoice': get_rand('bool'),
'client_taxes':[{'tax_name':bla(10),'tax_percent':random.random()*100}]
    }
    print(json.dumps(data))
    return data


class TestOriginationApi(unittest.TestCase):
    """ OriginationApi unit test stubs """

    def setUp(self):
        self.api = cli_dnl.apis.origination_api.OriginationApi()
        auth()
    def tearDown(self):
        pass

    def test_did_billing_rule_all_delete(self):
        """
        Test case for did_billing_rule_all_delete


        """
        pass

    def test_did_billing_rule_create_post(self):
        """
        Test case for did_billing_rule_create_post

        
        """
        auth()

        data = {
            "name": bla(6),
            "rate_type": 'fixed rate',#random.choice(['fixed rate','variable rate']),
            "pay_type": random.choice(['weekly','monthly']),
            "price_type": random.choice(['weekly', 'monthly']),
            "rate_per_min": round(random.random() * 10,4),
            "monthly_fee": round(random.random() * 0.1,4),

        }
        print(json.dumps(data))
        ret = self.api.did_billing_rule_create_post(body=data)
        assert (ret.success)
        return
        br=self.api.did_billing_rule_id_get(id=ret.object_id)
        assert(br.success)
        rt=cli_dnl.SwitchApi().switch_rate_table_rate_table_id_rate_list_get(rate_table_id=br.payload.rate_table_id,per_page=100)
        assert(rt and len(rt.payload.items)==62)




        ret = cli_dnl.SwitchApi().switch_rate_table_list_get()
        assert(ret)
        rt = random.choice(ret.payload.items)
        data={
            "name": bla(6),
            "payphone_subcharge": bla(4),
            "monthly_fee": random.random()*3,
            "rate_per_min": random.random()*10,
            "setup_fee": random.random(),
            "rate_type": random.choice(['fixed rate','variable rate']),
            "rate_table_id": rt.rate_table_id
        }
        ret=self.api.did_billing_rule_create_post(body=data)
        assert(ret.success)
        try:
            ret = self.api.did_billing_rule_create_post(body=data)
            assert (not ret.success)
        except Exception as e:
            assert('error' in str(e))
        data = {
            "name": bla(6),
            "payphone_subcharge": bla(4),
            "rate_per_min": random.random() * 10,
            "setup_fee": random.random(),
            "rate_type": 'fixed rate',
            "rate_table_id": rt.rate_table_id
        }

        ret = self.api.did_billing_rule_create_post(body=data)
        assert (ret.success)

        ret1 = self.api.did_repository_list_get(per_page=100,end_date_isnull=True,client_billing_rule_id_isnull=True)
        random.shuffle(ret1.payload.items)
        for did in ret1.payload.items[0:5]:
            self.api.did_repository_id_patch(did.id,body=dict(client_billing_rule_id=ret.object_id))


        pass

    def test_did_billing_rule_id_delete(self):
        """
        Test case for did_billing_rule_id_delete

        
        """
        pass

    def test_did_billing_rule_id_get(self):
        """
        Test case for did_billing_rule_id_get

        
        """
        auth()
        ret = self.api.did_billing_rule_list_get()
        assert (ret.success)
        tr = random.choice(ret.payload.items)
        ret=self.api.did_billing_rule_id_get(id=tr.id)
        print (ret.payload)
        assert(ret.success)
        pass

    def test_did_billing_rule_id_patch_fixed_rate(self):
        auth()
        br=rand_billing_rule(rate_type='fixed rate')[1]
        data={'rate_per_min':random.random()*100}
        ret1 = self.api.did_billing_rule_id_patch(id=br.id, body=data)
        assert (ret1.success)
        print (ret1)
        ret = cli_dnl.SwitchApi().switch_rate_table_rate_table_id_rate_list_get(rate_table_id=ret1.payload.rate_table_id)
        assert (ret)
        assert(abs(ret.payload.items[0].rate-data['rate_per_min'])<0.000001)

    def test_did_billing_rule_id_patch(self):
        """
        Test case for did_billing_rule_id_patch

        
        """
        auth()

        ret = cli_dnl.SwitchApi().switch_rate_table_list_get()
        assert (ret)
        rt = random.choice(ret.payload.items)

        ret = self.api.did_billing_rule_list_get()
        assert (ret.success)
        tr = random.choice(ret.payload.items)
        data = {'mothly_fee':random.random()*100,'name':bla(7),'payphone_subcharge':dig(3),
                'rate_type':'fixed rate','rate_per_min':random.random()*100,'rate_table_id':rt.rate_table_id,
                'pay_type':random.choice(['weekly','monthly']),
                'price_type': random.choice(['weekly', 'monthly']),
                }
        print(json.dumps(data))
        ret1 = self.api.did_billing_rule_id_patch(id=tr.id,body=data)
        assert(ret1.success)
        tr1 = random.choice(ret.payload.items)
        data['name']=tr1.name
        try:
            ret = self.api.did_billing_rule_id_patch(id=tr.id, body=data)
            assert (not ret.success)
        except:
            pass



    def test_did_billing_rule_id_rate_params_patch(self):
        """
        Test case for did_billing_rule_id_rate_params_patch


        """
        data = {
            "name": bla(6),
            "rate_type": 'fixed rate',
            "rate_per_min": random.random() * 10,
            "monthly_fee": random.random(),
        }
        print(json.dumps(data))
        ret = self.api.did_billing_rule_create_post(body=data)
        assert (ret.success)
        id=ret.object_id
        br= self.api.did_billing_rule_id_get(id=id).payload

        params={'min_time':get_rand('int'),'interval':get_rand('int')}
        ret=self.api.did_billing_rule_id_rate_params_patch(id=id,body=params)
        assert (ret.success)
        rt = cli_dnl.SwitchApi().switch_rate_table_rate_table_id_rate_list_get(rate_table_id=br.rate_table_id)
        assert (rt and len(rt.payload.items))
        for it in rt.payload.items:
            assert(it.min_time==params['min_time'])
        pass

    def test_did_billing_rule_list_get(self):
        """
        Test case for did_billing_rule_list_get

        
        """
        order = ['update_at','update_by','name','rate_table_id','rate_type','pay_type','price_type','payphone_subcharge','rate_per_min','monthly_fee','setup_fee','fee_per_port']
        o = random.choice(order)
        for o in order:
            lst = self.api.did_billing_rule_list_get(order_by=o, order_dir=random.choice(['asc', 'desc']))
            assert (lst.success)
        pass

    def test_did_client_all_delete(self):
        """
        Test case for did_client_all_delete


        """
        pass

    def test_did_client_all_patch(self):
        """
        Test case for did_client_all_patch


        """
        pass

    def test_did_client_client_id_delete(self):
        """
        Test case for did_client_client_id_delete

        
        """
        ret = self.api.did_client_client_id_delete(client_id=rand_client(client_type='client')[0])
        assert(ret.success)

        pass

    def test_did_client_client_id_get(self):
        """
        Test case for did_client_client_id_get

        
        """
        pass

    def test_did_client_client_id_patch(self):
        """
        Test case for did_client_client_id_patch

        
        """
        client=rand_cli()[1]
        data={'active':get_rand('bool'),'name':client.name,'resource':{'ip':[{'ip':'1.1.1.2','port':7778}]}}
        print("test PATCH /did_client/{} -d '{}'".format(client.client_id,json.dumps(data)))
        ret=self.api.did_client_client_id_patch(client_id=client.client_id,body=data)
        assert(ret.success)
        print(ret)
        return
        try:
            ret = self.api.did_client_client_id_patch(client_id=rand_client(client_type='client')[0],
                                                  body={'active': get_rand('bool'),'username':'admin'})
            assert (not ret.success)
        except Exception as e:
            assert('already' in str(e))

        ret = self.api.did_client_client_id_patch(client_id=rand_client(client_type='client')[0],
                                                  body=did_client())
        assert (ret.success)
        pass

    def test_did_client_create_post(self):
        """
        Test case for did_client_create_post

        
        """
        data=did_client()
        data['resource']['t38']=get_rand('bool')
        print(json.dumps(data))
        ret = self.api.did_client_create_post(body=data)
        assert (ret.success)
        ret = self.api.did_client_client_id_get(client_id=ret.object_id)
        print(ret)
        assert (ret.success)
        assert(ret.payload.resource.t38==data['resource']['t38'])
        return
        assert (ret.payload.auto_send_invoice == data['auto_send_invoice'])
        #return
        assert (ret.payload.resource.ip[0].ip==data['resource']['ip'][0]['ip'])
        #ret = self.api.did_client_client_id_get(client_id=ret.object_id)
        #assert (ret.success)
        data['name']='did_cli_2'+bla(6)
        data['username']=data['name']
        print(json.dumps(data))
        ret = self.api.did_client_create_post(body=data)
        assert (ret.success)
        ret1=self.api.did_client_client_id_get(client_id=ret.object_id)
        print(ret1)
        c=ret1.payload
        assert(c.auto_send_invoice==data['auto_send_invoice'])
        assert (c.payment_term_id == data['payment_term_id'])
        return ret
        pass

    def test_did_client_id_orig_invoice_post(self):
        """
        Test case for did_client_id_orig_invoice_post


        """
        lst = self.api.did_client_list_get().payload.items
        random.shuffle(lst)
        client_id = lst[0].client_id
        #client_id = rand_client(client_type='client')[0]
        #client_id=2323
        data = dict(
                    invoice_start=str((datetime.now()-timedelta(days=10)).date()),
                    invoice_end=str((datetime.now()-timedelta(days=1)).date()),
                    #create_type=random.choice(['sent(out--buy)','received(in--sell)','sent(all)','incoming']),
                    due = random.randint(3,30),
            show_account_summary=get_rand('bool'),
            show_transaction_summary_analysis=get_rand('bool'),
            show_authorization_code_summary=get_rand('bool'),
            show_all_area_codes_summary=get_rand('bool'),
            show_origination_lata_summary=get_rand('bool')
                    )
        print(client_id,json.dumps(data))
        ret=self.api.did_client_id_orig_invoice_post(client_id=client_id,body=data)
        assert (ret.success)
        print(ret)
        pass

    def test_did_client_list_get(self):
        """
        Test case for did_client_list_get

        
        """

        ret=self.api.did_client_list_get()
        assert(ret.success and len(ret.payload.items))
        pass

    def test_did_orig_invoice_all_delete(self):
        """
        Test case for did_orig_invoice_all_delete


        """
        pass

    def test_did_orig_invoice_invoice_id_delete(self):
        """
        Test case for did_orig_invoice_invoice_id_delete


        """
        pass

    def test_did_orig_invoice_invoice_id_file_get(self):
        """
        Test case for did_orig_invoice_invoice_id_file_get


        """
        pass

    def test_did_orig_invoice_invoice_id_get(self):
        """
        Test case for did_orig_invoice_invoice_id_get


        """
        pass

    def test_did_orig_invoice_invoice_id_patch(self):
        """
        Test case for did_orig_invoice_invoice_id_patch


        """
        pass

    def test_did_orig_invoice_list_get(self):
        """
        Test case for did_orig_invoice_list_get


        """
        pass

    def test_did_repository_all_delete(self):
        """
        Test case for did_repository_all_delete


        """
        pass

    def test_did_repository_available_list_get(self):
        """
        Test case for did_repository_available_list_get


        """
        ret=self.api.did_repository_available_list_get()
        assert (ret.success)
        pass

    def test_did_repository_create_post(self):
        """
        Test case for did_repository_create_post

        
        """
        #with client
        #cl=self.test_did_client_create_post()
        #id = cl.object_id
        vid = rand_client(ingress_count_gt=0, client_type='vendor')[0]
        v = self.api.did_vendor_client_id_get(client_id=vid)
        vr = v.payload.resource.resource_id
        id = rand_client(egress_count_gt=0,client_type='client')[0]

        data={
            'client_billing_rule_id': rand_billing_rule()[0],
            'vendor_billing_rule_id': rand_billing_rule()[0],
            'client_id': id,
            'did': dig(6),
            'vendor_res_id': vr
        }
        print(json.dumps(data))
        ret=self.api.did_repository_create_post(body=data)
        assert(ret.success)
        r=self.api.did_repository_id_get(id=ret.object_id)
        assert (r.success)
        print (r.payload)
        try:
            ret = self.api.did_repository_create_post(body=data)
            assert (not ret.success)
        except Exception as e:
            assert ('already exist' in str(e))

        return

        #without client
        data = {
            'client_billing_rule_id': rand_billing_rule()[0],
            'vendor_billing_rule_id': rand_billing_rule()[0],
            'did': dig(6),
            'vendor_res_id': rand_trunk(direction='ingress')[0],
            'is_available':get_rand('bool')
        }
        ret = self.api.did_repository_create_post(body=data)
        assert (ret.success)

        # with null
        data = {
            'client_billing_rule_id': rand_billing_rule()[0],
            'vendor_billing_rule_id': rand_billing_rule()[0],
            'client_id': None,
            'did': dig(6),
            'vendor_res_id': rand_trunk(direction='ingress')[0],
            'is_available': get_rand('bool')
        }
        ret = self.api.did_repository_create_post(body=data)
        assert (ret.success)
        
        

        pass

    def test_did_repository_id_delete(self):
        """
        Test case for did_repository_id_delete

        
        """
        pass

    def test_did_repository_id_get(self):
        """
        Test case for did_repository_id_get

        
        """
        ret = self.api.did_repository_list_get(order_by='id', order_dir='desc')
        assert (ret.success and len(ret.payload.items))
        random.shuffle(ret.payload.items)
        pass

    def test_did_repository_id_patch(self):
        """
        Test case for did_repository_id_patch

        
        """
        ret = self.api.did_repository_list_get(end_date_isnull=True,order_by='id',order_dir='desc')
        assert(ret.success and len(ret.payload.items))
        random.shuffle(ret.payload.items)

        it0 = ret.payload.items[0]
        data = {'client_id': None, 'is_available':get_rand('bool'),'actions': {'ani': {'type': 'Replace', 'new_number': dig(6)},
                                                           'dnis': {'type': 'Add Prefix', 'digits': dig(6)}}}
        r = self.api.did_repository_id_patch(id=it0.id, body=data)
        assert (r.success)


        it0 = r.payload#ret.payload.items[0]
        print(ret.payload.items[0])
        data = {'client_id':rand_client()[0],'client_billing_rule_id':rand_billing_rule()[0],
                'actions': {'ani': {'type': 'Replace', 'new_number': dig(6)},
                            'dnis': {'type': 'Add Prefix', 'digits': dig(6)}}}
        print(data)
        r = self.api.did_repository_id_patch(id=it0.id, body=data)
        assert (r.success)

        print(r)

        data = {'actions': {'ani': {'type': 'Replace', 'new_number': dig(6)},
                            'dnis': {'type': 'Replace', 'new_number': dig(6)}}}

        r = self.api.did_repository_id_patch(id=ret.payload.items[1].id, body=data)
        assert (r.success)

        data={'actions':{'ani':{'type':'Add Prefix','digits':dig(6)},'dnis':{'type':'Remove Prefix','num_digits':'3'}}}

        r=self.api.did_repository_id_patch(id=ret.payload.items[2].id,body=data)
        assert (r.success)

        data = {'actions': {'dnis': {'type': 'Add Prefix', 'digits': dig(6)},
                            'ani': {'type': 'Remove Prefix', 'num_digits': '3'}}}
        print(ret.payload.items[3], data)
        r = self.api.did_repository_id_patch(id=ret.payload.items[3].id, body=data)
        print(r)
        assert (r.success)




        pass

    def test_did_repository_list_get(self):
        """
        Test case for did_repository_list_get

        
        """
        for dir in ['asc','desc']:
            for sort in ['id', 'did', 'client_res_id', 'client_billing_rule_id', 'vendor_res_id',
        'vendor_billing_rule_id', 'is_available', 'client_id', 'vendor_id', 'did_client_name', 'did_vendor_name',
        'vendor_billing_rule_name', 'client_billing_rule_name','assigned_date','end_date']:
                ret=self.api.did_repository_list_get(order_by=sort,order_dir=dir,per_page=3)
                assert(ret.success and len(ret.payload.items) >0 )
        pass

    def test_did_repository_mass_assign_patch(self):
        """
        Test case for did_repository_mass_assign_patch


        """

        ret0 = self.api.did_repository_list_get(per_page=200)
        random.shuffle(ret0.payload.items)
        for did in ret0.payload.items:
            if did.end_date:
                continue
            if not did.client_res_id:
                continue
            res_id=did.client_res_id
            try:
                tr=cli_dnl.CarrierApi().egress_trunk_resource_id_get(resource_id=res_id).payload
                if not tr.client_id:
                    continue
            except:
                continue
            data = {
                'client_billing_rule_id': rand_billing_rule()[0],
                'vendor_billing_rule_id': rand_billing_rule()[0],
                'client_id': tr.client_id,
                'did': dig(6),
                'vendor_res_id': rand_trunk(direction='ingress')[0]
            }
            ret = self.api.did_repository_create_post(body=data)
            assert (ret.success)

            ru=rand_billing_rule()[0]
            data={'client_id':tr.client_id,'client_billing_rule_id':ru}
            print(data)
            ret=self.api.did_repository_mass_assign_patch(body=data)
            assert(ret.success)
            print (ret)
            break
        pass

    def test_did_routing_list_get(self):
        """
        Test case for did_routing_list_get

        
        """
        order = ['item_id','did','update_at']
        o = random.choice(order)
        for o in order:
            lst = self.api.did_routing_list_get(order_by=o, order_dir=random.choice(['asc', 'desc']))
            assert (lst.success)
        pass

    def test_did_vendor_all_delete(self):
        """
        Test case for did_vendor_all_delete


        """
        pass

    def test_did_vendor_all_patch(self):
        """
        Test case for did_vendor_all_patch


        """
        pass

    def test_did_vendor_client_id_delete(self):
        """
        Test case for did_vendor_client_id_delete

        
        """
        self.test_did_vendor_create_post()
        ret = self.api.did_vendor_list_get(per_page=200)
        assert (ret.success)
        random.shuffle(ret.payload.items)
        vend=random.choice(ret.payload.items)
        id = vend.client_id
        res_id=vend.resource.resource_id
        ret=self.api.did_vendor_client_id_delete(client_id=id)
        assert(ret.success)
        try:
            ret1=cli_dnl.CarrierApi().egress_trunk_resource_id_get(resource_id=res_id)
            assert(not ret1.success)
        except Exception as e:
            assert('not_found_error' in str(e))
        pass

    def test_did_vendor_client_id_get(self):
        """
        Test case for did_vendor_client_id_get

        
        """
        pass

    def test_did_vendor_client_id_patch(self):
        """
        Test case for did_vendor_client_id_patch

        
        """
        ret = self.api.did_vendor_list_get(per_page=200)
        assert (ret.success)
        random.shuffle(ret.payload.items)
        id=random.choice(ret.payload.items).client_id
        did0 = dig(5)
        did1 = dig(5)
        data = {
            'call_limit': 0,
            'resource': {
                'billing_by_port': random.choice(['by minutes', 'by minutes']),
                't38': get_rand('bool'),
                'vendor_tech_prefix': dig(8),
                'ip': [{'ip': ip(check_dublicates=False), 'port': random.randint(1000, 65535)}
                       ],
                'media_type': random.choice(['Bypass Media', 'Proxy Media + Transcoding', 'Proxy Media']),
                'vendor_dids': [
                    {
                        'did': did0 + ',' + did1
                    }
                ]
            },
            'status': get_rand('bool'),
            'billing_method': random.choice(['percentage', 'value']),
        }
        print(json.dumps(data))
        ret1=self.api.did_vendor_client_id_patch(client_id=id,body=data)
        assert(ret1.success)
        ret2 = self.api.did_vendor_client_id_get(client_id=id)
        assert (ret2.success)
        print(ret2)
        ret3 = self.api.did_repository_list_get(vendor_res_id=ret2.payload.resource.resource_id)
        assert (ret2.success)
        print(ret3)

        pass

    def test_did_vendor_client_id_upload_dids_post(self):
        """
        Test case for did_vendor_client_id_upload_dids_post

        
        """
        pass

    def test_did_vendor_create_post(self):
        """
        Test case for did_vendor_create_post

        
        """



        did0=dig(5)
        did1 = dig(5)
        data={
            'call_limit': 0,
            'resource': {
            'billing_by_port': random.choice(['by minutes','by minutes']),
            't38': get_rand('bool'),
            'vendor_tech_prefix': dig(8),
            'ip': [{'ip': ip(check_dublicates=False), 'port': random.randint(1000,65535)}
            ],
            'media_type': random.choice(['Bypass Media', 'Proxy Media + Transcoding', 'Proxy Media']),
            #'egress_dids': [{'did': did0+','+did1,'vendor_billing_rule_id':rand_billing_rule()[0]}]
            #'egress_dids': [{'did': did0 + ',' + did1}]
            },
            'status': get_rand('bool'),
            'billing_method': random.choice(['percentage','value']),
            'name': 'did_vendor_'+bla(6)+'-'+dig(6),
            #'vendor_billing_rule_id':rand_billing_rule()[0]
            }
        data['resource']['vendor_dids']=[]
        for i in range(10):
            data['resource']['vendor_dids'].append(dict(did=dig(8),vendor_billing_rule_id=rand_billing_rule()[0]))
        ret=self.api.did_vendor_create_post(body=data)
        assert(ret.success)
        print(json.dumps(data),ret)
        return
        id = ret.object_id
        ret1=self.api.did_repository_list_get(did=data['resource']['vendor_dids'][0]['did'],end_date_isnull=True)
        assert(ret1.success)
        print(ret1)
        assert (ret1.payload.items[0].vendor_id==id)
        try:
            data['name']=rand_trunk()[1].trunk_name
            ret2 = self.api.did_vendor_create_post(body=data)
            assert (not ret2.success)
        except Exception as e:
            print(e)
            assert('already' in str(e))
        return ret

        pass

    def test_did_vendor_list_get(self):
        """
        Test case for did_vendor_list_get

        
        """
        ret=self.api.did_vendor_list_get()
        assert (ret.success)
        pass


if __name__ == '__main__':
    unittest.main()
