# coding: utf-8

"""
    DNL API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

    OpenAPI spec version: 1.4.34
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import os
import sys
import unittest

import cli_dnl
from cli_dnl.rest import ApiException
from cli_dnl.apis.tool_api import ToolApi
from .settings import *

def rate_generation():
    data={
  'details': [],
  'code_deck_id': rand_code_deck()[0],
  'margin_default_value': dig(10),
  'lcr_digit': get_rand('int'),
  'decimal_places': random.randint(0,5),
  'last_generated': str(get_rand('datetime')),
  'effective_days': random.randint(0,365),
  'default_rate': random.random()*100,
  'margins': [],
  'margin_default_type': random.choice(['Percentage','Value']),
  'default_min_time': random.randint(0,60),
  'default_interval': random.randint(0,500),
  'rate_table_type': random.choice(['A-Z','US Jurisdictional', 'US Non Jurisdictional', 'OCN-LATA' ]),
  'include_local_rate': get_rand('bool'),
  'include_blocked_route': get_rand('bool'),
  'name': 'rate_generation_'+bla(8),
  #'egress_str': bla(8)
}
    tr=rand_trunk(direction='egress')[2]
    random.shuffle(tr)
    egr=[]
    for t in tr[0:5]:
        t1=cli_dnl.CarrierApi().egress_trunk_resource_id_get(resource_id=t.trunk_id).payload
        if t1.rate_table_id:
            egr.append(t.trunk_id)
    data['egress_trunks']=egr
    for i in range(0,5):
        details =  {
      'rate_interval': get_rand('int'),
      'min_time': get_rand('int'),
      'code': dig(6)
    }
        data['details'].append(details)
    for i in range(0, random.randint(0,5)):
        margins= {
      'markup_type': random.choice(['Percentage','Value']),
      'markup_value': random.random()*100,
      'max_rate': 100+random.random()*100,
      'min_rate': random.random()*100
    }
        data['margins'].append(margins)
    return data



def rerate():
    data={
  'to_date': get_rand('date'),
  'update_us_jurisdiction': 'no',
  'gmt': random.randint(-12,12),
  'ingress_trunks': [],
  'from_date': get_rand('date'),
  'egress_trunks': []
}
    for i in range(0, random.randint(0, 5)):
        data['ingress_trunks'].append({
        'rate_table_id': rand_rate_table()[0],
        'trunk_id': rand_trunk(direction='ingress')[0],
        'effective_date': get_rand('date'),
        'update_rate': get_rand('bool')
    })
    for i in range(0, random.randint(0, 5)):
        data['egress_trunks'].append({
        'rate_table_id': rand_rate_table()[0],
        'trunk_id': rand_trunk(direction='egress')[0],
        'effective_date': get_rand('date'),
        'update_rate': get_rand('bool')
    })

def send_rate(**kwargs):
    ls=rand_trunk(per_page=100)[2]
    random.shuffle(ls)
    trunks=[t.trunk_id for t in ls][0:4]
    data= {
        'effective_date': str(get_rand('date')),
        'trunks': trunks,
        'is_disable': get_rand('bool'),
        'download_deadline': str(get_rand('date')),
        'rate_table_id': rand_rate_table()[0],
        'format': random.choice(['csv','json','xls']),
        'is_email_alert': get_rand('bool'),
        'download_method': random.choice(['link','attachment']),
        'send_type': random.choice(['Send to carriers using this rate table', 'Specify my own recipients']),
        'zip': get_rand('bool'),
        'email_template_id':rand_send_rate_template()[0],
        'send_specify_email':bla_mail()+';'+bla_mail()
    }
    for a in kwargs:
        data[a]=kwargs[a]
    return data

def rate_upload_template(*kwargs):
    RATE_TABLE_TYPE = {0: 'A-Z', 1: 'US Jurisdictional', 2: 'US Non Jurisdictional', 3: 'OCN-LATA'}
    SEND_ERROR_EMAIL_TO = {0: 'none', 1: 'Carrier Rate Contact', 2: 'Switch Rate Contact'}
    REJECT_RATE = {0: 'no', 1: 'yes'}
    CODE_NAME_MATCH = {1: 'Re-populate Country and Code Name with Selected Code Deck',
                       2: 'Re-populate Country and Code Name with Selected Code Deck if not available'}
    DUP_METHOD = {1: 'Delete Existing Records', 2: 'End-Date Existing Records', 0: 'End-Date All Records'}

    EFFECTIVE_DATE_FORMAT = ['mm/dd/yyyy', 'yyyy-mm-dd', 'dd-mm-yyyy', 'dd/mm/yyyy', 'yyyy/mm/dd']
    eff=random.choice(EFFECTIVE_DATE_FORMAT)
    HEADERS=['rate_id', 'rate_table_id', 'code', 'rate', 'setup_fee', 'effective_date', 'end_date', 'min_time',
 'grace_time', 'interval', 'time_profile_id', 'seconds', 'code_name', 'basic_percentages', 'gift_percentages',
 'rate_type', 'intra_rate', 'inter_rate', 'local_rate', 'country', 'zone', 'ocn', 'lata', 'create_time', 'did_type']
    random.shuffle(HEADERS)
    hdrs=HEADERS[0:6]
    data={
 'rate_table_type': random.choice(list(RATE_TABLE_TYPE.values())),
  'code_name_match': random.choice(list(CODE_NAME_MATCH.values())),
  'end_date_gmt': '({:+d})'.format(random.randint(-12,12)),
  'min_time_default': get_rand('int'),
  'end_date_all_gmt': '({:+d})'.format(random.randint(-12,12)),
  'append_prefix_value': dig(5),
  'check_effective': get_rand('bool'),
  'new_code_days': get_rand('int'),
  'interval_default': get_rand('int'),
  'effective_date_default': str(get_rand('datetime')),
  'rate_increase_days': get_rand('int'),
  'effective_date_format': eff,
  'dup_method': random.choice(list(DUP_METHOD.values())),
  'reject_rate': random.choice(list(REJECT_RATE.values())),
  'end_date_all': str(get_rand('datetime')),
  'name': 'rate_up_templ_'+bla(8),
  'end_date': str(get_rand('datetime')),
  'has_code_deck': get_rand('bool'),
  'send_error_email_to': random.choice(list(SEND_ERROR_EMAIL_TO.values())),
  'append_prefix': get_rand('bool'),
  'with_header': get_rand('bool'),
  'headers': hdrs }
    for a in kwargs:
        data[a]=kwargs[a]
    return data





class TestToolApi(unittest.TestCase):
    """ ToolApi unit test stubs """

    def setUp(self):
        self.api = cli_dnl.apis.tool_api.ToolApi()
        auth()

    def tearDown(self):
        pass

    def test_rt_cdr_get_get(self):
        """
        Test case for rt_cdr_get_get


        """
        pass

    def test_rt_cdr_request_list_get(self):
        """
        Test case for rt_cdr_request_list_get


        """
        pass

    def test_rt_cdr_request_post(self):
        """
        Test case for rt_cdr_request_post


        """
        pass

    def test_rt_cdr_request_request_id_delete(self):
        """
        Test case for rt_cdr_request_request_id_delete


        """
        pass

    def test_rt_cdr_request_request_id_download_get(self):
        """
        Test case for rt_cdr_request_request_id_download_get


        """
        pass

    def test_rt_cdr_request_request_id_get(self):
        """
        Test case for rt_cdr_request_request_id_get


        """
        pass

    def test_rt_cdr_request_request_id_restart_post(self):
        """
        Test case for rt_cdr_request_request_id_restart_post


        """
        pass

    def test_rt_cdr_request_request_id_sendmail_post(self):
        """
        Test case for rt_cdr_request_request_id_sendmail_post


        """
        pass

    def test_rt_ports_status_get(self):
        """
        Test case for rt_ports_status_get


        """
        auth()
        ret=self.api.rt_ports_status_get()
        print (ret)
        assert(ret.success)
        pass

    def test_rt_qos_port_get(self):
        """
        Test case for rt_qos_port_get


        """
        pass

    def test_rt_qos_post(self):
        """
        Test case for rt_qos_post


        """
        pass

    def test_rt_report_get(self):
        """
        Test case for rt_report_get


        """
        pass

    def test_tool_call_call_id_file_get(self):
        """
        Test case for tool_call_call_id_file_get


        """
        pass

    def test_tool_call_track_create_post(self):
        """
        Test case for tool_call_track_create_post


        """
        pass

    def test_tool_call_track_list_get(self):
        """
        Test case for tool_call_track_list_get


        """
        pass

    def test_tool_call_track_uuid_delete(self):
        """
        Test case for tool_call_track_uuid_delete


        """
        pass

    def test_tool_call_track_uuid_get(self):
        """
        Test case for tool_call_track_uuid_get


        """
        pass

    def test_tool_calls_create_post(self):
        """
        Test case for tool_calls_create_post


        """
        pass

    def test_tool_calls_list_get(self):
        """
        Test case for tool_calls_list_get


        """
        pass

    def test_tool_calls_req_uuid_delete(self):
        """
        Test case for tool_calls_req_uuid_delete


        """
        pass

    def test_tool_calls_req_uuid_get(self):
        """
        Test case for tool_calls_req_uuid_get


        """
        pass

    def test_tool_calls_req_uuid_patch(self):
        """
        Test case for tool_calls_req_uuid_patch


        """
        pass

    def test_tool_cdr_task_create_post(self):
        """
        Test case for tool_cdr_task_create_post


        """
        from api_dnl.utils.statisticapi2 import StatisticAPI
        retu=cli_dnl.apis.AuthApi().auth_post(body=dict(email_or_name='admin',password='yoo5Iche'))
        auth()
        sapi = StatisticAPI()
        sapi.set_token(token=retu.payload.cdr_api_token,exp=int(retu.payload.cdr_api_token_expiration))
        #sapi.authenticate(user='admin')
        start_time = int((datetime.now(UTC) - timedelta(days=30)).timestamp())
        end_time = int((datetime.now(UTC) - timedelta(days=1)).timestamp())
        params = dict(start_time=start_time, end_time=end_time, ingress_id = '3157'
                      )
        obj = sapi.send_request(params=params, rt_api='async', method='post').json()
        print(obj)
        data=dict(request_id=obj['request_id'],email_to='_novvv@mail.ru')
        ret = self.api.tool_cdr_task_create_post(body=data)
        assert(ret.success)
        print (ret)
        pass

    def test_tool_cdr_task_list_get(self):
        """
        Test case for tool_cdr_task_list_get


        """
        pass

    def test_tool_cdr_task_request_uuid_file_name_delete(self):
        """
        Test case for tool_cdr_task_request_uuid_file_name_delete


        """
        pass

    def test_tool_cdr_task_request_uuid_file_name_get(self):
        """
        Test case for tool_cdr_task_request_uuid_file_name_get


        """
        pass

    def test_tool_lcr_test_create_post(self):
        """
        Test case for tool_lcr_test_create_post


        """
        pass

    def test_tool_lcr_test_id_call_post(self):
        """
        Test case for tool_lcr_test_id_call_post


        """
        pass

    def test_tool_lcr_test_id_delete(self):
        """
        Test case for tool_lcr_test_id_delete


        """
        pass

    def test_tool_lcr_test_id_get(self):
        """
        Test case for tool_lcr_test_id_get


        """
        pass

    def test_tool_pcap_download_query_key_get(self):
        """
        Test case for tool_pcap_download_query_key_get


        """
        q='9d54e035-3a00-4512-a789-9cf6c790cc57'
        r=self.api.tool_pcap_download_query_key_get(query_key=q)
        print(r)
        pass

    def test_tool_pcap_log_get(self):
        """
        Test case for tool_pcap_log_get


        """
        pass

    def test_tool_pcap_query_post(self):
        """
        Test case for tool_pcap_query_post


        """
        data =dict(
            callid = '92011-10668@192.99.10.113', start = '2017-12-06 23:00+00', finish = '2017-12-07 10:00+00',
            switch_ip = '172.31.1.100'
        )
        ret=self.api.tool_pcap_query_post(body=data)
        print (ret)
        assert(ret.success)
        return ret
        pass

    def test_tool_pcap_query_query_key_delete(self):
        """
        Test case for tool_pcap_query_query_key_delete


        """
        pass

    def test_tool_pcap_query_query_key_get(self):
        """
        Test case for tool_pcap_query_query_key_get


        """
        q=self.test_tool_pcap_query_post().object_pk
        ret = self.api.tool_pcap_query_query_key_get(query_key=q)
        print(ret)
        assert (ret.success)
        print('please wait 3 min....')
        i = 64
        while (ret.payload.status!='no call id' and ret.payload.status!='success' and i>1):
            sleep(10)
            ret = self.api.tool_pcap_query_query_key_get(query_key=q)
            i=i-1
        print(ret)
        pass

    def test_tool_pcap_query_query_key_restart_patch(self):
        """
        Test case for tool_pcap_query_query_key_restart_patch


        """
        pass

    def test_tool_pcap_query_task_create_post(self):
        """
        Test case for tool_pcap_query_task_create_post


        """
        auth()
        data=dict(pcap_start_time=str(datetime.now()-timedelta(hours=12)),
                  pcap_end_time=str(datetime.now() - timedelta(hours=12)),
                  filter = 'call-id==123@1.2.3.4 and ip.src==1.2.3.4'
                  )
        print(json.dumps(data))

        ret=self.api.tool_pcap_query_task_create_post(body=data)
        assert(ret.success)
        pass

    def test_tool_pcap_query_task_id_delete(self):
        """
        Test case for tool_pcap_query_task_id_delete


        """
        pass

    def test_tool_pcap_query_task_id_get(self):
        """
        Test case for tool_pcap_query_task_id_get


        """
        pass

    def test_tool_pcap_query_task_list_get(self):
        """
        Test case for tool_pcap_query_task_list_get


        """
        ret = self.api.tool_pcap_query_task_list_get()
        print(ret)
        assert (ret.success)
        pass

    def test_tool_rate_auto_import_rule_id_delete(self):
        """
        Test case for tool_rate_auto_import_rule_id_delete


        """
        pass

    def test_tool_rate_auto_import_rule_id_get(self):
        """
        Test case for tool_rate_auto_import_rule_id_get


        """
        pass

    def test_tool_rate_auto_import_rule_id_patch(self):
        """
        Test case for tool_rate_auto_import_rule_id_patch


        """
        pass

    def test_tool_rate_auto_import_rule_list_get(self):
        """
        Test case for tool_rate_auto_import_rule_list_get


        """
        pass

    def test_tool_rate_auto_import_rule_post(self):
        """
        Test case for tool_rate_auto_import_rule_post


        """
        pass

    def test_tool_rate_generation_all_delete(self):
        """
        Test case for tool_rate_generation_all_delete


        """
        pass

    def test_tool_rate_generation_apply_id_patch(self):
        """
        Test case for tool_rate_generation_apply_rate_generation_history_id_get


        """
        #name='generated_rates_'+bla(8)
        name='generated_rates_Crwjppye'
        data={'rate_table_name':name,
              'action':random.choice(['delete old rates', 'end date all records', 'end date existing records']),
              'effective_date':str(get_rand('date')),
              'end_date': str(get_rand('date'))
              }
        #id = rand_rate_generation_history()[0]
        id =105;
        print(id,data)
        ret=self.api.tool_rate_generation_apply_id_patch(id=id,body=data)
        assert(ret.success)
        rt=rand_rate_table(name=data['rate_table_name'])[2]
        assert(len(rt)==1)
        print(rt[0])
        ret = self.api.tool_rate_generation_apply_id_patch(id=id, body=data)
        assert (ret.success)


        pass

    def test_tool_rate_generation_id_delete(self):
        """
        Test case for tool_rate_generation_id_delete

        
        """
        self.test_tool_rate_generation_post()
        ret = self.api.tool_rate_generation_id_delete(id=rand_rate_generation()[0])
        assert (ret.success)
        pass

    def test_tool_rate_generation_id_get(self):
        """
        Test case for tool_rate_generation_id_get

        
        """
        ret = self.api.tool_rate_generation_id_get(id=rand_rate_generation()[0])
        assert (ret.success)
        pass

    def test_tool_rate_generation_id_patch(self):
        """
        Test case for tool_rate_generation_id_patch

        
        """
        ret = self.api.tool_rate_generation_id_patch(id=rand_rate_generation()[0],body=rate_generation())
        assert (ret.success)
        pass

    def test_tool_rate_generation_id_start_post(self):
        """
        Test case for tool_rate_generation_id_start_post


        """
        id = rand_rate_generation()[0]
        ret=self.api.tool_rate_generation_id_start_post(id=id)
        assert(ret.success)
        print(id)
        pass

    def test_tool_rate_generation_list_get(self):
        """
        Test case for tool_rate_generation_list_get

        
        """
        ret = self.api.tool_rate_generation_list_get()
        assert (ret.success and len(ret.payload.items))
        pass

    def test_tool_rate_generation_post(self):
        """
        Test case for tool_rate_generation_post

        
        """
        data=rate_generation()
        print(json.dumps(data))
        ret=self.api.tool_rate_generation_post(body=data)
        assert(ret.success)
        print(ret)
        pass

    def test_tool_rate_generation(self):
        """
                Complex test case for tool_rate_generation


        """
        from time import sleep
        data = {
        'name': 'test' + dig(6),
        'rate_table_type': 'A-Z',
        'lcr_digit': 2,
        'default_rate': 1.2,
        'margin_default_type': 'Percentage',
        'margin_default_value': '15',
        'default_interval': 8,
        'default_min_time': 8,
        'code_deck_id': 0,
        'egress_trunks': [1651, 1711],
        'effective_days': 0,
        'decimal_places': 3,
        'include_blocked_route': True,
        'include_local_rate': True
        }
        print('call api tool_rate_generation_post with input: POST/tool/rate_generation -d ')
        print(json.dumps(data))
        ret = self.api.tool_rate_generation_post(body=data)
        assert (ret.success)
        print('template_id is ',ret)
        print('start generation: POST/tool/rate_generation/{}/start'.format(ret.object_id))
        hist = self.api.tool_rate_generation_id_start_post(id=ret.object_id)
        assert (hist.success)
        print('generation started history id is', hist)
        sleep(10)
        rates=self.api.tool_rate_generation_rates_rate_generation_history_id_get(rate_generation_history_id=hist.object_id)
        assert (rates.success)
        print('get generated rates: GET/tool/rate_generation/rates/{}'.format(hist.object_id))
        print(rates)



    def test_tool_rate_generation_rates_rate_generation_history_id_get(self):
        """
        Test case for tool_rate_generation_rates_rate_generation_history_id_get


        """
        pass

    def test_tool_rate_upload_all_delete(self):
        """
        Test case for tool_rate_upload_all_delete


        """
        pass

    def test_tool_rate_upload_id_approve_patch(self):
        """
        Test case for tool_rate_upload_id_approve_patch


        """
        pass

    def test_tool_rate_upload_id_delete(self):
        """
        Test case for tool_rate_upload_id_delete


        """
        pass

    def test_tool_rate_upload_id_error_get(self):
        """
        Test case for tool_rate_upload_id_error_get


        """
        lst = self.api.tool_rate_upload_list_get().payload.items
        ru = random.choice(lst)
        ret=self.api.tool_rate_upload_id_error_get(id=ru.id)
        print(ret)

        pass

    def test_tool_rate_upload_id_format_get(self):
        """
        Test case for tool_rate_upload_id_format_get


        """
        pass

    def test_tool_rate_upload_id_get(self):
        """
        Test case for tool_rate_upload_id_get


        """
        pass

    def test_tool_rate_upload_id_get_header_start_from_get(self):
        """
        Test case for tool_rate_upload_id_get_header_start_from_get


        """
        pass

    def test_tool_rate_upload_id_orig_get(self):
        """
        Test case for tool_rate_upload_id_orig_get


        """
        pass

    def test_tool_rate_upload_id_patch(self):
        """
        Test case for tool_rate_upload_id_patch


        """
        id = rand_rate_table()[0]
        data=dict(rate_date_format='yyyy-mm-dd',
                 method='delete',rate_table_id=id,
                 code_deck_flag='use rate code',
                 use_ocn_lata_code='Yes')
        data['info']={
            'fields':{'Code':'code','Rate':'rate','Effective_date':'effective_date','Interval':'interval',
                      'Min_time':'min_time','End_date':'end_date','Inter_rate':'inter_rate','Intra_rate':'intra_rate'},
            'time_intervals':[{'interval':45,'min_time':120},
                              {'code':'1','interval':5,'min_time':20}],
            'prefix_default':dig(3),
            'start_from':0
        }

        obj=self.test_tool_rate_upload_post()
        print(json.dumps(data))
        self.api.tool_rate_upload_id_patch(id=obj.object_id,body=data)
        pass

    def test_tool_rate_upload_id_patch_xls1(self):
        """
        Test case for tool_rate_upload_id_patch


        """
        id = rand_rate_table()[0]
        data=dict(rate_date_format='yyyy-mm-dd',
                 method='delete',rate_table_id=id,
                 code_deck_flag='use rate code',
                 use_ocn_lata_code='Yes')
        data['info']={
            'fields':{'Code':'Destination Code',
                      'Rate':'Rate',
                      'Effective_date':'Effective Date',
                      'Country':'Country',
                      'Code_name':'Destination'
                      },
            'time_intervals':[{'interval':1,'min_time':1},
                              {'code':'244','interval':2,'min_time':2},
                              ],
            #'prefix_default':dig(3),
            'start_from':13
        }
        f1 = '/home/novvv/prj/dnl/gamma/rates/BROK2_ICX_Customer_Gold_17-Apr-2016.xls'
        ret = self.api.tool_rate_upload_post(rate_file=f1)
        assert (ret.success)
        ret1=self.api.tool_rate_upload_id_patch(id=ret.object_id,body=data)
        assert (ret1.success)
        print(ret1)
        pass

    def test_tool_rate_upload_id_patch_xls3(self):
        """
        Test case for tool_rate_upload_id_patch


        """
        id = rand_rate_table()[0]
        data=dict(rate_date_format='yyyy-mm-dd',
                 method='delete',rate_table_id=id,
                 code_deck_flag='use rate code',
                 use_ocn_lata_code='Yes')
        data['info']={
            'fields':{'Code':'Country Code(s)',
                      'Rate':'Rate',
                      'Effective_date':'Rate Eff Date',
                      'Code_name':'Country Name',
                      'Interval': 'Increments',
                      'Min_time': 'Rate Status'
                      },
            'time_intervals':[
                              {'code':'244','interval':2,'min_time':2},
                              ],
            #'prefix_default':dig(3),
            'start_from':11
        }
        f1 = '/home/novvv/prj/dnl/gamma/rates/Vinculum Standard Rate Change 12-1-15(FULL REPLACEMENT).xls'
        ret = self.api.tool_rate_upload_post(rate_file=f1)
        assert (ret.success)
        ret1=self.api.tool_rate_upload_id_patch(id=ret.object_id,body=data)
        assert (ret1.success)
        print(ret1)
        pass


    def test_tool_rate_upload_id_patch_xls2(self):
        """
        Test case for tool_rate_upload_id_patch


        """
        id = rand_rate_table()[0]
        data=dict(rate_date_format='dd/mm/yyyy',
                method='ignore',rate_table_id=id,
                code_deck_flag='use rate code',
                use_ocn_lata_code='No',
                rate_end_date=(datetime.now(UTC) + timedelta(days=30)).strftime('%d/%m/%Y'),
                all_rate_end_date =  str(datetime.now(UTC) + timedelta(days=30))
        )
        data['info']={
            'fields':{'Code':'Code',
                      'Rate':'Rate',
                      'Effective_date':'Effective Date',
                      'Code_name':'Destination'
                      },
            'time_intervals':[{'interval':1,'min_time':1},
                              {'code':'9','interval':2,'min_time':2},
                              ],
            #'prefix_default':dig(3),
            'start_from':16,
        }
        f1 = '/home/novvv/prj/dnl/gamma/rates/Rate Notification Sheet_STANDARD_30.03.2016.xlsx'
        ret = self.api.tool_rate_upload_post(rate_file=f1)
        assert (ret.success)
        print(json.dumps(data))
        ret1=self.api.tool_rate_upload_id_patch(id=ret.object_id,body=data)
        assert (ret1.success)
        print(ret1)
        pass

    def test_tool_rate_upload_id_preview_get(self):
        """
        Test case for tool_rate_upload_id_preview_get


        """
        pass

    def test_tool_rate_upload_list_get(self):
        """
        Test case for tool_rate_upload_list_get


        """
        order = ['id','rate_table_id','operator_user','status','method','start_date_time','rate_table_name']
        o = random.choice(order)
        for o in order:
            lst = self.api.tool_rate_upload_list_get(order_by=o, order_dir=random.choice(['asc', 'desc']))
            assert (lst.success)
        pass

    def test_tool_rate_upload_post(self):
        """
        Test case for tool_rate_upload_post


        """

        f1='Rate.csv'

        ret=self.api.tool_rate_upload_post(rate_file=f1)
        assert(ret.success)
        print(ret)
        return ret
        pass

    def test_tool_rate_upload_template_id_delete(self):
        """
        Test case for tool_rate_upload_template_id_delete


        """
        r = self.test_tool_rate_upload_template_post()
        ret = self.api.tool_rate_upload_template_id_delete(id=r.object_id)
        assert (ret.success)
        pass

    def test_tool_rate_upload_template_id_get(self):
        """
        Test case for tool_rate_upload_template_id_get


        """
        data=rate_upload_template()
        ret0 = self.api.tool_rate_upload_template_post(body=data)
        ret = self.api.tool_rate_upload_template_id_get(id=ret0.object_id)
        assert (ret.success)
        assert(ret.payload.name==data['name'])
        ret = self.api.tool_rate_upload_template_id_delete(id=ret0.object_id)
        pass

    def test_tool_rate_upload_template_id_patch(self):
        """
        Test case for tool_rate_upload_template_id_patch


        """
        r=self.test_tool_rate_upload_template_post()
        ret = self.api.tool_rate_upload_template_id_patch(id=r.object_id,body=rate_upload_template())
        assert (ret.success)
        ret = self.api.tool_rate_upload_template_id_delete(id=r.object_id)
        pass

    def test_tool_rate_upload_template_list_get(self):
        """
        Test case for tool_rate_upload_template_list_get


        """
        order = ['create_on', 'update_on','id','create_by','name','dup_method','append_prefix_value','create_by','end_date',
                 ]
        o = random.choice(order)
        for o in order:
            lst = self.api.tool_rate_upload_template_list_get(per_page=3,order_by=o, order_dir=random.choice(['asc', 'desc']))
            print(o,'success')
            assert (lst.success)
        pass

    def test_tool_rate_upload_template_post(self):
        """
        Test case for tool_rate_upload_template_post


        """
        data = rate_upload_template()
        ret=self.api.tool_rate_upload_template_post(body=data)
        assert (ret.success)
        print(json.dumps(data))
        ret1 = self.api.tool_rate_upload_template_id_get(id=ret.object_id)
        assert(ret1.payload.create_by=='admin')
        return ret

        pass

    def test_tool_rerate_id_delete(self):
        """
        Test case for tool_rerate_id_delete

        
        """
        self.test_tool_rerate_post()
        ret = self.api.tool_rerate_id_get(id=rand_rerate()[0])
        assert (ret.success)
        pass

    def test_tool_rerate_id_get(self):
        """
        Test case for tool_rerate_id_get

        
        """
        ret = self.api.tool_rerate_id_get(id=rand_rerate()[0])
        assert (ret.success)
        pass

    def test_tool_rerate_id_patch(self):
        """
        Test case for tool_rerate_id_patch

        
        """
        ret=self.api.tool_rerate_id_patch(id=rand_rerate()[0],body=rerate())
        assert (ret.success)
        pass

    def test_tool_rerate_list_get(self):
        """
        Test case for tool_rerate_list_get

        
        """
        #'id', 'status', 'progress', 'err_code'
        for dir in ['asc','desc']:
            for sort in ['id', 'status', 'progress', 'err_code','from_date','to_date']:
                ret = self.api.tool_rerate_list_get(order_by=sort,order_dir=dir,per_page=3)
                print(sort,'success')
                assert(ret.success)


        pass

    def test_tool_rerate_post(self):
        """
        Test case for tool_rerate_post

        
        """
        ret = self.api.tool_rerate_post( body=rerate())
        assert (ret.success)
        pass

    def test_tool_rt_callback_request_uuid_post(self):
        """
        Test case for tool_rt_callback_request_uuid_post


        """
        pass

    def test_tool_send_rate_all_delete(self):
        """
        Test case for tool_send_rate_all_delete


        """
        ret = self.api.tool_send_rate_all_delete()
        assert (ret.success)
        pass

    def test_tool_send_rate_detail_list_get(self):
        """
        Test case for tool_send_rate_detail_list_get


        """
        for dir in ['asc','desc']:
            for sort in ['id','job_id','trunk_id','status','send_to', 'trunk_id','trunk_name','client_id','client_name',
                         'rate_table_name', 'email_count', 'recipient_count', 'process', 'send_type','create_time','error',
                         'sent_area','file']:
                ret = self.api.tool_send_rate_detail_list_get(order_by=sort,order_dir=dir,per_page=3)
                assert (ret.success)
                print(sort,'success')


        pass

    def test_tool_send_rate_id_download_get(self):
        """
        Test case for tool_send_rate_id_download_get


        """
        pass

    def test_tool_send_rate_job_id_resend_post(self):
        """
        Test case for tool_send_rate_job_id_resend_post


        """
        ret = self.api.tool_send_rate_list_get(order_by='create_time',order_dir='desc')
        assert (ret.success and len(ret.payload.items))
        random.shuffle(ret.payload.items)
        id=ret.payload.items[0].job_id
        data ={'download_deadline':str( (datetime.now()+timedelta(days=random.randint(1,30))).date() )}
        ret=self.api.tool_send_rate_job_id_resend_post( job_id = id, body = data )
        assert (ret.success)
        print(id,ret.object_id,data['download_deadline'])
        pass

    def test_tool_send_rate_list_get(self):
        """
        Test case for tool_send_rate_list_get

        
        """
        self.test_tool_send_rate_post()
        ret = self.api.tool_send_rate_list_get()
        assert (ret.success and len(ret.payload.items))
        pass

    def test_tool_send_rate_post_spec_emails(self):
        """
        Test case for tool_send_rate_post


        """
        data = send_rate()
        direct = {
            'subject': 'Temporary send rate',
            'headers': [
                'rate_table_id', 'rate', 'code'
            ],
            'content': 'Hi {client_name}. Your rate is {download_link}',
            'mail_cc': '_novvv@mail.ru',
            'download_method': 'send as link',
            'sender_id': 1
        }
        del data['email_template_id']
        data['email_direct'] = direct
        data['download_method'] = 'link'
        data['send_type'] ='Specify my own recipients'
        data['send_specify_email'] = 'mizdesino@gmail.com'
        ret = self.api.tool_send_rate_post(body=data)
        print(ret)
        assert (ret.success)
        return
        data = send_rate()
        ret = self.api.tool_send_rate_post(body=data)
        assert (ret.success)
        print(ret)

    def test_tool_send_rate_post(self):
        """
        Test case for tool_send_rate_post

        
        """
        data=send_rate()
        direct = {
            'subject': 'Temporary send rate',
            'headers': [
                'rate_table_id','rate','code'
            ],
            'content': 'Hi {client_name}. Your rate is <a href="http://localhost:9001/download/rate/{download_token}">download link</a>',
            'mail_cc': '_novvv@mail.ru',
            'download_method': 'send as link',
            'sender_id': 1
        }
        del data['email_template_id']
        data['email_direct'] = direct
        data['download_method'] = 'link'
        print('POST/tool/send_rate -d',json.dumps(data))
        ret = self.api.tool_send_rate_post(body=data)
        print(ret)
        assert (ret.success)
        return
        data = send_rate()
        ret = self.api.tool_send_rate_post(body=data)
        assert (ret.success)
        print(ret)
        try:
            data['download_deadline']='2016-01-01'
            ret = self.api.tool_send_rate_post(body=data)
            assert (not ret.success)
        except Exception as e:
            assert ('download_deadline' in str(e))
        try:
            data['download_deadline'] = '2020-01-01'
            data['email_direct'] = direct
            ret = self.api.tool_send_rate_post(body=data)
            assert (not ret.success)
        except Exception as e:
            assert ('template or direct' in str(e))



        pass

    def test_tool_send_rate_rate_download_token_get(self):
        """
        Test case for tool_send_rate_rate_download_token_get


        """
        pass

    def test_tool_send_rate_rate_request_id_get(self):
        """
        Test case for tool_send_rate_rate_request_id_get


        """
        pass

    def test_tool_simulate_call_post(self):
        """
        Test case for tool_simulate_call_post

        
        """
        pass

    def test_config_us_jurisdictionprefix_list_get(self):

        #ret=cli_dnl.SwitchApi().switch_list_get()
        #print (ret.payload.items)
        auth()
        ip=None
        while not ip:
            tr=cli_dnl.CarrierApi().ingress_trunk_resource_id_get(resource_id=rand_trunk(direction='ingress')[0] ).payload
            ipl=cli_dnl.TrunkApi().trunk_ip_list_get(resource_id=tr.resource_id)
            if not len(ipl.payload.items):
                continue
            ip=random.choice(ipl.payload.items).ip
        data= {
            'server': 'class4',#rand_switch()[1].name,
            #'call_time': str(get_rand('datetime')),
            'ingress_trunk': tr.trunk_id,
            'ingress_host': ip,
            'dnis': dig(13),
            'ani': dig(13)
        }
        print(json.dumps(data))
        ret=self.api.tool_simulate_call_post(body=data)
        assert(ret.success)
        print(ret.payload)
        pass


if __name__ == '__main__':
    unittest.main()
