from falcon_rest.db import fields, orm
from falcon_rest import schemes, resources
from falcon_rest.db import Column
from falcon_rest.conf import settings
from falcon_rest.contrib.files import create_file_model_class, create_scheme
from falcon_rest.contrib.files.endpoints import UploadFile, GetDownloadLink, DownloadFile, ShowFile
from marshmallow_sqlalchemy import field_for, fields as sa
from marshmallow import (
    Schema, pre_load, pre_dump, post_dump, post_load, validates_schema,
    validates, fields, ValidationError
)
from api_dnl.base_model import DnlApiBaseModel
from api_dnl import model
from datetime import datetime


def validate_currency(value):
    if model.Currency.filter(model.Currency.code==value).count() == 0:
        raise ValidationError('currency name is invalid.')

def validate_code_deck(value):
    if model.CodeDeck.filter(model.CodeDeck.name==value).count() == 0:
        raise ValidationError('code deck name is invalid.')

def _valid(cls_name,field,value):
        cls=model.__dict__[cls_name]
        if cls.filter('{}=={}'.format(field,value)).count() == 0:
            raise ValidationError('{} {} is invalid.'.format(field,value))
