# from falcon_rest.db import fields, orm , get_db
import csv
import falcon
import io
import json
from datetime import datetime,timedelta
from time import mktime

from dateutil.parser import parse as parse_datetime
from pytz import UTC
import traceback
from urllib.parse import parse_qsl, urlencode
# from falcon_rest.db import Column
# from falcon_rest.conf import settings
# from falcon_rest.contrib.files import create_file_model_class, create_scheme
# from falcon_rest.contrib.files.endpoints import UploadFile, GetDownloadLink, DownloadFile, ShowFile
# from marshmallow_sqlalchemy import field_for, fields as sa
from sqlalchemy import (desc)
from sqlalchemy import text as text_, and_, or_
from sqlalchemy.sql import func,select, case ,cast as cast_
from sqlalchemy.orm import aliased,make_transient

# from api_dnl.base_model import DnlApiBaseModel
# from api_dnl.model import rev


from api_dnl.resources import DnlCreate, DnlResource, DnlPatchManyResource, DnlList,CustomPatchAction,CustomAction,\
    CustomDeleteAction,DnlResourceAll,OperationErrorResponse
from falcon_rest import schemes, resources, responses
from falcon_rest.db.errors import IntegrityError, FkConstraintViolation
from falcon_rest.helpers import check_permission
from falcon_rest.logger import log
from falcon_rest.resources.resources import swagger, ResourcesBaseClass, DEFAULT_SECURITY, ATTRIBUTE_ERROR_RE
from falcon_rest.responses import errors

#from api_dnl.tasks import apply_mail_task
from api_dnl.scheme import *
from api_dnl.schemes.invoice import InvoiceAllStatusScheme
from api_dnl import scheme as my_scheme
from api_dnl.scheme import _valid,_valid_unique
from api_dnl.utils.dnl_switch import CallApi

class RateAllDelete(DnlResourceAll):
    has_modify_operation = False
    scheme_class = RateGetScheme
    model_class = model.Rate
    scheme_class_get = ObjectUpdatedScheme
    entity = 'Rate'

class RateTableAllDelete(DnlResourceAll):
    has_modify_operation = False
    scheme_class = RateTableGetScheme
    model_class = model.RateTable
    scheme_class_get = ObjectUpdatedScheme
    entity = 'RateTable'

class RandomAniGenerationAllDelete(DnlResourceAll):
    has_modify_operation = False
    scheme_class = RandomAniGenerationSchemeGet
    model_class = model.RandomAniGeneration
    scheme_class_get = ObjectUpdatedScheme
    entity = 'RandomAniGroup'

class DynamicRouteAllDelete(DnlResourceAll):
    #has_modify_operation = False
    scheme_class = DynamicRouteSchemeAllModify
    model_class = model.DynamicRoute
    scheme_class_get = ObjectUpdatedScheme
    entity = 'DynamicRoute'
    def update_object(self, req, resp, model_class, scheme_class, **kwargs):
        self.init_req(req)

        if hasattr(self.model_class, 'update_by'):
            self.req_data['update_by'] = self.get_user().name
        if hasattr(self.model_class,'update_on'):
            self.req_data['update_by'] = datetime.now(UTC)
        if hasattr(self.model_class,'update_at'):
            self.req_data['update_at'] = datetime.now(UTC)
        errors = scheme_class().validate(self.req_data)
        if errors:
            self.set_response(resp, responses.ValidationErrorResponse(data=errors))
            return False
        #result = self.model_class.query().update(self.req_data)
        query = self.get_query_filter(req, resp, model_class, **kwargs)
        result = 0
        for obj in query.all():
            try:
                scheme=scheme_class().load(self.req_data, instance=self.before_update(obj, req), partial=True)
                scheme.data.save()
                result += 1
            except Exception as e:
                log.error('mass edit error {}'.format(e))
        #result = query.update(self.req_data,synchronize_session='fetch')
        self.result=result
        #self.model_class.session().commit()
        self.set_response(resp, responses.SuccessResponseObjectInfo(data={'updated':result}))
        return False

class ProductAllDelete(DnlResourceAll):
    has_modify_operation = False
    scheme_class = ProductGetScheme
    model_class = model.Product
    scheme_class_get = ObjectUpdatedScheme
    entity = 'StaticRoute'

class ProductItemsAllDelete(DnlResourceAll):
    has_modify_operation = False
    scheme_class = ProductItemsGetScheme
    model_class = model.ProductItems
    scheme_class_get = ObjectUpdatedScheme
    entity = 'ProductItems'

class RouteStrategyAllDelete(DnlResourceAll):
    has_modify_operation = False
    scheme_class = RouteStrategyGetScheme
    model_class = model.RouteStrategy
    scheme_class_get = ObjectUpdatedScheme
    entity = 'RouteStrategy'

class RouteAllDelete(DnlResourceAll):
    has_modify_operation = False
    scheme_class = RouteGetScheme
    model_class = model.Route
    scheme_class_get = ObjectUpdatedScheme
    entity = 'Route'

class DigitTranslationAllDelete(DnlResourceAll):
    has_modify_operation = False
    scheme_class = DigitTranslationGetScheme
    model_class = model.DigitTranslation
    scheme_class_get = ObjectUpdatedScheme
    entity = 'DigitTranslation'

class TranslationItemAllDelete(DnlResourceAll):
    has_modify_operation = False
    scheme_class = TranslationItemGetScheme
    model_class = model.TranslationItem
    scheme_class_get = ObjectUpdatedScheme
    entity = 'TranslationItem'

class ResourceBlockAllDelete(DnlResourceAll):
    has_modify_operation = False
    scheme_class = ResourceBlockSchemeGet
    model_class = model.ResourceBlock
    scheme_class_get = ObjectUpdatedScheme
    entity = 'ResourceBlock'

class SwitchProfileAllDelete(DnlResourceAll):
    has_modify_operation = False
    scheme_class = SwitchProfileGetScheme
    model_class = model.SwitchProfile
    scheme_class_get = ObjectUpdatedScheme
    entity = 'SwitchProfile'

#config
class TimeProfileAllDelete(DnlResourceAll):
    has_modify_operation = False
    scheme_class = TimeProfileGetScheme
    model_class = model.TimeProfile
    scheme_class_get = ObjectUpdatedScheme
    entity = 'TimeProfile'

class RateGenerationTemplateAllDelete(DnlResourceAll):
    has_modify_operation = False
    scheme_class = RateGenerationTemplateGetScheme
    model_class = model.RateGenerationTemplate
    scheme_class_get = ObjectUpdatedScheme
    entity = 'RateGenerationTemplate'

class RateSendAllDelete(DnlResourceAll):
    has_modify_operation = False
    scheme_class = RateSendGetScheme
    model_class = model.RateSendLog
    scheme_class_get = ObjectUpdatedScheme
    entity = 'RateSendLog'


class MailSenderAllDelete(DnlResourceAll):
    has_modify_operation = False
    scheme_class = MailSenderGetScheme
    model_class = model.MailSender
    scheme_class_get = ObjectUpdatedScheme
    entity = 'MailSender'

class CarrierGroupAllDelete(DnlResourceAll):
    has_modify_operation = False
    scheme_class = CarrierGroupGetScheme
    model_class = model.CarrierGroup
    scheme_class_get = ObjectUpdatedScheme
    entity = 'CarrierGroup'

class TrunkGroupAllDelete(DnlResourceAll):
    has_modify_operation = False
    scheme_class = TrunkGroupGetScheme
    model_class = model.TrunkGroup
    scheme_class_get = ObjectUpdatedScheme
    entity = 'TrunkGroup'





class ProductRoutRateTableAllDelete(DnlResourceAll):
    has_modify_operation = False
    scheme_class = ProductRoutRateTableGetScheme
    model_class = model.ProductRoutRateTable
    scheme_class_get = ObjectUpdatedScheme
    entity = 'ProductRoutRateTable'

class SignupAllDelete(DnlResourceAll):
    has_modify_operation = False
    scheme_class = SignupGetScheme
    model_class = model.Signup
    scheme_class_get = ObjectUpdatedScheme
    entity = 'Signup'

class DidBillingPlanAllDelete(DnlResourceAll):
    has_modify_operation = False
    scheme_class = DidBillingPlanGetScheme
    model_class = model.DidBillingPlan
    scheme_class_get = ObjectUpdatedScheme
    entity = 'DidBillingPlan'

class DidBillingRelAllDelete(CustomDeleteAction):
    has_modify_operation = False
    scheme_class = DidBillingRelGetScheme
    model_class = model.DidBillingRel
    scheme_class_get = ObjectUpdatedScheme
    entity = 'DidBillingRel'
    query_parameters = [{"name": "dids", "description": "dids seperated by comma"},]

    def get_spec(self):
        return swagger.specify.get_spec(
            method=self.method, description=self.description,
            path_parameters=self.path_parameters,
            query_parameters=self.query_parameters,
            body_parameters=self.body_parameters,
            responses=(
                          responses.SuccessResponseJustOk(),
                          responses.ObjectNotFoundErrorResponse()
                      ) + self.additional_responses,
            security=self.get_security(method=self.method)
        )

    def apply(self, obj, req, resp, **kwargs):
        # from api_dnl.task.did_import_file import did_delete_all
        # from kombu.exceptions import OperationalError
        parsed_qs = dict(parse_qsl(req.query_string))
        # dids = parsed_qs.get('dids', None)
        # try:
        #     did_delete_all.delay(dids)
        #     log.debug('did_delete_all scheduled')
        # except OperationalError as e:
        #     did_delete_all(dids)
        # self.set_response(resp, responses.SuccessResponseJustOk())
        # return False
        from api_dnl.view import DidNumberUploadTaskCreate

        task_api = DidNumberUploadTaskCreate()
        dids = model.DidRepository.filter().all()
        req.data['paste'] = ','.join([did.did for did in dids])
        self.req.files = {}
        # req.data['vendor_billing_rule_name'] = obj.vendor_billing_rule_name
        # req.data['did_vendor_name'] = obj.did_vendor_name
        req.data['op_method'] = 'Delete'
        task_api.on_post(req, resp, **kwargs)
        self.set_response(resp, responses.SuccessResponseJustOk())


class CodeDeckAllDelete(DnlResourceAll):
    has_modify_operation = False
    scheme_class = CodeDeckGetScheme
    model_class = model.CodeDeck
    scheme_class_get = ObjectUpdatedScheme
    entity = 'CodeDeck'

class CodeAllDelete(DnlResourceAll):
    has_modify_operation = False
    scheme_class = CodeGetScheme
    model_class = model.Code
    scheme_class_get = ObjectUpdatedScheme
    entity = 'Code'

class JurisdictionPrefixAllDelete(DnlResourceAll):
    has_modify_operation = False
    scheme_class = JurisdictionPrefixGetScheme
    model_class = model.JurisdictionPrefix
    scheme_class_get = ObjectUpdatedScheme
    entity = 'JurisdictionPrefix'


class PaymentTermAllDelete(DnlResourceAll):
    has_modify_operation = False
    scheme_class = PaymentTermGetScheme
    model_class = model.PaymentTerm
    scheme_class_get = ObjectUpdatedScheme
    entity = 'PaymentTerm'

class CarrierTemplateAllDelete(DnlResourceAll):
    has_modify_operation = False
    scheme_class = CarrierTemplateGetScheme
    model_class = model.CarrierTemplate
    scheme_class_get = ObjectUpdatedScheme
    entity = 'CarrierTemplate'

class IngressTrunkTemplateAllDelete(DnlResourceAll):
    has_modify_operation = False
    scheme_class = IngressTrunkTemplateGetScheme
    model_class = model.IngressTrunkTemplate
    scheme_class_get = ObjectUpdatedScheme
    entity = 'IngressTrunkTemplate'

class EgressTrunkTemplateAllDelete(DnlResourceAll):
    has_modify_operation = False
    scheme_class = EgressTrunkTemplateGetScheme
    model_class = model.EgressTrunkTemplate
    scheme_class_get = ObjectUpdatedScheme
    entity = 'EgressTrunkTemplate'

class SendRateTemplateAllDelete(DnlResourceAll):
    has_modify_operation = False
    scheme_class = SendRateTemplateGetScheme
    model_class = model.SendRateTemplate
    scheme_class_get = ObjectUpdatedScheme
    entity = 'SendRateTemplate'

class RateUploadTaskAllDelete(DnlResourceAll):
    has_modify_operation = False
    scheme_class = RateUploadTaskGetScheme
    model_class = model.RateUploadTask
    scheme_class_get = ObjectUpdatedScheme
    entity = 'RateUploadTask'


