from urllib.parse import urlencode, parse_qsl
from datetime import datetime, timedelta
from pytz import UTC
from dateutil.parser import parse as parse_datetime
from sqlalchemy.exc import InternalError, IntegrityError, DataError
from sqlalchemy import and_, or_, inspect, alias, text, func, select, case, cast
from sqlalchemy.orm import aliased
from api_dnl import model
import falcon

from api_dnl.resources import check_context, DnlList, DnlResource, ValidationError, DnlCreate, CustomGetAction, \
    CustomPostAction, CustomDeleteAction
from api_dnl.schemes.sms_rate import SmsRateScheme, SmsRateTableScheme, SmsRateSchemeGet, SmsRateTableSchemeGet, \
    SmsRateSchemeModify, SmsRateTableSchemeModify

from api_dnl.view import DEFAULT_SECURITY, OperationErrorResponse


# region +++SmsRate+++
class SmsRateCreate(DnlCreate):
    scheme_class = SmsRateScheme
    model_class = model.SmsRate
    entity = 'SmsRate'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        user = self.get_user(self.req)
        # obj.created_by=user.name
        # obj.created_on=datetime.now(UTC)
        return obj


class SmsRateResource(DnlResource):
    model_class = model.SmsRate
    scheme_class = SmsRateScheme
    scheme_class_get = SmsRateSchemeGet
    scheme_class_modify = SmsRateSchemeModify
    entity = 'SmsRate'
    id_field = 'id'
    security = (DEFAULT_SECURITY)
    path_parameters = ()
    restrict = ()


class SmsRateList(DnlList):
    scheme_class = SmsRateSchemeGet
    model_class = model.SmsRate
    entity_plural = 'SmsRates'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, ret = super().modify_query_from_filtering_for_list(filtering, **kwargs)
        user = self.get_user(self.req)
        if not user.is_admin:
            cls = self.model_class
            # ret = ret.filter(cls.pool_id != 0)#TODO:filter for user
        return filt, ret


# endregion ---SmsRate---

# region +++SmsRateTable+++
class SmsRateTableCreate(DnlCreate):
    scheme_class = SmsRateTableScheme
    model_class = model.SmsRateTable
    entity = 'SmsRateTable'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def before_create(self, obj, **kwargs):
        user = self.get_user(self.req)
        obj.created_by=user.name
        obj.created_on=datetime.now(UTC)
        return obj


class SmsRateTableResource(DnlResource):
    model_class = model.SmsRateTable
    scheme_class = SmsRateTableScheme
    scheme_class_get = SmsRateTableSchemeGet
    scheme_class_modify = SmsRateTableSchemeModify
    entity = 'SmsRateTable'
    id_field = 'id'
    security = (DEFAULT_SECURITY)
    path_parameters = ()
    restrict = ()


class SmsRateTableList(DnlList):
    scheme_class = SmsRateTableSchemeGet
    model_class = model.SmsRateTable
    entity_plural = 'SmsRateTables'
    path_parameters = ()
    security = (DEFAULT_SECURITY)
    restrict = ()

    def modify_query_from_filtering_for_list(self, filtering, **kwargs):
        filt, ret = super().modify_query_from_filtering_for_list(filtering, **kwargs)
        user = self.get_user(self.req)
        if not user.is_admin:
            cls = self.model_class
            # ret = ret.filter(cls.pool_id != 0)#TODO:filter for user
        return filt, ret

    # endregion ---SmsRateTable---
