
# DNL Cloud Solution #

This project means to provide better cloud-based data management solution for DNL soft switch.


## Requirements ##

0. __Support CDR (new format) and PCAP data__

1. __Modularity__: the system consists of many independent daemons, managed by a single database. Thus errors/crushes in one of the modules do not block the entire functionality.

2. __Multiple data storages__: system shall support multiple types of remote storage. Configuration and API for each one of them should be modular, shared as library between all of the applications, thus providing an easy way to integrate new type of remote storage and switch between them.

3. __Dynamic switch configuration__: automatically detect active switches on server and re-configure db accordingly

4. __Fully configurable from UI__: all applications should read configuration parameters from PostgreSQL tables, and gracefully update without restart (where possible) on signal from UI.

5. __1-step installation__: ship with configuration tables, systemd entries, precompiled dependencies and installation/uninstall scripts

6. __UI integration__: share system information, errors and warnings, and necessary statistics, with UI via PostgreSQL tables

7. __Unified authorization__: every application (where required) must use JWT authorization method. It should be possible to access every application with a single token. The token generation should be performed in UI during login, thus eliminating the access issues caused by token expiration.


## Database ##

All applications should share a common Class database scheme:

* user/company tables - used for authentication and user-based preferences (such as automatic reports)
* CDR/PCAP data tables - list of all files and their state (local/compressed/remote)
* configuration tables - one per application, used to control app from UI
* app statistics tables - frequently updatable statistics and logging info of each application


## Applications ##

1. __DB Manager__ (based on DNL-backup-tool)

  Database manager shall identify all running switches on server, scan CDR/PCAP directories for new files every minute putting information about them into PostgreSQL, and compress outdated files or upload them to remote storage (if configured) once a day.
  Outdated files should be frequently removed from remote storage if configured.
  DB manager must frequently check for new switches to appear in system.

2. __Data retrieval__

  This module must provide unified API for downloading local and remote data. User does not need to know the origin of the requested file.
  For remote storage, it shall perform the downloading, redirecting output to the caller, as if user accessed the direct link for downloading.

3. __Data filtering__ (based on DNL-pcap-cdr-search)

  Filtering is similar to data retrieval, except it shall search through the data using provided parameters (ANI, DNIS, trunk-ID, etc.) and return only matching calls.

4. __Automatic reports__ (based on data filtering module)

  Module, which shall frequently perform filtering operation and send results to (s)ftp, google cloud, or other supported storage, based on client's preferences.
  At the end of the operation email notification should be sent if such is configured.


## Shipping ##

All applications must be shipped within a single package with pre-compiled uncommon dependencies (such as libmicrohttpd), default working configuration samples, systemd entries and PostgreSQL tables.
Package will include installation and uninstall scripts, which will provide easy 1-step installation and upgrade.
Due to modularity upgrade will not break current setup and shall not require additional steps.

In addition it is possible to create packages for deb/rpm based distros to automatically download missing dependencies available in default repositories.


## UI integration ##

Every application should use unified way of communication with UI via PostgreSQL tables, which includes per-application configuration, app status, error reporting, and common statistics (where necessary).
Additionally, UI will be able to signal each app to notify when its configuration has been changed and should be updated.


## Google Cloud integration options ##

There are tree ways to integrate Google Cloud storage:

### Using REST API ###

__pros__:

* Easy setup: set Oauth2 or System key with r/w permissions for bucket
  
__cons__:

- Google tends to change REST API without notification
- Filtering will require pre-downloading of each file before processing, which slows down the operation and requires additional space to store temporary files
 
### Mounting bucket with Google Cloud tools ###

__pros__:

* Applications cannot break due to update, because they operate with data on fs level
* Filtering does not require pre-downloading, thus is faster and less space consuming
  
__cons__:

- Client will need to install google tools, configure and manage them (_although the required steps may be integrated into UI_)

### Using Google VM ###

__pros__:

* Moving filtering from the main server to Google VM, thus making it faster and less resource-consuming
  
__cons__:

- Hard configuration
- Costly

### Conclusion ###

Implement first two types (REST API and mount), leaving client a choice between them. Implement Google VM later if necessary.


## Data filtering algorithms ##

### Plain ###

Using standard tools, such as wireshark and mawk

__pros__:

* Easy to implement
* Do not require additional space
  
__cons__:

- Low performance, especially with remote files

### Pre-indexed ###

Create index for each PCAP/CDR file with filtering parameters

__pros__:

* Faster: does not require pre-downloading of files, which don't match filtering patterns
  
__cons__:

- Resource-consuming: requires additional space to store indexes

### Conclusion ###

Implement the plain method of filtering as the first release version, and move to index-based later when proved to be necessary.


## Development plan ##

1. _Main data management application, based on DNL-backup-tool_

  - Make it a standalone daemon
  - Add PCAP support
  - Support multiple switches
  - Save information about the current state of all PCAP/CDR files in PostgreSQL DB
  - Frequently query info about active switches and PCAP/CDR directories from telnet
  - Validate and unify configuration. Make it fully UI accessible. Support graceful update (without restart) by notification
  - Prepare shared API libraries (for each storage type), pre-compiled dependencies, sample configuration, table schemes, build/install/uninstall scripts, systemd entries.
  - Remove outdated files from remote storage if configured

2. _Implement data retrieval module_

  - Unified authorization via JWT
  - API for UI to list all the data available for downloading: raw, compressed, remote
  - Common API for UI to retrieve file in spite of its location
  - Support FTP, SFTP, Google Cloud via REST API and mount
  - Integrate into the main system

3. _Implement plain PCAP/CDR filtering, based on DNL-pcap-cdr-search tool_

  - Modify existing algorithms to support local data, (s)ftp, and Google Cloud via REST API
  - Integrate into the main system

4. _Auto-querying to (S)FTP/GCloud_

  - Write module to automatically run query at specified time, send results to one of supported storage types.
  - Add email notifications on completion
  - Integrate into the main system

